#ifndef __LIGHT_HEADER_
#define __LIGHT_HEADER_

#include "graphics.h"
#include "vector.h"

/**
 *	This class describes a source of light
 */
class Light {

	union color d_rgb;
	vector3 d_pos;
	float d_intensity;

	public:
		Light(float *info);
		Light(float x, float y, float z, float intensity, union color rgba);

		float intensityAt(vector3 const &position) const;

		float intensity() const;
		vector3 &position();
		
		union color rgb() const;
		
	private:
		Light(Light const &other);				// NI
		Light &operator=(Light const &other); 	// NI
		
};


inline union color Light::rgb() const {
	return d_rgb;
}

inline float Light::intensity() const {
	return d_intensity;
}

inline vector3 &Light::position() {
	return d_pos;
}

#endif

