#include <cmath>
#include "lookup.h"


namespace {
	int nTblElements;
	float *tbl_cos, *tbl_sin;
}

void lu_init() {
	nTblElements = M_PI * 2 * 100;
	
	tbl_cos = new float[nTblElements];
	tbl_sin = new float[nTblElements];

	float step = 0.0f;
	for (int tblIdx = 0; tblIdx < nTblElements; ++tblIdx) {
		
		tbl_cos[tblIdx] = cosf(step);
		tbl_sin[tblIdx] = sinf(step);
		
		step += 0.01f;
	}
}


float lu_sin(float f) {
	int idx = static_cast<int>(f * 100) % nTblElements;
	if (idx < 0) 
		idx += nTblElements;
	
	return tbl_sin[idx];	
}

float lu_cos(float f) {
	int idx = static_cast<int>(f * 100) % nTblElements;
	if (idx < 0) 
		idx += nTblElements;

	return tbl_cos[idx];
}
