#include <iostream>

#include "lookup.h"
#include "rotozoom.h"
#include "graphics.h"

using namespace std;

int main()
{
	lu_init();

	Gfx gfx(400, 400);
	
	Rotozoom zoom(
				gfx,
				gfx.picture("./static/roto.png"),
				gfx.picture("./static/normalmap.png")
			);

	SDL_Event event;
	bool running = true;
	
	float angle = 0.0f;
	float position = 0.0f;
	
	Uint32 lastTick = SDL_GetTicks();
	
	zoom.angle(.1 * M_PI);	
		

	while (running) {

		gfx.clear();
		zoom.draw();
		gfx.flip();	
		
		// apparently there was an event
		if (SDL_PollEvent(&event) == 1) {
			if (event.type == SDL_QUIT) {
				running = false;
				break;
			}
			
		}

		// adjust stuff
		Uint32 ticks = SDL_GetTicks();
	
		size_t framesPast = (ticks - lastTick) / UPDATES_PER_FRAME;
		lastTick = ticks;
		
		angle += sinf(0.003f * framesPast);
		position += angle;
		for (int idx = 0; idx < 4; ++idx) {
			zoom.lightModel().light(idx).position().x = 200 + sinf(angle * idx * 2) * (10 * idx + 100);
			zoom.lightModel().light(idx).position().z = 200 + cosf(angle * idx) * (20 * idx + 100);
		}

		zoom.angle(sinf(angle));	
		zoom.distance(.8 + 0.5 * sinf(angle));
	}

    return 0;
}
