#ifndef __ROTOZOOM_HEADER_
#define __ROTOZOOM_HEADER_

#include <SDL/SDL.h>
#include <cmath>

#include "graphics.h"
#include "config.h"
#include "vector.h"
#include "scene.h"
#include "lightmodel.h"


/** 
 *	Rotozoom class
 */
class Rotozoom {

	Gfx &d_gfx;
	LightModel d_lightModel;
	vector3 *d_normalMap;
	union color *d_picture;
	int d_picWidth;
	
	float 
		d_x, d_y,
		d_distance, 
		d_angle;

	public:
	
		Rotozoom(Gfx &gfx, SDL_Surface *pic, SDL_Surface *normalMap);
		~Rotozoom();

		float wrap(float u, int wrapAt) const;

		void offset(float x, float y);
		void angle(float f);
		void distance(float d);
		
		LightModel &lightModel();
		void draw();
		
	private:
		
		void initializeSurfaces(SDL_Surface *pic, SDL_Surface *nmap);
};


inline Rotozoom::Rotozoom(Gfx &gfx, SDL_Surface *pic, SDL_Surface *normalMap) 
:
	d_gfx(gfx),
	d_lightModel(lightInfo, nLights),
	d_x(0), d_y(0),
	d_distance(DEFAULT_DISTANCE),
	d_angle(0.0f)
{
	d_picWidth = pic->w;
	d_lightModel.setAmbientLight(gfx.color(150, 150, 150));
	initializeSurfaces(pic, normalMap);
}

inline Rotozoom::~Rotozoom() {
	delete[] d_normalMap;
	delete[] d_picture;
}

inline LightModel &Rotozoom::lightModel() {
	return d_lightModel;
}

inline void Rotozoom::offset(float x, float y) {
	d_x = x;
	d_y = y;
}

inline void Rotozoom::angle(float angle) {
	d_angle = angle;
}

inline void Rotozoom::distance(float distance) {
	d_distance = distance;
}

inline float Rotozoom::wrap(float v, int wrapAt) const {
	return v - floor(v / wrapAt) * wrapAt;
}

#endif

