#ifndef __VECTOR_HEADER_
#define __VECTOR_HEADER_

struct vector3 {
	
	float x;
	float y;
	float z;
	
	public:
		vector3() {
		}
		
		vector3(float aX, float aY, float aZ)
		:
			x(aX), 
			y(aY), 
			z(aZ) 
		{}
		
		vector3(vector3 const &other) 
		:
			x(other.x),
			y(other.y),
			z(other.z)
		{
		}
		
		vector3 &operator=(vector3 const &other) {
			x = other.x;
			y = other.y;
			z = other.z;
			return *this;
		}
};

/*
 *	vector related function definitions	
 */
 
float vec_length(vector3 const &distance);
void vec_normalize(vector3 &normalize, vector3 const &input);
void vec_direction_vector(vector3 &dVec, vector3 const &from, vector3 const &to);
float vec_dotproduct(vector3 const &a, vector3 const &b);

#endif

