;
; Taylor Sinetable Generation (& Postprocessor Implementation Demo)
;
; To make 4KB Intros small. Published together with the Imphobia VIII issue.
;
; Written in 1994 by Markus Stein alias Stone/Dust
;

code    segment
        assume cs:code,ds:code
        org 100h
        locals
        .386

;
; MAIN
;

start:  cld                       ;clear direction flag
        mov di,offset zeroed_data_start
        mov cx,offset zeroed_data_end-zeroed_data_start
        push ds
        pop es
        xor al,al
        rep stosb                 ;init zeroed data (s. postprocessor)

        call generate_taylor_sinetab

EXIT:   mov ah,4ch                ;exit
        int 21h
;----------------------------------

;
; GENERATE SINE & COSINE LOOKUP-TABLE USING TAYLOR'S APPROXIMATION
; - fixed point integer math: 02b.30b
;

SINETAB_LENGTH  equ 4096          ;number of DWords sinetab will consist of
;----------------------------------

GENERATE_TAYLOR_SINETAB proc      ;GENERATE SINETABLE
        mov ebp,40000000h          ;ebp = 1.0
        xor esi,esi                ;variable x
        xor cx,cx                  ;index for destination in table

@@01:   push cx                   ;calculate taylor's approximation for both
        mov sinvalue,esi          ;sines and cosines
        mov cosvalue,ebp
        xor edi,edi
        inc di
@@02:   call @@sub
        sub cosvalue,eax
        call @@sub
        sub sinvalue,eax
        call @@sub
        add cosvalue,eax
        call @@sub
        add sinvalue,eax
        cmp di,13
        jne @@02
        pop cx

        mov eax,sinvalue          ;convert to 16b.16b
        sar eax,14
        mov ebx,cosvalue
        sar ebx,14
        mov di,offset sinetab     ;and store in table (sine and cosine values)
        add di,cx
        mov [di]+(sinetab_length/4*0)*4,eax
        mov [di]+(sinetab_length/4*1)*4,ebx
        mov [di]+(sinetab_length/4*4)*4,eax
        sub di,cx
        sub di,cx
        mov [di]+(sinetab_length/4*2)*4,eax
        mov [di]+(sinetab_length/4*1)*4,ebx
        mov [di]+(sinetab_length/4*5)*4,ebx
        neg eax
        neg ebx
        mov [di]+(sinetab_length/4*4)*4,eax
        mov [di]+(sinetab_length/4*3)*4,ebx
        add di,cx
        add di,cx
        mov [di]+(sinetab_length/4*2)*4,eax
        mov [di]+(sinetab_length/4*3)*4,ebx

        add esi,1921f6h           ;next x value (pi/(sintab_length/8*4)*2^30)
        add cx,4
        cmp cx,(sinetab_length/8) * 4
        jbe @@01
        ret

@@sub:  inc di                    ;EAX <- x ^ (++count) / (count!)
        mov eax,ebp
        xor ebx,ebx
        inc bx
        mov ecx,edi
@@sub@1:imul esi
        shrd eax,edx,30
        imul ebx,ecx
        loop @@sub@1
        cdq
        idiv ebx
        ret
GENERATE_TAYLOR_SINETAB endp
;--------------------------------------------------

;
; ZEROED DATA
;

ZEROED_DATA_START label
;---------------------------------- SINETABLE

        align 4
SINVALUE     dd 0
COSVALUE     dd 0
SINETAB      dd sinetab_length/4 dup (0)
COSINETAB    dd sinetab_length dup (0)
             dd 0
;----------------------------------

ZEROED_DATA_END label
;----------------------------------

;
code    ends
        end start