start_GDT macro
mem32_GDT dw 4 dup(0)
mem32_ptr_GDT_act=8
endm

GDT_seg macro name,type
mem32_ptr_GDT_&name&=mem32_ptr_GDT_act
mem32_ptr_GDT_act=mem32_ptr_GDT_act+8
ifidni <type>,<c16>
	dw 0ffffh,0,9a00h,0
elseifidni <type>,<c32>
if enable_c32 eq 1
	dw 0ffffh,0,9a00h,0cfh
else
	dw 0ffffh,0,9a00h,0
endif
elseifidni <type>,<d16>
	dw 0ffffh,0,9200h,0
elseifidni <type>,<d32>
	dw 0ffffh,0,9200h,8fh
else
%out type incorrect dans GDT_seg
endif
endm

end_GDT macro seg_name
mem32_ptr_GDT label fword
	dw mem32_ptr_GDT_act-1
	dd offset seg_name:mem32_GDT
	dw 0
endm

init_GDT macro
	movzx eax,ax
	shl eax,4
	add dword ptr mem32_ptr_GDT+2,eax
	mov si,offset ds:mem32_GDT
	lgdt fword ptr mem32_ptr_GDT
endm

init_GDT_base_seg macro name
	movzx eax,ax
	shl eax,4
	mov word ptr [si+mem32_ptr_GDT_&name&+2],ax
	ror eax,16
	mov byte ptr [si+mem32_ptr_GDT_&name&+4],al
endm

init_GDT_base_addr macro name
	mov word ptr [si+mem32_ptr_GDT_&name&+2],ax
	ror eax,16
	mov byte ptr [si+mem32_ptr_GDT_&name&+4],al
	mov byte ptr [si+mem32_ptr_GDT_&name&+7],ah
endm

disable_NMI macro
if use_NMI eq 1
	in al,70h
	mov ah,al
	mov al,80h
	out 70h,al
endif
endm

enable_NMI macro
if use_NMI eq 1
	out 70h,al
endif
endm

disable_interrupts macro
	cli
	disable_NMI
endm

enable_interrupts macro
	enable_NMI
	sti
endm

mem32_find_segment_type macro
mem32_here=$
push ax
mem32_size=$-mem32_here
org mem32_here
endm

switch_prot macro seg,off
mem32_find_segment_type
	mov eax,cr0
	or al,1
	mov cr0,eax
	db 0eah
if mem32_size eq 1
	dw offset off
else
	dd offset off
endif
	dw mem32_ptr_GDT_&seg
endm

switch_real macro seg,off
mem32_find_segment_type
	mov eax,cr0
	and al,0feh
	mov cr0,eax
	db 0eah
if mem32_size eq 1
	dw offset off
else
	dd offset off
endif
	dw seg
endm
