#include "Main.h"
#include "ProgramObject.h"

ProgramObject* programObject;
bool           bLButton = false;
POINT          lButtonPoint;

long __stdcall WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch(message)
  {
  case WM_CLOSE:
    ExitProcess(0);
    break;

  case WM_LBUTTONDOWN:
    GetCursorPos(&lButtonPoint);
    bLButton = true;
    SetCapture(hWnd);
    break;

  case WM_LBUTTONUP:
    bLButton = false;
    ReleaseCapture();
    break;

  case WM_MOUSEMOVE:
    {
      if(!bLButton)
      { 
        break;
      }
      POINT point;
      GetCursorPos(&point);
      float dx = float(lButtonPoint.x - point.x) / 1000.0f;
      float dy = float(lButtonPoint.y - point.y) / 1000.0f;
      (*programObject)["a"] = (*programObject)["a"] + dx;
      (*programObject)["b"] = (*programObject)["b"] + dy;
      lButtonPoint = point;
    }
    break;

  case WM_RBUTTONDOWN:
    (*programObject)["a"] = 0;
    (*programObject)["b"] = 0;
    break;

  case WM_SIZE:
    {
      float w = LOWORD(lParam);
      float h = HIWORD(lParam);
      glViewport(0, 0, w, h);
      glMatrixMode(GL_PROJECTION);
      glLoadIdentity();
      gluPerspective(60.0, w / h, 0.1, 128);
      glMatrixMode(GL_MODELVIEW);
    }
    break;
  }
  return DefWindowProc(hWnd, message, wParam, lParam);
}

int __stdcall WinMain(HINSTANCE, HINSTANCE, char*, int)
{
  WNDCLASSEX wcex;
  ZeroMemory(&wcex, sizeof(WNDCLASSEX));
  wcex.cbSize        = sizeof(WNDCLASSEX);
  wcex.hCursor       = LoadCursor(0, IDC_CROSS);
  wcex.hInstance     = GetModuleHandle(0);
  wcex.lpfnWndProc   = WndProc;
  wcex.lpszClassName = "Julia & GLSL";
  wcex.style         = CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
  RegisterClassEx(&wcex);

  HWND hWnd = CreateWindowEx(0, "Julia & GLSL", "Julia & GLSL", WS_OVERLAPPEDWINDOW | WS_VISIBLE, 0, 0, 0, 0, 0, 0, 0, 0);
  HDC hDC = GetDC(hWnd);

  PIXELFORMATDESCRIPTOR pfd;
  ZeroMemory(&pfd,sizeof(PIXELFORMATDESCRIPTOR));
  pfd.nSize=sizeof(PIXELFORMATDESCRIPTOR);
  pfd.nVersion        = 1;
  pfd.dwFlags         = 549;
  pfd.iPixelType      = 0;
  pfd.cColorBits      = 32;
  pfd.cRedBits        = 8;
  pfd.cGreenBits      = 8;
  pfd.cBlueBits       = 8;
  pfd.cAlphaBits      = 8;
  pfd.cRedShift       = 16;
  pfd.cGreenShift     = 8;
  pfd.cBlueShift      = 0;
  pfd.cAlphaShift     = 24;
  pfd.cAccumBits      = 64;
  pfd.cAccumRedBits   = 16;
  pfd.cAccumGreenBits = 16;
  pfd.cAccumBlueBits  = 16;
  pfd.cAccumAlphaBits = 16;
  pfd.cDepthBits      = 24;
  pfd.cStencilBits    = 8;
  pfd.cAuxBuffers     = 4;
  pfd.bReserved       = 0;
  pfd.dwVisibleMask   = 0;
  int iPixelFormat    = ChoosePixelFormat(hDC, &pfd);
  SetPixelFormat(hDC, iPixelFormat, &pfd);

  HGLRC hRC = wglCreateContext(hDC);
  wglMakeCurrent(hDC, hRC);

  glInitExtensions();

  programObject = new ProgramObject;
  programObject->LoadProgram("Julia");
  programObject->AddUniform("a");
  programObject->AddUniform("b");

  MoveWindow(hWnd, 320, 240, 640, 480, 1);

  MSG msg;
  do
  {
    if(PeekMessage(&msg, 0, 0, 0, PM_NOREMOVE))
    {
      GetMessage(&msg, 0, 0, 0);
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    else
    {
      glClear(GL_COLOR_BUFFER_BIT);
      glLoadIdentity();
      gluLookAt(-2, 0, 0, 0, 0, 0, 0, 0, 1);

      glBegin(GL_QUADS);
        glTexCoord2f(0, 0); glVertex3f(0, -1, -1);
        glTexCoord2f(1, 0); glVertex3f(0,  1, -1);
        glTexCoord2f(1, 1); glVertex3f(0,  1,  1);
        glTexCoord2f(0, 1); glVertex3f(0, -1,  1);
      glEnd();

      SwapBuffers(hDC);
    }
  }
  while(!GetAsyncKeyState(VK_ESCAPE));
}