#include "Main.h"
#include "ProgramObject.h"

ProgramObject::ProgramObject()
: m_Handle(glCreateProgramObjectARB())
{

}

ProgramObject::~ProgramObject()
{
  glDeleteObjectARB(m_Handle);
}

void ProgramObject::AddUniform(const string& name)
{
  int t =  glGetUniformLocationARB(m_Handle, name.c_str());
  m_Uniforms.insert(TUniformPair(name, glGetUniformLocationARB(m_Handle, name.c_str())));
}

void ProgramObject::LoadProgram(const string& programName)
{
  string fragName = programName + ".fs";
  ifstream fragStream(fragName.c_str());
  m_FragmentShader.SourceFromFile(fragStream);
  m_FragmentShader.Compile();
  glAttachObjectARB(m_Handle, m_FragmentShader.m_Handle);
  glLinkProgramARB(m_Handle);

  {
    char temp[1024];
    int length = 1023;
    glGetInfoLogARB(m_Handle, 1024, &length, temp);
    if(length)
    {
      MessageBox(0, temp, 0, 0);
    }
  }

  glValidateProgramARB(m_Handle);
  glUseProgramObjectARB(m_Handle);
}