#pragma once

#include "FragmentShader.h"

class ProgramObject
{
public:

  typedef map<string, int>  TUniformMap;
  typedef pair<string, int> TUniformPair;

  class Wrapper
  {
  public:

    GLhandleARB m_Handle;
    int         m_Uniform;

    Wrapper(GLhandleARB handle, int uniform): m_Handle(handle), m_Uniform(uniform) {}
    void operator = (float value)
    {
      glUniform1fARB(m_Uniform, value);
    }
    operator float()
    {
      float value;
      glGetUniformfvARB(m_Handle, m_Uniform, &value);
      return value;
    }
  };

  GLhandleARB    m_Handle;
  FragmentShader m_FragmentShader;

  TUniformMap    m_Uniforms;

  ProgramObject();
  ~ProgramObject();

  Wrapper operator [] (const string& name)
  {
    return Wrapper(m_Handle, m_Uniforms[name]);
  }

  void operator () ()
  {
    glUseProgramObjectARB(m_Handle);
  }

  void AddUniform(const string& name);

  void LoadProgram(const string& programName);
};