#include "Map.h"

void	CMap::Bind(){
	glBindTexture( GL_TEXTURE_2D, TexID );
}

void	CMap::Generate( unsigned char* Data ){
	glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,Width,Height,0,GL_RGBA,GL_UNSIGNED_BYTE,Data);
}

void	CMap::CreateVoid( int w, int h ){
	Width = w;
	Height = h;
	glGenTextures( 1, &TexID );
	glBindTexture( GL_TEXTURE_2D, TexID );
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	Generate( NULL );
}

void	CMap::Free(){
	glDeleteTextures( 1, &TexID );
	ilDeleteImages(1, &ImgID);
}

bool	CMap::LoadImage( const char* Name ){
	ilGenImages(1, &ImgID);
	ilBindImage(ImgID);
	ilLoadImage((char*)Name);
	ilutRenderer(ILUT_OPENGL);
	TexID = ilutGLBindTexImage();
	return true;
}

void	CMap::SetViewport(){
	glViewport( 0, 0, Width, Height );
	glMatrixMode   ( GL_PROJECTION );
	glLoadIdentity ();
	gluPerspective ( 60.0f, (float)Width / (float)Height, 0.1f, 400.0f );
	glMatrixMode   ( GL_MODELVIEW );
	glLoadIdentity ();
}

void	CMap::RenderTo(){
	glBindTexture( GL_TEXTURE_2D, TexID );
	glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, Width, Height);
}
