#include "Shader.h"

void	CShader::Bind( float DeltaTime ){
	TimePos += TimeSpeed * DeltaTime;
	glUseProgramObjectARB( ProgramObject );

	int pos = glGetUniformLocationARB(ProgramObject, "pos");
	glUniform1fARB( pos, TimePos ); 

}

void	CShader::Unbind(){
	glUseProgramObjectARB( 0 );
}

void	CShader::Unload(){
}

void	CShader::CheckErrors( GLhandleARB h, GLenum param ){
	int glsl_ok, l;
	char str[1024];
	glGetObjectParameterivARB(h, param, &glsl_ok);
	glGetInfoLogARB(h, 1024, &l, str);
	if ( str[0] != 0 ){
		MessageBox( NULL, str, "GLSL compile log", MB_OK );
	}
}

bool	CShader::Compile( const char* vp, const char* fp ){
	int len;
	if ( !vp || !fp ) return false;
	VertexCode		= vp;
	FragmentCode	= fp;
	ProgramObject	= glCreateProgramObjectARB();
	VertexShader	= glCreateShaderObjectARB( GL_VERTEX_SHADER_ARB );
	FragmentShader	= glCreateShaderObjectARB( GL_FRAGMENT_SHADER_ARB );
	len = strlen( VertexCode );				glShaderSourceARB( VertexShader, 1, &VertexCode, &len );
	len = strlen( FragmentCode );			glShaderSourceARB( FragmentShader, 1, &FragmentCode, &len );
	glCompileShaderARB( VertexShader );		CheckErrors( VertexShader, GL_OBJECT_COMPILE_STATUS_ARB );
	glCompileShaderARB( FragmentShader );	CheckErrors( FragmentShader, GL_OBJECT_COMPILE_STATUS_ARB );
	glAttachObjectARB( ProgramObject, VertexShader );
	glAttachObjectARB( ProgramObject, FragmentShader );
	glLinkProgramARB( ProgramObject );
	glValidateProgramARB( ProgramObject );
	Bind( 0 );
	int tex0 = glGetUniformLocationARB( ProgramObject, "tex0" );	glUniform1iARB( tex0, 0 );
	int tex1 = glGetUniformLocationARB( ProgramObject, "tex1" );	glUniform1iARB( tex1, 1 );
	int tex2 = glGetUniformLocationARB( ProgramObject, "tex2" );	glUniform1iARB( tex2, 2 );
	int tex3 = glGetUniformLocationARB( ProgramObject, "tex3" );	glUniform1iARB( tex3, 3 );
	Unbind();
	return true;
}
