#pragma once

#include "Types.h"

class	CTimer{
private:
	uint64	StartTime;
	float	Frequency;
public:
	void	Start(){
		QueryPerformanceCounter( (LARGE_INTEGER*)&StartTime );
	}
	float	Elapsed(){
		uint64	Time;
		if ( Frequency == 0 ) return 0;
		QueryPerformanceCounter( (LARGE_INTEGER*)&Time );
		return ( (float)(uint)( Time - StartTime ) ) / Frequency * (1.0f/256.0f);
	}
	CTimer(){
		StartTime = 0;
		uint64	Freq;
		QueryPerformanceFrequency( (LARGE_INTEGER*)&Freq );
		int ifr = *(int*)( (byte*)&Freq + 1 );// /256
		Frequency = (float)(int)ifr;
	}
};
