PROGRAM SetVESAPixel;

USES CRT,DOS;

TYPE Zeiger = RECORD
      Offset,Segment : WORD;
     END;

VAR Regs            : Registers;
    i,j,xAufloesung : WORD;
    Granu           : LONGINT;
    Puffer          : ARRAY[0..255] OF BYTE;
    FensterProc     : Zeiger;

PROCEDURE SetVESAPixPascal(x,y : LONGINT; Farbe : BYTE);
VAR Anzahl : WORD;
    Offset : LONGINT;
BEGIN
 Offset := y * xAufloesung + x;   {Offset berechnen}
 Anzahl := Offset DIV Granu;      {Wie oft mu Fenster verschoben
                                   werden?}
 Offset := Offset MOD Granu;      {Neuer Offset im verschobenen
                                   Fenster}
{ WITH Regs DO BEGIN
  AX := $4F05;
  BX := $0000;
  DX := Anzahl;
  INTR($10,Regs);                 {Fenster verschieben
 END;}
  ASM
   XOR BX,BX
   MOV DX,Anzahl
   CALL DWORD PTR FensterProc;    {Fenster verschieben}
  END;
  MEM[$A000:Offset] := Farbe;
END;

PROCEDURE InitSetVESAPixPascal;
BEGIN
WITH Regs DO BEGIN
  AX := $4F03;
  INTR($10,Regs);     {Liefert VESAModus in BX zurck}
  CX := BX;           {Vesa-Modus nach CX}
  ES := Seg(Puffer);  {Segment von Puffer nach ES}
  DI := Ofs(Puffer);  {Offset von Puffer nach DI}
  AX := $4F01;        {Vesa-Infos holen}
  INTR($10,Regs);     {und in ES:DI/Puffer ablegen}
  xAufloesung := Puffer[$13] * 256 + Puffer[$12];
  Granu       := (Puffer[$05] * 256 + Puffer[$04]) SHL 10;
         {Granu = Granu * 1024}
  FensterProc.Offset  := Puffer[$0D] * 256 + Puffer[$0C];
  FensterProc.Segment := Puffer[$0F] * 256 + Puffer[$0E];
         {Offset+Segment der Routine zum Fensterverschieben}
 END;
END;

BEGIN
 Randomize;
 WITH Regs DO BEGIN
  AX := $4F02;
  BX := $101;         {Modus : 101h/480x640x256}
  INTR($10,Regs);     {Initialisiere VESA-Modus}
 END;
 InitSetVESAPixPascal;
 FOR i := 1 TO 50000 DO
  SetVesaPixPascal(Random(640),Random(480),Random(256));
 ReadLn;
 Regs.AX := $0003;
 INTR($10,Regs);     {Zurck in den Textmodus}
END.