UNIT Maus;        {Alles Assembler von Kemil}

INTERFACE

 PROCEDURE InitMouse;
 PROCEDURE ShowCursor;
 PROCEDURE HideCursor;
 PROCEDURE SetMousePos(x,y:WORD);
 FUNCTION XPos : WORD;
 FUNCTION YPos : WORD;
 FUNCTION LeftButtonPressed : Boolean;
 FUNCTION RightButtonPressed : Boolean;
 PROCEDURE WaitForLeftButtonRelease;
 PROCEDURE WaitForRightButtonRelease;
 PROCEDURE SetXYRange(MinX,MaxX,MinY,MaxY : WORD);

IMPLEMENTATION

PROCEDURE InitMouse; Assembler;
ASM
 XOR AX,AX
 INT 33h
END;

PROCEDURE ShowCursor; Assembler;
ASM
 MOV AX,1
 INT 33h
END;

PROCEDURE HideCursor; Assembler;
ASM
 MOV AX,2
 INT 33h
END;

PROCEDURE SetMousePos(x,y:WORD); Assembler;
ASM
 MOV AX,4
 MOV CX,x
 MOV DX,y
 INT 33h
END;

FUNCTION XPos : WORD; Assembler;
ASM
 MOV AX,3
 INT 33h
 MOV AX,CX     {'WORD-Zurckgabe' durch's AX-Register!}
END;

FUNCTION YPos : WORD; Assembler;
ASM
 MOV AX,3
 INT 33h
 MOV AX,DX     {'WORD-Zurckgabe' durch's AX-Register!}
END;

FUNCTION LeftButtonPressed : Boolean; Assembler;
ASM;
 MOV AX,3
 INT 33h
 MOV AX,BX
 AND AX,1
END;

FUNCTION RightButtonPressed : Boolean; Assembler;
ASM
 MOV AX,3
 INT 33h
 MOV AX,BX
 AND AX,2
END;

PROCEDURE WaitForLeftButtonRelease; Assembler;
ASM
 @Warte:
  Call LeftButtonPressed
  JNZ @Warte
END;

PROCEDURE WaitForRightButtonRelease; Assembler;
ASM
 @Warte:
  Call RightButtonPressed
  JNZ @Warte
END;

PROCEDURE SetXYRange(MinX,MaxX,MinY,MaxY : WORD); Assembler;
ASM
 MOV AX,7
 MOV CX,MinX
 MOV DX,MaxX
 INT 33h
 MOV AX,8;
 MOV CX,MinY
 MOV DX,MaxY
 INT 33h
END;

BEGIN
END.
