Program Transzformacio;

Uses Crt,Graph, Raster;

Const Haromsag = 2;

Type  TombType = Array[1..1000] Of PointType;

Var   MaxX,MaxY  : Integer;  { A kperny maximlis X s Y koordintja }
      Paper,Ink  : Integer;  { A httr s tinta szine                  }
      AlapB      : TombType; { Az eredeti pontok alappontjai            }
      EredetiB   : TombType; { Az eredeti pontok                        }
      EltoltB    : TombType; { Az eltolt pontok                         }
      SkalazottB : TombType; { A sklzott pontok                       }
      ForgatottB : TombType; { A forgatott pontok                       }
      PontSzam   : Integer;  { Hny pontbl ll a grbe                 }
      Szam       : Integer;  { Hol tart a tmbben a szmols            }
      K          : Integer;  { Ciklus vltoz                           }
      Key        : Char;     { Billentyzet figyels                    }
      Ki         : Boolean;  { Kilpshez vltoz                       }

{----------------Grafikus kpernyk hozzszerkesztse------------------------}

{$L EgaVga.obj}
Procedure EgaVgaDriverProc; External;

{------------------------Grafikus kperny detektlsa-----------------------}

Procedure GraphOpen;
  Var GD,GM : Integer;
  Begin
    DetectGraph(GD,GM);
    If RegisterBGIDriver(@EgaVgaDriverProc)<0   Then Halt;
    InitGraph(GD,GM,'');
    If GraphResult<>0 Then Halt;
    MaxX := GetMaxX;
    MaxY := GetMaxY;
    If GD = VGA Then Begin
                       Paper := Black;
                       Ink   := White;
                     End;
    SetColor(Ink);
    SetBKColor(Paper);
    ClearDevice;
  End;

{-------------A Bezier grbe generlsa vletlenszer pontokbl--------------}

Procedure Generalas(Var VPoint:TombType);
  Const RX = 300;
        RY = 180;
  Var I,C,S : integer;
  Begin
    Randomize;
    For I := 1 To 4 Do
      Begin
        VPoint[I].X := Random(RX);
        VPoint[I].Y := Random(RY);
      End;
    Inc(I);
    VPoint[I].X := 2*VPoint[I-1].X - VPoint[I-2].X;
    VPoint[I].Y := 2*VPoint[I-1].Y - VPoint[I-2].Y;
    S := I+1;
    For I := 1 To Haromsag Do
      Begin
        VPoint[S].X := Random(RX);
        VPoint[S].Y := Random(RY);
        Inc(S);
        VPoint[S].X := Random(RX);
        VPoint[S].Y := Random(RY);
        Inc(S);
        VPoint[S].X := 2*VPoint[S-1].X - VPoint[S-2].X;
        VPoint[S].Y := 2*VPoint[S-1].Y - VPoint[S-2].Y;
        Inc(S);
      End;
    PontSzam := S-1;
  End;

{-----------------------A Bezier grbe elksztse---------------------------}

Procedure BezierGorbe(P1,P2,P3,P4 : PointType; Var Vpoint:TombType);
  Var T1,T3,T2      : Real;
      T_1,T_12,T_13 : Real;
      Nov           : Real;
  Begin
    T1  := 0;
    Nov := 0.02;
    While T1 <= (1+nov) Do
      Begin
        T_1  := 1-T1;
        T_12 := T_1 * T_1;
        T_13 := T_12 * T_1;

        T2   := T1 * T1;
        T3   := T2 * T1;

        VPoint[Szam].X := Round(T_13*P1.X + 3*T1*T_12*P2.X + 3*T2*T_1*P3.X+T3*P4.X);
        VPoint[Szam].Y := Round(T_13*P1.Y + 3*T1*T_12*P2.Y + 3*T2*T_1*P3.Y+T3*P4.Y);

        T1 := T1 + Nov;
        Inc(Szam);
      End;
  End;

{------------------------A Bezier grbe megrajzolsa-------------------------}

Procedure BezierDraw;
  Var G : Integer;
  Begin
    G := 1;
    Szam := 1;
    While G <= (PontSzam-3) Do
      Begin
        BezierGorbe(AlapB[G],AlapB[G+1],AlapB[G+2],AlapB[G+3],EredetiB);
        G := G + 3;
      End;
  End;

{---------------A Bezier grbe csucspontjainak megrajzolsa------------------}

Procedure BezierCsucsok(VPoint:TombType);
  Var I,K : Integer;
      S   : String;
  Begin
    SetColor(10);
    K := 1;
    For I := 1 To PontSzam-1 Do
      Begin
        If ((I mod 3) = 1) Or (I=1) Then
          Begin
            Circle(VPoint[I].X,VPoint[I].Y,2);
            Str(K,S);
            Outtextxy(VPoint[I].X+2,VPoint[I].Y+2,S);
            Inc(K);
          End;
      End;
  End;

{--------------------Window to viewport transzformci-----------------------}

Procedure WTVT(X,Y,XMin,XMax,YMin,YMax,UMin,UMax,VMin,VMax: Integer;Var Pa,Pb : TombType; Rajz:Boolean);
  Var E,F,G,H : Real;
      I       : Integer;
      Vagas   : Boolean;
  Begin
    E   := (UMax - UMin) / (XMax - Xmin);
    F   := (-XMin * E) + UMin;
    G   := (VMax - VMin) / (YMax - YMin);
    H   := (-YMin * G) + VMin;

    SetColor(White);
    Vagas := False;

    For I := 1 To Szam-1 Do
      Begin
        Pb[I].X := X + Trunc(E*(Pa[I].X) + F);
        Pb[I].Y := Y + Trunc(G*(Pa[I].Y) + H);
        If (Pb[I].X > X + UMin) And (Pb[I].X < X + UMax) And
           (Pb[I].Y > Y + VMin) And (Pb[I].Y < Y + VMax) And Rajz Then
           Begin
             If (I=1) Or Not Vagas Then Begin
                                          MoveTo(Pb[I].X,Pb[I].Y);
                                          Vagas := True;
                                        End
                                   Else LineTo(Pb[I].X,Pb[I].Y);
           End
           Else Vagas := False;
     End;
  End;

{--------------------------------Forgats------------------------------------}

Procedure Forgatas(VPointA:TombType; Var VPointB : TombType; Fok:Integer);
  Var Sx, Sy, I : Integer;
      Eps,R     : Real;
      Bill      : Char;
      X, Y      : Integer;
      PX, PY    : Integer;
  Begin
    Eps := Fok * PI / 180;
    PX  := 160-Trunc(160*Cos(eps) - 100*Sin(eps));
    PY  := 100-Trunc(160*Sin(eps) + 100*Cos(eps));
    For I := 1 To Szam-1 Do
      Begin
        X := VPointA[I].X;
        Y := VPointA[I].Y;
        VPointB[I].X := Trunc(X*Cos(Eps) - Y*Sin(Eps)) + PX;
        VPointB[I].Y := Trunc(X*Sin(Eps) + Y*Cos(Eps)) + PY;
      End;
  End;

{-------------------------A kperny megrajzolsa----------------------------}

Procedure Kepernyo;
  Begin
    ClearDevice;
    SetFillStyle(1,Blue);
    SetColor(White);
    Bar(0,0,319,199);
    OutTextXY(65,210,'Az eredeti mret grbe');
    Bar(320,0,639,199);
    OutTextXY(355,210,'Az eredeti mret grbe eltolsa');
    Rectangle(0,0,319,199);
    Rectangle(320,0,639,199);

    Rectangle(70,275,220,365);
    Bar(71,276,219,364);
    OutTextXY(25,400,'Az eredeti mret grbe eltolsa');
    OutTextXY(110,420,'s sklzsa');

    Rectangle(400,275,550,365);
    Bar(401,276,549,364);
    OutTextXY(350,400,'Az eredeti mret grbe eltolsa,');
    OutTextXY(380,420,'sklzsa s elforgatsa');

    SetColor(12);
    OutTextXY(5,465,'A programbl kilpni az ESC billentyvel lehet, jabb grbe egyb billentyvel!');
  End;

{---------------------------------FOPROGRAM----------------------------------}

BEGIN
  ClrScr;
  GraphOpen;
  Ki := False;
  Repeat
    Kepernyo;

    Generalas(AlapB);
    BezierCsucsok(AlapB);
    BezierDraw;
    {Eredeti grbe}
    WTVT(0,0,0,320,0,200,0,320,0,200,EredetiB,EltoltB,True);
    {Eltolt grbe}
    WTVT(320,0,0,320,0,200,0,320,0,200,AlapB,AlapB,False);
    BezierCsucsok(AlapB);
    WTVT(320,0,0,320,0,200,0,320,0,200,EredetiB,EltoltB,True);
    {Sklzott grbe}
    WTVT(-80,275,0,320,0,200,0,150,0,90,AlapB,AlapB,False);
    BezierCsucsok(AlapB);
    WTVT(70,275,0,320,0,200,0,150,0,90,EredetiB,SkalazottB,True);
    {Forgatott grbe}
    Key := ' ';
    Repeat
      For K := 0 To 40 Do
        Begin
          Forgatas(EredetiB,ForgatottB,K*9);
          RasterWait;
          Bar(401,276,549,364);
          WTVT(400,275,0,320,0,200,0,150,0,90,ForgatottB,SkalazottB,True);
          If KeyPressed Then Key := ReadKey;
          If (Key = #13) Or (Key = #27) Then Break;
        End;
    Until (Key = #13) Or (Key = #27);
  Until Key = #27;
  CloseGraph;
END.