(****************************************************************************)
(*                                                                          *)
(*                        Aknakeres jtk - demo verzi                    *)
(*                                                                          *)
(****************************************************************************)

program minesweeper;

uses crt,MouseUni;

const TABLEX = 4;
      TABLEY = 2;

      Bomba  = 1;
      Zaszlo = 13;

      yfelb = 40;

var minecounter,cikl0,cikl1:integer;
    table:array [-1..30,-1..16] of byte;
    generatortable:array [0..29] of word;
    key:byte;
    timecounter,segedvalt,putchar :word;

(****************************************************************************)
(*                             Tbla generlsa                             *)
(****************************************************************************)

procedure generator;
begin
     for cikl1:=-1 to 16 do
     for cikl0:=-1 to 30 do
     table[cikl0,cikl1]:=0;

     for minecounter:=1 to 99 do
          table[random(29),random(15)]:=Bomba;

     for cikl0:=0 to 29 do

      for cikl1:=0 to 15 do

       begin
        segedvalt:=0;

        if (table[cikl0,cikl1]<>Bomba) then

         begin
          if (table[cikl0-1,cikl1-1]=Bomba) then inc(segedvalt);
          if (table[cikl0-1,cikl1]=Bomba) then inc(segedvalt);
          if (table[cikl0-1,cikl1+1]=Bomba) then inc(segedvalt);
          if (table[cikl0,cikl1-1]=Bomba) then inc(segedvalt);
          if (table[cikl0,cikl1+1]=Bomba) then inc(segedvalt);
          if (table[cikl0+1,cikl1-1]=Bomba) then inc(segedvalt);
          if (table[cikl0+1,cikl1]=Bomba) then inc(segedvalt);
          if (table[cikl0+1,cikl1+1]=Bomba) then inc(segedvalt);

          table[cikl0,cikl1]:=segedvalt+$30;
         end;
       end;

     for cikl1:=0 to 15 do
     for cikl0:=0 to 29 do
     if table[cikl0,cikl1]=$30 then table[cikl0,cikl1]:=$20;
end;

procedure Kirajzolas;

 var i,j : word;

 begin
  for i:=0 to 29 do

   for j:=0 to 15 do

    Memw[$b800:(TABLEX+i+1)*2+yfelb*(TABLEY+j+4)*2]:=table[i,j]+15*256;
 end;

(****************************************************************************)
(*                              Keret rajzolsa                             *)
(****************************************************************************)

procedure frame(x1,y1,x2,y2:byte;double:boolean);
var lu,lr,ld,ud,ru,rd:char;       {l=left,r=right,u=up,d=down (rtelem szeren)}
begin
     if double=true then
        begin
             lu:='';
             ld:='';
             ud:='';
             ru:='';
             lr:='';
             rd:='';
        end
     else
        begin
             lu:='';
             ld:='';
             ud:='';
             ru:='';
             lr:='';
             rd:='';
        end;
{     yfelb:=memw[$0000:$044a];}
     putchar:=(ord(lu))+15*256;
     memw[$0b800:(yfelb*y1*2+x1*2)]:=putchar;
     putchar:=(ord(ru))+15*256;
     memw[$0b800:(yfelb*y1*2+x2*2)]:=putchar;
     putchar:=(ord(ld))+15*256;
     memw[$0b800:(yfelb*y2*2+x1*2)]:=putchar;
     putchar:=(ord(rd))+15*256;
     memw[$0b800:(yfelb*y2*2+x2*2)]:=putchar;
     putchar:=(15*256)+(ord(ud));
     for cikl0:=(x1+1) to (x2-1) do
     memw[$0b800:(yfelb*y1*2+(cikl0*2))]:=putchar;
     putchar:=(15*256)+(ord(ud));
     for cikl0:=(x1+1) to (x2-1) do
     memw[$0b800:(yfelb*y2*2+(cikl0*2))]:=putchar;
     putchar:=(ord(lr))+15*256;
     for cikl0:=(y1+1) to (y2-1) do
     memw[$0b800:(yfelb*cikl0*2+x2*2)]:=putchar;
     putchar:=(ord(lr))+15*256;
     for cikl0:=(y1+1) to (y2-1) do
     memw[$0b800:(yfelb*cikl0*2+x1*2)]:=putchar;
end;

(****************************************************************************)
(*                       New game - j jtk elindtsa                     *)
(****************************************************************************)

procedure new;
begin
     clrscr;
     frame(TABLEX,TABLEY,TABLEX+31,TABLEY+20,true);
     putchar:=(ord(''))+15*256;
     for cikl0:=TABLEY+4 to TABLEY+19 do
         for cikl1:=TABLEX+1 to TABLEX+30 do
             memw[$0b800:(yfelb*cikl0*2+cikl1*2)]:=putchar;

     generator;

end;
procedure valtoztat;
begin
end;

{procedure puttable;
begin
end;}

procedure help;
begin


end;

(****************************************************************************)
(*                               A kezelrsz                               *)
(****************************************************************************)

procedure Jatek;

 var ki  : boolean;
     x,y : word;
     sor : word;
     osl : word;
     bom : byte;
     i   : word;

 begin
  MouseCursorOn;

  ki:=false;

  while (not ki) do

   begin
    if LeftPressed then

     begin
      GetMouseCoords(x,y);

      x:=x div 2;

      if (x>TABLEX) and (x<TABLEX+31) and
         (y>TABLEY+3) and (y<TABLEY+20) then

       begin
        sor:=y-TABLEY-4;
        osl:=x-TABLEX-1;

        bom:=table[osl,sor];

        MouseCursorOff;
        MemW[$b800:x*2+y*yfelb*2]:=bom+15*256;
        MouseCursorOn;

        Delay(50);

        if (bom=Bomba) then

         begin
          for i:=1 to 1000 do

           begin
            Sound(Random(2000));
            Delay(2);
           end;

          NoSound;

          Kirajzolas;

          ki:=true;
         end;
       end;
     end;

    if (RightPressed) then

     begin
      GetMouseCoords(x,y);

      x:=x div 2;

      if (x>TABLEX) and (x<TABLEX+31) and
         (y>TABLEY+3) and (y<TABLEY+20) then

       begin
        MouseCursorOff;
        MemW[$b800:x*2+y*yfelb*2]:=Zaszlo+15*256;
        MouseCursorOn;

        Delay(50);
       end;
     end;

    if (KeyPressed) then ki:=true;
   end;

  MouseCursorOff;

  ReadKey;
 end;

begin
     TextMode(CO40);
     clrscr;
     Randomize;
     new;
     Jatek;
     TextMode(CO80);
end.