; Septic's Demoskola - Lektion 13 : 2d-klippning
; Skriven av Vicious / Septic - 12 Mars 1994



DisableCache=1	; En nolla betyder att funktionen r avstngd...
DisableMotor=1

ScreenWidth=320
ScreenHeight=256
ScreenSize=Screenwidth/8*ScreenHeight
NrOfBpl=2

Distance=360

XSpeed=3
YSpeed=1
Zspeed=2

	section	Lektion13,code_c

j:	movem.l	d0-a6,-(sp)

	bsr.w	INIT
	tst.l	gfxbase		; Kolla om vi hittade gfx.library
	beq.s	error		; Nepp...D hoppar vi ut...

	move.w	#%1000001111000000,$dff096	; Stt DMA
	;	  S    NDBCBSD
	;	  E    aMPOLPS
	;	  T    sALPTRK
	;	       t
	;              y

	move.l	#copper,$dff080	; Nu stter vi vr egen copperlista
	move.w	d0,$dff088	; Och tvingar den att brja direkt...

main:
	bsr.s	sync
	bsr.w	SwapPages
	bsr.w	ClrDrawPage
	bsr.w	Rotate
	bsr.w	DrawCube
	bsr.w	FillPage
	bsr.s	NewAngle

	cmp.l	#350,depth	; Kolla om vi zoomat frdigt...
	beq.s	.noadd
	add.l	#5,depth	; Zooma in mera!
.noadd:
	btst	#6,$bfe001	; Testa vnster musknapp!
	bne.s	main

xit:	bsr.w	UnINIT
error:	movem.l	(sp)+,d0-a6
	rts

; Syncroniserings rutin
sync:	move.l	$dff004,d0
	and.l	#$1ff00,d0
	lsr.l	#8,d0
	cmp.w	#$f0,d0		; Kolla om rasterrad=$f0
	bne.s	sync
	rts

; Den hr rutinen adderar speed-vrdena till de tre vinklarna och kollar
; om en vinkel r >359 vilket betyder att den skall "wrappas" runt!
NewAngle:
	movem.l	d0-a6,-(sp)
	lea.l	AngleX(pc),a0
	add.l	#XSpeed,(a0)
	bsr.s	ChkAngle
	addq.l	#4,a0
	add.l	#YSpeed,(a0)
	bsr.s	ChkAngle
	addq.l	#4,a0
	add.l	#ZSpeed,(a0)
	bsr.s	ChkAngle
	movem.l	(sp)+,d0-a6
	rts

ChkAngle:
	cmp.l	#360,(a0)
	blo.s	.angOk
	sub.l	#360,(a0)
.angOk:	rts

; Den hr rutinen roterar ett obegrnsat antal punkter i X, Y och Z
Rotate:
	movem.l	d0-a6,-(sp)
	lea.l	coords(pc),a0
	lea.l	coords2d(pc),a1
	lea.l	sintable(pc),a2
	lea.l	costable(pc),a3
	moveq	#14,d5
.calculate:
	movem.l	(a0)+,d0-d2

	; X rotation
	move.l	d2,d3		; Spara X
	move.l	AngleX(pc),d4	; Hmta X-vinkeln
	add.l	d4,d4		; *2 (fr att sinusvrdena r i wordsize)
	move.w	(a3,d4.w),d7	; Hmta cosinus fr vinkeln a
	muls.w	d7,d2		; Cos a * Z
	move.w	(a2,d4.w),d6	; Hmta sinus fr vinkeln a
	muls.w	d1,d6		; Y * Sin a
	sub.l	d6,d2		; Z - Y
	asr.l	d5,d2		; Dividera med 16384 fr att f ny Z

	move.w	(a2,d4.w),d6
	muls.w	d6,d3		; Sin a * old Z
	move.w	(a3,d4.w),d7
	muls.w	d7,d1		; Cos a * Y
	add.l	d3,d1		; Z + Y
	asr.l	d5,d1		; Ny Y

	; Y rotation
	move.l	d0,d3
	move.l	AngleY(pc),d4
	add.l	d4,d4
	move.w	(a3,d4.w),d7
	muls.w	d7,d0		; Cos a * X
	move.w	(a2,d4.w),d6
	muls.w	d2,d6		; Z * Sin a
	sub.l	d6,d0		; Z - X
	asr.l	d5,d0		; Ny X

	move.w	(a2,d4.w),d6
	muls.w	d6,d3		; Sin a * gammal X
	move.w	(a3,d4.w),d7
	muls.w	d7,d2		; Cos a * Z
	add.l	d3,d2		; X + Z
	asr.l	d5,d2		; Ny Z

	; Z rotation
	move.l	d0,d3
	move.l	AngleZ(pc),d4
	add.l	d4,d4
	move.w	(a3,d4.w),d7
	muls.w	d7,d0		; Cos a * X
	move.w	(a2,d4.w),d6
	muls.w	d1,d6		; Y * sin a
	sub.l	d6,d0		; Y - X
	asr.l	d5,d0		; Ny X

	move.w	(a2,d4.w),d6
	muls.w	d6,d3		; Sin a * X
	move.w	(a3,d4.w),d7
	muls.w	d7,d1		; Cos a * Y
	add.l	d3,d1		; X + Y
	asr.l	d5,d1		; Ny Y

	; Konvertera 3d till 2d...
	add.l	#distance,d2	; Addera distansen till Z
	move.l	depth(pc),d4	; Hmta djup-vrdet
	muls.w	d4,d0		; Djupet*X
	divs.w	d2,d0		; och dividera med Z+Distansen
	ext.l	d0		; Utvidga wordet till longword
	muls.w	d4,d1		; Djupet*Y
	divs.w	d2,d1		; och dividera med Z+Distansen
	ext.l	d1

	move.l	d0,(a1)+	; Lagra X
	move.l	d1,(a1)+	; Lagra Y

	cmp.l	#-6666,(a0)	; Kolla slutet p tabellen
	bne.w	.calculate

	movem.l	(sp)+,d0-a6
	rts


DrawCube:
	movem.l	d0-a6,-(sp)
	move.l	drawpage(pc),a0		; Skrmpekare
	move.l	#screenwidth/8,a1	; Skrmbredden i bytes
	move.l	#-1,a2			; Mask

	lea.l	coords2d(pc),a3
	lea.l	lines(pc),a4

.nxtpoly:
	move.l	(a4)+,d4	; Hmta polygonens frgnummer
	move.l	(a4)+,d7	; Antal linjer i polygonen
	move.l	(a4),d5		; Lagra koordinat 1
	bsr.w	HiddenFace
	bpl.w	.visible	; Om normalen r positiv r polygonen synlig
	lsl.l	#2,d7		; Koordinaterna ligger p jmna longwords
	add.l	d7,a4		; Peka p nsta polygon
	bra.w	.nopoly

.visible:
	subq.l	#2,d7
	bmi.w	.nopoly
.drawpoly:
	move.l	(a4)+,d6	; Koordinat nummer
	lsl.l	#3,d6		; *8
	move.l	(a3,d6.w),d0
	move.l	4(a3,d6.w),d1

	add.l	#screenwidth/2,d0
	add.l	#screenheight/2,d1

	move.l	(a4),d6
	lsl.l	#3,d6		; *8
	move.l	(a3,d6.w),d2
	move.l	4(a3,d6.w),d3

	add.l	#screenwidth/2,d2
	add.l	#screenheight/2,d3

	bsr.w	Clip2d
	cmp.l	#-6000,d0
	beq.s	.noline

	ror.b	#1,d4		; Shifta ut frgnumret
	bpl.s	.notbpl1	; Kolla om vi ska stta ngot i bitplanet
	bsr.w	DrawLine	; I s fall ritar vi en linje
.notbpl1:
	ror.b	#1,d4		; Kolla andra bitplanet ocks...
	bpl.s	.notbpl2
	lea.l	screensize(a0),a0	; Addera till skrmpekaren
	bsr.w	DrawLine		; och rita ut i bitplan 2!
	lea.l	-screensize(a0),a0
.notbpl2:
	rol.b	#2,d4		; Fixa tillbaka frgen...
.noline:
	dbf	d7,.drawpoly

	; Rita sista linjen i polygonen...
	move.l	(a4)+,d6	; Koordinat nummer
	lsl.l	#3,d6		; *8
	move.l	(a3,d6.w),d0
	move.l	4(a3,d6.w),d1

	add.l	#screenwidth/2,d0
	add.l	#screenheight/2,d1

	lsl.l	#3,d5		; *8
	move.l	(a3,d5.w),d2
	move.l	4(a3,d5.w),d3

	add.l	#screenwidth/2,d2
	add.l	#screenheight/2,d3

	bsr.s	Clip2d
	cmp.l	#-6000,d0
	beq.s	.nopoly

	roxr.b	#1,d4
	bcc.s	.notbpl1b
	bsr.w	DrawLine
.notbpl1b:
	roxr.b	#1,d4
	bcc.s	.notbpl2b
	lea.l	screensize(a0),a0
	bsr.w	DrawLine
	lea.l	-screensize(a0),a0
.notbpl2b:

.nopoly:
	cmp.l	#-6666,(a4)
	bne.w	.nxtpoly

	movem.l	(sp)+,d0-a6
	rts


; Den hr rutinen rknar ut en polygons normal...
HiddenFace:
	movem.l	d1-d6,-(sp)

	move.l	(a4),d6		; Koordinat nummer 1
	lsl.l	#3,d6		; *8
	move.l	(a3,d6.w),d0	; X1
	move.l	4(a3,d6.w),d1	; Y1

	move.l	4(a4),d6	; Koordinat nummer 2
	lsl.l	#3,d6		; *8
	move.l	(a3,d6.w),d2	; X2
	move.l	4(a3,d6.w),d3	; Y2

	move.l	8(a4),d6	; Koordinat nummer 3
	lsl.l	#3,d6		; *8
	move.l	(a3,d6.w),d4	; X3
	move.l	4(a3,d6.w),d5	; Y3

	sub.l	d4,d0		; (X1-X3)=Vx1
	sub.l	d5,d1		; (Y1-Y3)=Vy1
	sub.l	d4,d2		; (X2-X3)=Vx2
	sub.l	d5,d3		; (Y2-Y3)=Vy2

	muls.w	d3,d0		; Vx1*Vy2
	muls.w	d2,d1		; Vy1*Vx2

	sub.l	d1,d0		; (Vx1*Vx2)-(Vy1*Vy2)

	movem.l	(sp)+,d1-d6
	rts

; * 2D Clipping routine *
; D0 - X1 / D1 - Y1 / D2 - X2 / D3 - Y2
; Returnerar med D0=-6000 om linjen ej skall ritas
Clip2D:
	movem.l	d4-d7,-(sp)

	move.l	d4,ColNr	; Lagra frgvrdet

	; Kolla om X2 r mer eller lika med X1
	cmp.l	d0,d2
	bge.s	.noswap
	exg.l	d0,d2	; Om inte s flyttar vi om koordinaterna
	exg.l	d1,d3
.noswap:

	; Frst kollar vi vnsterkanten...
	move.l	ClipLeft(pc),d7
	cmp.l	d7,d0		; r X1 utanfr skrmen?
	bge.s	.LeftOk
	cmp.l	d7,d2		; r X2 utanfr ocks?
	bge.s	.CutLeft
	move.l	#-6000,d0	; Hela linjen r utanfr...
	bra.w	.out

	; Om bara X1 r utanfr mste vi klippa...
.CutLeft:move.l	d3,d4		; Y2
	sub.l	d1,d4		; Y2-Y1
	asl.l	#7,d4		; * 128
	move.l	d2,d5		; X2
	sub.l	d0,d5		; X2-X1
	divs.w	d5,d4		; (Y2-Y1)/(X2-X1)
	move.l	d7,d5
	sub.l	d0,d5		; MinX-X.utanfr
	muls.w	d5,d4
	asr.l	#7,d4
	move.l	d7,d0		; Ny X=ClipLeft
	add.l	d4,d1		; Ny Y=Y+C
	cmp.l	#-6000,OldClipY1
	beq.s	.SaveY1
	bsr.w	XtraLineLeft	; Rita en extra linje till vnster
	move.l	#-6000,OldClipY1
	bra.s	.Leftok
.SaveY1:move.l	d1,OldClipY1

.Leftok:

	; Nu kollar vi den hgra kanten...
	move.l	ClipRight(pc),d7
	cmp.l	d7,d2
	ble.s	.RightOk
	cmp.l	d7,d0
	ble.s	.CutRight
	move.l	#-6000,d0
	bra.w	.out

	; We cut X2...
.CutRight:
	move.l	d3,d4		; Y2
	sub.l	d1,d4		; Y2-Y1
	asl.l	#7,d4		; * 128
	move.l	d2,d5		; X2
	sub.l	d0,d5		; X2-X1
	divs.w	d5,d4		; (Y2-Y1)/(X2-X1)
	move.l	d7,d5
	move.l	d2,d6		; X2
	sub.l	d5,d6		; X.utanfr-MaxX
	muls.w	d6,d4
	asr.l	#7,d4
	move.l	d7,d2		; Ny X=ClipLeft
	sub.l	d4,d3		; Ny Y=Y-C
	cmp.l	#-6000,OldClipY2
	beq.s	.SaveY2
	bsr.w	XtraLineRight	; En extra linje till hger
	move.l	#-6000,OldClipY2
	bra.s	.Rightok
.SaveY2:move.l	d3,OldClipY2

.RightOk:

	; Kolla Y-koordinaterna p samma stt s att X1;Y1 r lgst...
	cmp.w	d1,d3
	bge.s	.noswap2
	exg.l	d0,d2
	exg.l	d1,d3
.noswap2:

	; Nu klipper vi mot den vre kanten...
	move.l	ClipUp(pc),d7
	cmp.l	d7,d1
	bge.s	.UpOk
	cmp.l	d7,d3
	bge.s	.CutUp
	move.l	#-6000,d0
	bra.s	.out

.CutUp:
	move.l	d2,d4		; X2
	sub.l	d0,d4		; X2-X1
	asl.l	#7,d4		; * 128
	move.l	d3,d5		; Y2
	sub.l	d1,d5		; Y2-Y1
	divs.w	d5,d4		; (X2-X1)/(Y2-Y1)
	move.l	d7,d5		; MinY
	sub.l	d1,d5		; MinY-Y.utanfr
	muls.w	d5,d4
	asr.l	#7,d4
	move.l	d7,d1		; Ny Y=ClipUp
	add.l	d4,d0		; Ny X=X+C

.UpOk:
	; Nu kollar vi den undre kanten...
	move.l	ClipDown(pc),d7
	cmp.l	d7,d3
	ble.s	.DownOk
	cmp.l	d7,d1
	ble.s	.CutDown
	move.l	#-6000,d0
	bra.s	.out

.CutDown:
	move.l	d2,d4		; X2
	sub.l	d0,d4		; X2-X1
	asl.l	#7,d4		; * 128
	move.l	d3,d5		; Y2
	sub.l	d1,d5		; Y2-Y1
	divs.w	d5,d4		; (X2-X1)/(Y2-Y1)
	move.l	d7,d5
	move.l	d3,d6		; Y2
	sub.l	d5,d6		; Y.utanfr-MaxY
	muls.w	d6,d4
	asr.l	#7,d4
	move.l	d7,d3		; Ny Y=ClipDown
	sub.l	d4,d2		; Ny X=X-C
.DownOk:

.out:	movem.l	(sp)+,d4-d7
	rts

OldClipY1:	dc.l	-6000
OldClipY2:	dc.l	-6000
ColNr:		dc.l	0

; D1 mste innehlla Y
XtraLineLeft:
	movem.l	d0-a6,-(sp)
	move.l	ClipLeft(pc),d0
	move.l	ClipUp(pc),d4
	move.l	ClipDown(pc),d5
	move.l	d0,d2
	move.l	OldClipY1(pc),d3

	; Frst kollar vi s att extralinjen hamnar inom grnserna...
	cmp.l	d4,d1
	bpl.s	.in
	cmp.l	d4,d3
	bmi.s	.noline
.in:
	cmp.l	d5,d1
	bmi.s	.in2
	cmp.l	d5,d3
	bpl.s	.noline
.in2:
	cmp.l	d1,d3
	bge.s	.ok
	exg.l	d1,d3
.ok:	cmp.l	d4,d1
	bge.s	.D1ok
	move.l	d4,d1
.D1ok:	cmp.l	d5,d3
	ble.s	.D3ok
	move.l	d5,d3
.D3ok:
	move.l	ColNr(pc),d7
	ror.b	#1,d7		; Shifta ut frgnumret
	bpl.s	.notbpl1	; Kolla om vi ska stta ngot i bitplanet
	bsr.w	DrawLine	; I s fall ritar vi en linje
.notbpl1:
	ror.b	#1,d7		; Kolla andra bitplanet ocks...
	bpl.s	.notbpl2
	lea.l	screensize(a0),a0	; Addera till skrmpekaren
	bsr.w	DrawLine		; och rita ut i bitplan 2!
.notbpl2:

.noline:movem.l	(sp)+,d0-a6
	rts

; D3 mste innehlla Y
XtraLineRight:
	movem.l	d0-a6,-(sp)
	move.l	ClipRight(pc),d0
	move.l	ClipUp(pc),d4
	move.l	ClipDown(pc),d5
	move.l	d0,d2
	move.l	OldClipY2(pc),d1

	; Frst kollar vi s att extralinjen hamnar inom grnserna...
	cmp.l	d4,d1
	bpl.s	.in
	cmp.l	d4,d3
	bmi.s	.noline
.in:
	cmp.l	d5,d1
	bmi.s	.in2
	cmp.l	d5,d3
	bpl.s	.noline
.in2:
	cmp.l	d1,d3
	bge.s	.ok
	exg.l	d1,d3
.ok:	cmp.l	d4,d1
	bge.s	.D1ok
	move.l	d4,d1
.D1ok:	cmp.l	d5,d3
	ble.s	.D3ok
	move.l	d5,d3
.D3ok:
	move.l	ColNr(pc),d7
	ror.b	#1,d7		; Shifta ut frgnumret
	bpl.s	.notbpl1	; Kolla om vi ska stta ngot i bitplanet
	bsr.w	DrawLine	; I s fall ritar vi en linje
.notbpl1:
	ror.b	#1,d7		; Kolla andra bitplanet ocks...
	bpl.s	.notbpl2
	lea.l	screensize(a0),a0	; Addera till skrmpekaren
	bsr.w	DrawLine		; och rita ut i bitplan 2!
.notbpl2:

.noline:movem.l	(sp)+,d0-a6
	rts


*** Linjeritnings Rutin  ***
; Den hr rutinen ritar en linje med blittern
; D0 - X1   D1 - Y1   D2 - X2   D3 - Y2
; A0 - Skrmpekare
; A1 - Skrmbredden i bytes
; A2 - Linjens mask ($ffff fr helt fylld linje)

DrawLine:
	movem.l	d0-a6,-(sp)

	cmp.w	d1,d3
	beq.w	.DontDraw
	bcc.s	.D1D3ok
	exg	d0,d2
	exg	d1,d3
.D1D3ok:
	move.l	a1,d4		; Lgg skrmbredden i D4
	mulu.w	d1,d4		; Multiplicera med Y1
	moveq	#-$10,d5	; D5=$fffffff0
	and.w	d0,d5		; Plocka bort de 4 lgsta bitarna
	lsr.w	#3,d5		; Multiplicera med 8 (2^3=8)
	add.w	d5,d4		; Addera detta till Y1
	add.l	a0,d4		; Addera skrmpekaren till detta

	moveq	#0,d5
	sub.w	d1,d3		; Ta reda p delta Y
	roxl.b	#1,d5		; Shifta ut X-flaggan i D5. Att X-flaggan
				; stts hr anger att D1 r hgre n D3 och
				; drfr kan vi senare med hjlp av D5 ta
				; fram rtt oktant utan strre problem...
	tst.w	d3		; Kolla om D3 r negativt
	bge.s	.y2gy1
	neg.w	d3		; I s fall gr vi det positivt!
.y2gy1:
	sub.w	d0,d2		; Ta reda p delta X och gr samma sak som
				; med Y...
	roxl.b	#1,d5
	tst.w	d2
	bge.s	.x2gx1
	neg.w	d2
.x2gx1:
	move.w	d3,d1		; Flytta delta Y till D1

	; Fix corners (Fast method by Tec/Cryptoburners)
	add.w	d1,d1
	cmp.w	d2,d1
	dbhi	d3,.notfix
.notfix:
	move.w	d3,d1		; Flytta delta Y till D1
	sub.w	d2,d1		; Delta Y-Delta X anger vilket som r
				; strst!
	bge.s	.dygdx
	exg	d2,d3		; Vi vill ha det strsta vrdet i D3.
				; Detta r nu dx.

.dygdx:	roxl.b	#1,d5		; Shifta in X-flaggan hr ocks...

	move.b	Octant_table(pc,d5.l),d5	; Nu kan vi enkelt hmta
						; korrekt oktant frn en
						; speciell tabell...

	add.w	d2,d2		; dy multiplicerat med 2

.WBlit:	btst #6,$dff002	; Vnta tills blittern r klar
	bne.s	.WBlit

	move.w	d2,$dff062	; Skriv dy till BLTBMOD
	sub.w	d3,d2		; Kolla om vi behver stta SIGN-biten
	bge.s	.signnl
	or.b	#$40,d5		; Stt SIGN-flaggan i D5
.signnl: move.w	d2,$dff052	; Skriv (4*dy)-(2*dx) till BLTAPT
	sub.w	d3,d2
	move.w	d2,$dff064	; Och skriv 4*(dy-dx) till BLTAMOD

	move.w	#$8000,$dff074	; Stt BLTADAT till $8000
	move.w	a2,$dff072	; Stt linjemask i BLTBDAT
	move.w	#$ffff,$dff044	; Stt rtt BLTAFWM
	and.w	#$000f,d0	; Maska bort allt utom de lgsta 4 bitarna
	ror.w	#4,d0		; Flytta upp 4 lga bitarna till de 4 hga

	or.w	#(srca+srcc+dest)!(a&b&nc+na&c),d0	; Minterm ABc+aC

	move.w	d0,$dff040	; Stt korrekt vrde i BLTCON0
	move.w	d5,$dff042	; och i BLTCON1
	move.l	d4,$dff048	; Frsta pixeln p linjen
	move.l	d4,$dff054	; Och frsta pixeln p linjen hr ocks
	move.w	a1,$dff060	; Bredden p skrmen i BLTCMOD
	move.w	a1,$dff066	; och i BLTDMOD ocks

	lsl.w	#6,d3		; dx i bit 6-15
	addq.w	#2,d3		; och bit 0-5 = 2
	move.w	d3,$dff058	; Stt detta sen i BLTSIZE fr att starta
				; linjen...

.dontdraw:
	movem.l	(sp)+,d0-a6
	rts

Octant_table:
	dc.b 0*4+3	; y1<y2, x1<x2, dx<dy = Okt6 
	dc.b 4*4+3	; y1<y2, x1<x2, dx>dy = Okt7
	dc.b 2*4+3	; y1<y2, x1>x2, dx<dy = Okt5
	dc.b 5*4+3	; y1<y2, x1>x2, dx>dy = Okt4
	dc.b 1*4+3	; y1>y2, x1<x2, dx<dy = Okt1
	dc.b 6*4+3	; y1>y2, x1<x2, dx>dy = Okt0
	dc.b 3*4+3	; y1>y2, x1>x2, dx<dy = Okt2
	dc.b 7*4+3	; y1>y2, x1>x2, dx>dy = Okt3


; Detta r initialiserings-rutinen....
AttnFlags=296
INIT:
	movem.l	d0-a6,-(sp)
	bsr.w	FetchVBR

	move.l	$4.w,a6
	jsr	-132(a6)	; Forbid - Stng av multitasking

 IFNE DisableCache		; Kolla om den hr rutinen ska vara med...
	cmp.w	#36,20(a6)	; Disable Cache funkar bara p KS2.0++
	bcs.s	.not20		; Om lgre n 2.0 s hoppar vi vidare...
	move.l	#$00003818,d0	; Har inte kunnat testa de hr siffrorna
	move.l	#$80003b1b,d1	; men det ska frmodligen funka :-)
	jsr	-648(a6)	; CacheControl()
	lea.l	OldCache(pc),a0
	move.l	d0,(a0)
.not20:
 ENDC

	lea.l	gfxname(pc),a1
	jsr	-408(a6)	; OldOpenLibrary() - Funkar lika bra som
	tst.l	d0		; valiga openlibrary() om man inte behver
	beq.w	noGfx		; ppna en speciell version...
	move.l	d0,GfxBase
	move.l	d0,a6
	jsr	-456(a6)	; Ownblitter - Ska vi anvnda blittern mste
				; vi se till att vi fr ta den...
	jsr	-228(a6)	; Och det r lika bra att vnta p den ox!
				; Det gr vi med WaitBlit()
	sub.l	a1,a1
	jsr	-222(a6)	; Loadview - Nu kysser vi copperlistan adj!
	jsr	-270(a6)	; WaitTOF - Vnta tills vi med skerhet kan
	jsr	-270(a6)	; installera vra egna saker...WaitTOF ska
				; enligt Commodore helst kras tv gnger!
	lea.l	oldintena(pc),a1
	move.w	$dff01c,(a1)+	; Spara gamla interrupt statusen
	move.w	$dff002,(a1)	; Spara gammal DMA
	move.w	#$7fff,d0
	move.w	d0,$dff09a	; INTENA
	move.w	d0,$dff096	; DMACON - Vi rensar gammal skit...

 IFNE DisableMotor		; Kolla om vi ska ktta av drivemotorn...
	move.b	#-1,$bfd100	; Den hr lilla kodsnutten r inte direkt
	nop			; snll men br fungera nd. Det vrsta
	nop			; som kan hnda r att driven fortstter
	move.b	#$81,$bfd100	; att vara p.
	nop			; Mer om denna lilla snutt kommer nr jag
	nop			; tar upp HW-trackloading! Tills dess fr
	move.b	#-1,$bfd100	; ni svlja den utan frklaring...
 ENDC
	movem.l	(sp)+,d0-a6
	rts

NoGFX:	move.l	$4.w,a6
	jsr	-138(a6)	; Permit multitasking...
	movem.l	(sp)+,d0-a6
	rts

; Denna rutin stter upp systemet igen...
UNINIT:
	movem.l	d0-a6,-(sp)
	move.w	oldintena(pc),d0
	or.w	#$8000,d0		; S bitarna stts och inte rensas
	move.w	d0,$dff09a
	move.w	olddmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,$dff096

	move.l	gfxbase(pc),a6
	jsr	-228(a6)	; Waitblit()
	jsr	-462(a6)	; DisOwnBlit()

	lea.l	intname(pc),a1	; Nu mste vi ppna Intuition
	move.l	$4.w,a6
	jsr	-408(a6)	; OldOpenlibrary
	move.l	d0,a2
	tst.l	d0		; Kolla om intuition gick att ppna....
	beq.s	.closegfx	; Hoppa om det inte gick...

	lea.l	34(a2),a1	; Fetcha Viewporten!
	move.l	gfxbase(pc),a6
	jsr	-222(a6)	; Loadviewa in den riktiga viewporten!
	move.l	$26(a6),$dff080	; Och restora gamla copperlistorna...
	move.l	$30(a6),$dff084

	move.l	a2,a1
	move.l	$4.w,a6
	jsr	-414(a6)	; Stng intuition

.closegfx:
	move.l	$4.w,a6
	move.l	gfxbase(pc),a1
	jsr	-414(a6)	; och stng ocks graphics.library...

 IFNE DisableCache
; Nu stter vi p cache-minnet igen...
	cmp.w	#36,20(a6)	; Kolla version igen...Verkligen dumt
	bcs.s	.not20		; om det skulle ndra sig under programmets
				; gng! :-)))
	move.l	oldcache(pc),d0
	moveq	#-1,d1
	jsr	-648(a6)	; CacheControl()
.not20:
 ENDC
	jsr	-138(a6)	; Permit multitasking

	bsr.s	FetchTime
	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen hmtar VBR, vilket r en offset till vektoromrdet
; p hgre processorer n 68000. P en vanlig 68000 r VBR alltid 0.
FetchVBR:
	move.l	a6,-(sp)
	move.l	$4.w,a6			; Hmta exec
	sub.l	a0,a0			; Nollstll a0
	btst	#0,Attnflags+1(a6)	; Kolla om 68010++
	beq.s	.Lower
	move.l	a5,-(sp)
	lea.l	.getVBR(pc),a5
	jsr	-30(a6)		; Vi mste hmta VBR i supervisor mode
	move.l	(sp)+,a5
.lower:	move.l	(sp)+,a6
	rts

.GetVBR:movem.l	a0/a1,-(sp)
	lea.l	MyVBR(pc),a1	; Hr ska vi skriva in VBRen.
	dc.l	$4e7a8801	; Detta r egentligen instruktionen
				; MOVEC VBR,A0 men eftersom ldre versioner
				; av AsmOne inte stdjer den instruktionen
				; gjorde jag ett litet specialtrick hr...
	move.l	a0,(a1)
	movem.l	(sp)+,a0/a1
	rte			; tervnd frn supervisor...

; Fetch Time Variables
IOTV_SIZE		=$28
IO_COMMAND		=$1C
TR_SETSYSTIME		=$B
tr_time			=$20
_LVOCloseDevice		=-$1C2
_LVODoIO		=-$1C8
_LVOReadBattClock	=-$C
_LVOOpenDevice		=-$1BC
_LVOOpenResource	=-$1F2
FetchTime:
	movem.l	d0-a6,-(sp)
	move.l	4.w,a6
	lea	battclockname(pc),a1
	jsr	_LVOOpenResource(a6)
	move.l	d0,d6
	beq.b	.noclock

	moveq	#0,d0
	moveq	#0,d1
	lea	timername(pc),a0
	lea	timerio(pc),a2
	move.l	a2,a1
	jsr	_LVOOpenDevice(a6)
	move.l	d0,d7
	bne.b	.notimerdev

	exg.l	d6,a6
	jsr	_LVOReadBattClock(a6)
	exg.l	d6,a6
	move.l	a2,a1
	move.l	d0,tr_time(a1)
	move.w	#TR_SETSYSTIME,IO_COMMAND(a1)
	jsr	_LVODoIO(a6)
	move.l	a2,a1
	jsr	_LVOCloseDevice(a6)
.notimerdev
.noclock
	movem.l	(sp)+,d0-a6
	rts

timerio	dcb.b	IOTV_SIZE
battclockname	dc.b	'battclock.resource',0
timername	dc.b	'timer.device',0
		even
MyVBR:	dc.l	0		; Hr lgger vi VBR!

*** End of INIT routine ***


; Rensa skrmen med blittern!
ClrDrawPage:
	btst	#6,$dff002
	bne.s	clrdrawpage
	move.l	#$01000000,$dff040	; BLTCON
	move.w	#0,$dff066		; BLTDMOD
	move.l	drawpage(pc),$dff054	; BLTDPT
	move.w	#(((screenheight*nrofbpl)-1)*64)+(screenwidth/16),$dff058
	rts


; Fyll vektorer med blittern!
FillPage:
	btst	#6,$dff002
	bne.s	Fillpage
	move.l	drawpage(pc),a0
	add.l	#(screensize*nrofbpl)-2,a0
	move.w	#(srca!dest)!a,$dff040	; BLTCON0
	move.w	#$0012,$dff042		; BLTCON1 (EFE!DESC)
	move.l	#$ffffffff,$dff044	; BLTAFWM
	move.l	a0,$dff050		; BLTAPT
	move.l	a0,$dff054		; BLTDPT
	move.l	#0,$dff064		; BLTAMOD&BLTDMOD
	move.w	#(((screenheight*nrofbpl)-1)*64)+(screenwidth/16),$dff058
	rts

; Flippa fram den frdigritade sidan!
SwapPages:
	movem.l	d0/a0,-(sp)
	lea.l	drawpage(pc),a0
	move.l	(a0),d0
	move.l	4(a0),(a0)
	move.l	d0,4(a0)

	lea.l	bplptr+2(pc),a0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	add.l	#screensize,d0
	lea.l	8(a0),a0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	movem.l	(sp)+,d0/a0
	rts

************* COPPER ************

copper:
	dc.w	$008e,$2c81	; DIWSTRT
	dc.w	$0090,$2cc1	; DIWSTOP
	dc.w	$0092,$0038	; DDFSTRT
	dc.w	$0094,$00d0	; DDFSTOP
	dc.w	$0100,$2200	; BPLCON0
	dc.w	$0102,$0000	; BPLCON1
	dc.w	$0104,$0000	; BPLCON2
	dc.w	$0106,$0000	; BLPCON3
	dc.w	$0108,$0000	; BPLMOD0
	dc.w	$010a,$0000	; BPLMOD1

	; Bitplanspekare
bplptr:	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$00e4,$0000,$00e6,$0000

	dc.w	$0180,$000,$0182,$f04,$0184,$e03,$0186,$d02

	dc.w	$ffff,$fffe

gfxname:dc.b	'graphics.library',0
intname:dc.b	'intuition.library',0
	even
gfxbase:dc.l	0
oldintena:
	dc.w	0
olddmacon:
	dc.w	0
OldCache:
	dc.l	0

DrawPage:
	dc.l	scr1
ShowPage:
	dc.l	scr2

Depth:	dc.l	0
AngleX:	dc.l	0
AngleY:	dc.l	0
AngleZ:	dc.l	0

; Detta r klippgrnserna...
ClipLeft:	dc.l	0+20
ClipRight:	dc.l	320-20
ClipUp:		dc.l	0+20
ClipDown:	dc.l	256-20

; Koordinater fr kuben
Coords:
	dc.l	-100,-100,-100
	dc.l	100,-100,-100
	dc.l	100,100,-100
	dc.l	-100,100,-100

	dc.l	-100,-100,100
	dc.l	100,-100,100
	dc.l	100,100,100
	dc.l	-100,100,100
	dc.l	-6666

; Linjedata som anger hur polygonerna r uppbyggda.
; Formatet: Frg,Antal linjer,punkt1, punkt2, punkt3 osv...
Lines:
	dc.l	1,4,0,1,2,3	; Totalt sex polygonsidor i en kub
	dc.l	1,4,7,6,5,4
	dc.l	2,4,0,3,7,4
	dc.l	2,4,5,6,2,1
	dc.l	3,4,4,5,1,0
	dc.l	3,4,6,7,3,2
	dc.l	-6666

coords2d:ds.l	8*2

; Sinus och cosinustabell, uppskiftad 14 ggr, vilket r samma sak som
; multiplikation med 16384.
SinTable:
	dc.w	 0,286,572,857,1143,1428
	dc.w	 1713,1997,2280,2563,2845,3126
	dc.w	 3406,3686,3964,4240,4516,4790
	dc.w	 5063,5334,5604,5872,6138,6402
	dc.w	 6664,6924,7182,7438,7692,7943
	dc.w	 8192,8438,8682,8923,9162,9397
	dc.w	 9630,9860,10087,10311,10531,10749
	dc.w	 10963,11174,11381,11585,11786,11982
	dc.w	 12176,12365,12551,12733,12911,13085
	dc.w	 13255,13421,13583,13741,13894,14044
	dc.w	 14189,14330,14466,14598,14726,14849
	dc.w	 14968,15082,15191,15296,15396,15491
	dc.w	 15582,15668,15749,15826,15897,15964
	dc.w	 16026,16083,16135,16182,16225,16262
	dc.w	 16294,16322,16344,16362,16374,16382

CosTable:
	dc.w	 16384,16382,16374,16362,16344
	dc.w	 16322,16294,16262,16225,16182,16135
	dc.w	 16083,16026,15964,15897,15826,15749
	dc.w	 15668,15582,15491,15396,15296,15191
	dc.w	 15082,14968,14849,14726,14598,14466
	dc.w	 14330,14189,14044,13894,13741,13583
	dc.w	 13421,13255,13085,12911,12733,12551
	dc.w	 12365,12176,11983,11786,11585,11381
	dc.w	 11174,10963,10749,10531,10311,10087
	dc.w	 9860,9630,9397,9162,8923,8682
	dc.w	 8438,8192,7943,7692,7438,7182
	dc.w	 6924,6664,6402,6138,5872,5604
	dc.w	 5334,5063,4790,4516,4240,3964
	dc.w	 3686,3406,3126,2845,2563,2280
	dc.w	 1997,1713,1428,1143,857,572
	dc.w	 286,0,-286,-572,-857,-1143
	dc.w	-1428,-1713,-1997,-2280,-2563,-2845
	dc.w	-3126,-3406,-3686,-3964,-4240,-4516
	dc.w	-4790,-5063,-5334,-5604,-5871,-6138
	dc.w	-6402,-6664,-6924,-7182,-7438,-7692
	dc.w	-7943,-8192,-8438,-8682,-8923,-9162
	dc.w	-9397,-9630,-9860,-10087,-10311,-10531
	dc.w	-10749,-10963,-11174,-11381,-11585,-11786
	dc.w	-11982,-12176,-12365,-12551,-12733,-12911
	dc.w	-13085,-13255,-13421,-13583,-13741,-13894
	dc.w	-14044,-14189,-14330,-14466,-14598,-14726
	dc.w	-14849,-14968,-15082,-15191,-15296,-15396
	dc.w	-15491,-15582,-15668,-15749,-15826,-15897
	dc.w	-15964,-16026,-16083,-16135,-16182,-16225
	dc.w	-16262,-16294,-16322,-16344,-16362,-16374
	dc.w	-16382,-16384,-16382,-16374,-16362,-16344
	dc.w	-16322,-16294,-16262,-16225,-16182,-16135
	dc.w	-16083,-16026,-15964,-15897,-15826,-15749
	dc.w	-15668,-15582,-15491,-15396,-15296,-15191
	dc.w	-15082,-14968,-14849,-14726,-14598,-14466
	dc.w	-14330,-14189,-14044,-13894,-13741,-13583
	dc.w	-13421,-13255,-13085,-12911,-12733,-12551
	dc.w	-12365,-12176,-11983,-11786,-11585,-11381
	dc.w	-11174,-10963,-10749,-10531,-10311,-10087
	dc.w	-9860,-9630,-9397,-9162,-8923,-8682
	dc.w	-8438,-8192,-7943,-7692,-7438,-7182
	dc.w	-6924,-6664,-6402,-6138,-5872,-5604
	dc.w	-5334,-5063,-4790,-4516,-4241,-3964
	dc.w	-3686,-3406,-3126,-2845,-2563,-2280
	dc.w	-1997,-1713,-1428,-1143,-857,-572
	dc.w	-286,0,286,572,857,1143
	dc.w	 1428,1713,1997,2280,2563,2845
	dc.w	 3126,3406,3686,3964,4240,4516
	dc.w	 4790,5063,5334,5604,5871,6138
	dc.w	 6402,6664,6924,7182,7438,7692
	dc.w	 7943,8192,8438,8682,8923,9162
	dc.w	 9397,9630,9860,10087,10311,10531
	dc.w	 10749,10963,11174,11381,11585,11786
	dc.w	 11982,12176,12365,12551,12733,12911
	dc.w	 13085,13255,13421,13583,13741,13894
	dc.w	 14044,14189,14330,14466,14598,14726
	dc.w	 14849,14968,15082,15191,15296,15396
	dc.w	 15491,15582,15668,15749,15826,15897
	dc.w	 15964,16026,16083,16135,16182,16225
	dc.w	 16262,16294,16322,16344,16362,16374
	dc.w	 16382,16384

	section	scr,BSS_c
scr1:	ds.b	screensize*nrofbpl
scr2:	ds.b	screensize*nrofbpl

; Blitter MINTERM data
DEST =	$100
SRCC =	$200
SRCB =	$400
SRCA =	$800

ABC =	$80
ABNC =	$40
ANBC =	$20
ANBNC =	$10
NABC =	$8
NABNC =	$4
NANBC =	$2
NANBNC =	$1

A = ABC!ABNC!ANBC!ANBNC
B = ABC!ABNC!NABC!NABNC
C = ABC!ANBC!NABC!NANBC

NA = (~A)&$FF
NB = (~B)&$FF
NC = (~C)&$FF
