; Septic's Demoskola - Lektion 3 : Bitplansgrafik
; Skriven av Vicious / Septic 7 May 1993

DisableCache=1	; En nolla betyder att funktionen r avstngd...
DisableMotor=1

Width=320
Height=256

	section	Lektion3,code_c

j:	movem.l	d0-a6,-(sp)

	bsr.w	INIT
	tst.l	gfxbase		; Kolla om vi hittade gfx.library
	beq.s	error		; Nepp...D hoppar vi ut...

	move.w	#%1000001110000000,$dff096	; Vr lilla DMA...Notera
	;	  S    NDBCBSD			; att BPL-dma nu r p!
	;	  E    aMPOLPS
	;	  T    sALPTRK
	;	       t
	;              y

	bsr.s	setbplptr
	bsr.s	setcolours
	move.l	#copper,$dff080	; Nu stter vi vr egen copperlista
	move.w	d0,$dff088	; Och tvingar den att brja direkt...

main:
	btst	#6,$bfe001	; Testa vnster musknapp!
	bne.s	main

xit:	bsr.w	UnINIT
error:	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen stter bitplanspekarna i coppern.
SetBplPtr:
	movem.l	d0-a6,-(sp)
	lea.l	picture,a0	; Peka p bilden.
	move.l	a0,d0		; Flytta ver pekaren till D0 s att vi
				; kan anvnda kommandot SWAP senare...
	lea.l	bplptr+2,a1	; Peka i copperlistan dr vi ska skriva
				; in bitplanen.
	moveq	#3,d7		; Antal bitplan minus ett. Alltsa 5-1 = 4
.SetPtrs:
	move.w	d0,4(a1)	; Flytta de lgsta 16 bitarna till coppern.
	swap	d0		; Swappa de 16 lgsta bitarna i D0 med de
				; 16 hgsta.
	move.w	d0,(a1)		; Flytta in de 16 hgsta bitarna av
				; bitplanspekaren i coppern.
	swap	d0		; Och swappa tillbaka de 16 hgsta och 16
				; lgsta bitarna i D0.

	add.l	#(width/8)*height,d0	; Lgg till storleken p ett
					; bitplan till D0 s att vi fr
					; reda p var nsta bitplan brjar.
	lea.l	8(a1),a1		; ka A1 med 8. Gr snabbare n
					; ADD.L #8,A1...
	dbf	d7,.setptrs		; Loopa tillbaka!

	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen stter bildens frger i coppern.
SetColours:
	movem.l	d0-a6,-(sp)
	lea.l	picture,a0			; Peka p bilden.
	add.l	#((width/8)*height)*4,a0	; Och lgg till hela bild-
						; storleken s att vi
						; hamnar i slutet p bilden
						; dr vi har lagrat
						; frgerna.

	lea.l	cols+2,a1	; Peka p frglistan i coppern.
	moveq	#31,d7		; 32 frger minus ett fr loopen.
.setcols:
	move.w	(a0)+,(a1)	; Flytta ett frgvrde till coppern.
	lea.l	4(a1),a1	; ka p A1 med 4.
	dbf	d7,.setcols	; Loopa...
	movem.l	(sp)+,d0-a6
	rts

; Detta r initialiserings-rutinen....
AttnFlags=296
INIT:
	movem.l	d0-a6,-(sp)
	bsr.w	FetchVBR

	move.l	$4.w,a6
	jsr	-132(a6)	; Forbid - Stng av multitasking

 IFNE DisableCache		; Kolla om den hr rutinen ska vara med...
	cmp.w	#36,20(a6)	; Disable Cache funkar bara p KS2.0++
	bcs.s	.not20		; Om lgre n 2.0 s hoppar vi vidare...
	move.l	#$00003818,d0	; Har inte kunnat testa de hr siffrorna
	move.l	#$80003b1b,d1	; men det ska frmodligen funka :-)
	jsr	-648(a6)	; CacheControl()
	lea.l	OldCache(pc),a0
	move.l	d0,(a0)
.not20:
 ENDC

	lea.l	gfxname(pc),a1
	jsr	-408(a6)	; OldOpenLibrary() - Funkar lika bra som
	tst.l	d0		; valiga openlibrary() om man inte behver
	beq.w	noGfx		; ppna en speciell version...
	move.l	d0,GfxBase
	move.l	d0,a6
	jsr	-456(a6)	; Ownblitter - Ska vi anvnda blittern mste
				; vi se till att vi fr ta den...
	jsr	-228(a6)	; Och det r lika bra att vnta p den ox!
				; Det gr vi med WaitBlit()
	sub.l	a1,a1
	jsr	-222(a6)	; Loadview - Nu kysser vi copperlistan adj!
	jsr	-270(a6)	; WaitTOF - Vnta tills vi med skerhet kan
	jsr	-270(a6)	; installera vra egna saker...WaitTOF ska
				; enligt Commodore helst kras tv gnger!
	lea.l	oldintena(pc),a1
	move.w	$dff01c,(a1)+	; Spara gamla interrupt statusen
	move.w	$dff002,(a1)	; Spara gammal DMA
	move.w	#$7fff,d0
	move.w	d0,$dff09a	; INTENA
	move.w	d0,$dff096	; DMACON - Vi rensar gammal skit...

 IFNE DisableMotor		; Kolla om vi ska ktta av drivemotorn...
	move.b	#-1,$bfd100	; Den hr lilla kodsnutten r inte direkt
	nop			; snll men br fungera nd. Det vrsta
	nop			; som kan hnda r att driven fortstter
	move.b	#$81,$bfd100	; att vara p.
	nop			; Mer om denna lilla snutt kommer nr jag
	nop			; tar upp HW-trackloading! Tills dess fr
	move.b	#-1,$bfd100	; ni svlja den utan frklaring...
 ENDC
	movem.l	(sp)+,d0-a6
	rts

NoGFX:	move.l	$4.w,a6
	jsr	-138(a6)	; Permit multitasking...
	movem.l	(sp)+,d0-a6
	rts

; Denna rutin stter upp systemet igen...
UNINIT:
	movem.l	d0-a6,-(sp)
	move.w	oldintena(pc),d0
	or.w	#$8000,d0		; S bitarna stts och inte rensas
	move.w	d0,$dff09a
	move.w	olddmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,$dff096

	move.l	gfxbase(pc),a6
	jsr	-228(a6)	; Waitblit()
	jsr	-462(a6)	; DisOwnBlit()

	lea.l	intname(pc),a1	; Nu mste vi ppna Intuition
	move.l	$4.w,a6
	jsr	-408(a6)	; OldOpenlibrary
	move.l	d0,a2
	tst.l	d0		; Kolla om intuition gick att ppna....
	beq.s	.closegfx	; Hoppa om det inte gick...

	lea.l	34(a2),a1	; Fetcha Viewporten!
	move.l	gfxbase(pc),a6
	jsr	-222(a6)	; Loadviewa in den riktiga viewporten!
	move.l	$26(a6),$dff080	; Och restora gamla copperlistorna...
	move.l	$30(a6),$dff084

	move.l	a2,a1
	move.l	$4.w,a6
	jsr	-414(a6)	; Stng intuition

.closegfx:
	move.l	$4.w,a6
	move.l	gfxbase(pc),a1
	jsr	-414(a6)	; och stng ocks graphics.library...

 IFNE DisableCache
; Nu stter vi p cache-minnet igen...
	cmp.w	#36,20(a6)	; Kolla version igen...Verkligen dumt
	bcs.s	.not20		; om det skulle ndra sig under programmets
				; gng! :-)))
	move.l	oldcache(pc),d0
	moveq	#-1,d1
	jsr	-648(a6)	; CacheControl()
.not20:
 ENDC
	jsr	-138(a6)	; Permit multitasking

	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen hmtar VBR, vilket r en offset till vektoromrdet
; p hgre processorer n 68000. P en vanlig 68000 r VBR alltid 0.
FetchVBR:
	move.l	a6,-(sp)
	move.l	$4.w,a6			; Hmta exec
	sub.l	a0,a0			; Nollstll a0
	btst	#0,Attnflags+1(a6)	; Kolla om 68010++
	beq.s	.Lower
	move.l	a5,-(sp)
	lea.l	.getVBR(pc),a5
	jsr	-30(a6)		; Vi mste hmta VBR i supervisor mode
	move.l	(sp)+,a5
.lower:	move.l	(sp)+,a6
	rts

.GetVBR:movem.l	a0/a1,-(sp)
	lea.l	MyVBR(pc),a1	; Hr ska vi skriva in VBRen.
	dc.l	$4e7a8801	; Detta r egentligen instruktionen
				; MOVEC VBR,A0 men eftersom ldre versioner
				; inte stdjer den instruktionen gjorde jag
				; ett litet specialtrick hr...
	move.l	a0,(a1)
	movem.l	(sp)+,a0/a1
	rte			; tervnd frn supervisor...

MyVBR:	dc.l	0		; Hr lgger vi VBR!


************* COPPER ************

copper:
	dc.w	$008e,$2c81	; DIWSTRT
	dc.w	$0090,$2cc1	; DIWSTOP
	dc.w	$0092,$0038	; DDFSTRT
	dc.w	$0094,$00d0	; DDFSTOP
	dc.w	$0100,$4200	; BPLCON0
	dc.w	$0102,$0000	; BPLCON1
	dc.w	$0104,$0000	; BPLCON2
	dc.w	$0108,$0000	; BPLMOD1
	dc.w	$010a,$0000	; BPLMOD2

	; Alla 5 bitplanspekarna!
bplptr:	dc.w	$00e0,$0000,$00e2,$0000,$00e4,$0000,$00e6,$0000
	dc.w	$00e8,$0000,$00ea,$0000,$00ec,$0000,$00ee,$0000
	dc.w	$00f0,$0000,$00f2,$0000,$00f4,$0000,$00f6,$0000
	dc.w	$00f8,$0000,$00fa,$0000

	; Alla 32 frger!
Cols:	dc.w	$0180,$0,$0182,$0,$0184,$0,$0186,$0
	dc.w	$0188,$0,$018a,$0,$018c,$0,$018e,$0
	dc.w	$0190,$0,$0192,$0,$0194,$0,$0196,$0
	dc.w	$0198,$0,$019a,$0,$019c,$0,$019e,$0
	dc.w	$01a0,$0,$01a2,$0,$01a4,$0,$01a6,$0
	dc.w	$01a8,$0,$01aa,$0,$01ac,$0,$01ae,$0
	dc.w	$01b0,$0,$01b2,$0,$01b4,$0,$01b6,$0
	dc.w	$01b8,$0,$01ba,$0,$01bc,$0,$01be,$0

	dc.w	$ffff,$fffe

gfxname:dc.b	'graphics.library',0
intname:dc.b	'intuition.library',0
	even
gfxbase:dc.l	0
oldintena:
	dc.w	0
olddmacon:
	dc.w	0
OldCache:
	dc.l	0

	; Hr laddar vi in vr bild.
	section	Bild,data_c
Picture:
	incbin	'tsd:intro/slime.raw'
