; Septic's Demoskola - Lektion 5 : Sprites (Stjrnscroll)
; Skriven av Vicious / Septic 5 Juni 1993

DisableCache=1	; En nolla betyder att funktionen r avstngd...
DisableMotor=1

	section	Lektion5,code_c

j:	movem.l	d0-a6,-(sp)

	bsr.w	INIT
	tst.l	gfxbase		; Kolla om vi hittade gfx.library
	beq.w	error		; Nepp...D hoppar vi ut...

	move.w	#%1000001110100000,$dff096	; Sprite-DMA pslagen!
	;	  S    NDBCBSD
	;	  E    aMPOLPS
	;	  T    sALPTRK
	;	       t
	;              y

	bsr.w	SetSpritePointers
	bsr.w	SetBplPtr
	move.l	#copper,$dff080	; Nu stter vi vr egen copperlista
	move.w	d0,$dff088	; Och tvingar den att brja direkt...

main:
	move.l	#$110,d1
	bsr.s	sync
	bsr.s	scrollstars
	btst	#6,$bfe001	; Testa vnster musknapp!
	bne.s	main

xit:	bsr.w	UnINIT
error:	movem.l	(sp)+,d0-a6
	rts

; Raster line in D1
sync:	move.l	$dff004,d0
	and.l	#$1ff00,d0
	lsr.l	#8,d0
	cmp.w	d1,d0
	bne.s	sync
	rts

ScrollStars:
	movem.l	d0-a6,-(sp)
	moveq.l	#50-1,d7		; Antal stjrnor i varje lager-1
	lea.l	sprite0,a0
.add1:	add.b	#3,1(a0)		; Add 6 pixels...
	lea.l	8(a0),a0
	dbf	d7,.add1

	moveq.l	#50-1,d7
	lea.l	sprite1,a0
.add2:	add.b	#2,1(a0)
	bchg	#0,3(a0)		; Flippa HSTART low biten
	beq.s	.ejnoll2
	add.b	#1,1(a0)
.ejnoll2:
	lea.l	8(a0),a0
	dbf	d7,.add2

	moveq.l	#50-1,d7
	lea.l	sprite2,a0
.add3:	add.b	#2,1(a0)
	lea.l	8(a0),a0
	dbf	d7,.add3

	moveq.l	#50-1,d7
	lea.l	sprite3,a0
.add4:	add.b	#1,1(a0)
	bchg	#0,3(a0)
	beq.s	.ejnoll4
	add.b	#1,1(a0)
.ejnoll4:
	lea.l	8(a0),a0
	dbf	d7,.add4

	moveq.l	#50-1,d7
	lea.l	sprite4,a0
.add5:	add.b	#1,1(a0)
	lea.l	8(a0),a0
	dbf	d7,.add5

	moveq.l	#50-1,d7
	lea.l	sprite5,a0
.add6:	bchg	#0,3(a0)
	beq.s	.ejnoll6
	add.b	#1,1(a0)
.ejnoll6:
	lea.l	8(a0),a0
	dbf	d7,.add6
	
	movem.l	(sp)+,d0-a6
	rts

SetBplPtr:
	movem.l	d0-a6,-(sp)
	lea.l	EmptyBitplane,a0
	move.l	a0,d0
	lea.l	bplptr+2,a1
	move.w	d0,4(a1)
	swap	d0
	move.w	d0,(a1)
	movem.l	(sp)+,d0-a6
	rts

SetSpritePointers:
	movem.l	d0-a6,-(sp)
	lea.l	sprptr+2,a1

	lea.l	sprite0,a0
	bsr.s	.setit

	lea.l	sprite1,a0
	bsr.s	.setit

	lea.l	sprite2,a0
	bsr.s	.setit

	lea.l	sprite3,a0
	bsr.s	.setit

	lea.l	sprite4,a0
	bsr.s	.setit

	lea.l	sprite5,a0
	bsr.s	.setit

	lea.l	nosprite,a0
	bsr.s	.setit
	lea.l	nosprite,a0
	bsr.s	.setit

.tut:	movem.l	(sp)+,d0-a6
	rts

.setit:	move.l	a0,d0
	move.w	d0,4(a1)
	swap	d0
	move.w	d0,(a1)
	lea.l	8(a1),a1
	rts

; Detta r initialiserings-rutinen....
AttnFlags=296
INIT:
	movem.l	d0-a6,-(sp)
	bsr.w	FetchVBR

	move.l	$4.w,a6
	jsr	-132(a6)	; Forbid - Stng av multitasking

 IFNE DisableCache		; Kolla om den hr rutinen ska vara med...
	cmp.w	#36,20(a6)	; Disable Cache funkar bara p KS2.0++
	bcs.s	.not20		; Om lgre n 2.0 s hoppar vi vidare...
	move.l	#$00003818,d0	; Har inte kunnat testa de hr siffrorna
	move.l	#$80003b1b,d1	; men det ska frmodligen funka :-)
	jsr	-648(a6)	; CacheControl()
	lea.l	OldCache(pc),a0
	move.l	d0,(a0)
.not20:
 ENDC

	lea.l	gfxname(pc),a1
	jsr	-408(a6)	; OldOpenLibrary() - Funkar lika bra som
	tst.l	d0		; valiga openlibrary() om man inte behver
	beq.w	noGfx		; ppna en speciell version...
	move.l	d0,GfxBase
	move.l	d0,a6
	jsr	-456(a6)	; Ownblitter - Ska vi anvnda blittern mste
				; vi se till att vi fr ta den...
	jsr	-228(a6)	; Och det r lika bra att vnta p den ox!
				; Det gr vi med WaitBlit()
	sub.l	a1,a1
	jsr	-222(a6)	; Loadview - Nu kysser vi copperlistan adj!
	jsr	-270(a6)	; WaitTOF - Vnta tills vi med skerhet kan
	jsr	-270(a6)	; installera vra egna saker...WaitTOF ska
				; enligt Commodore helst kras tv gnger!
	lea.l	oldintena(pc),a1
	move.w	$dff01c,(a1)+	; Spara gamla interrupt statusen
	move.w	$dff002,(a1)	; Spara gammal DMA
	move.w	#$7fff,d0
	move.w	d0,$dff09a	; INTENA
	move.w	d0,$dff096	; DMACON - Vi rensar gammal skit...

 IFNE DisableMotor		; Kolla om vi ska ktta av drivemotorn...
	move.b	#-1,$bfd100	; Den hr lilla kodsnutten r inte direkt
	nop			; snll men br fungera nd. Det vrsta
	nop			; som kan hnda r att driven fortstter
	move.b	#$81,$bfd100	; att vara p.
	nop			; Mer om denna lilla snutt kommer nr jag
	nop			; tar upp HW-trackloading! Tills dess fr
	move.b	#-1,$bfd100	; ni svlja den utan frklaring...
 ENDC
	movem.l	(sp)+,d0-a6
	rts

NoGFX:	move.l	$4.w,a6
	jsr	-138(a6)	; Permit multitasking...
	movem.l	(sp)+,d0-a6
	rts

; Denna rutin stter upp systemet igen...
UNINIT:
	movem.l	d0-a6,-(sp)
	move.w	oldintena(pc),d0
	or.w	#$8000,d0		; S bitarna stts och inte rensas
	move.w	d0,$dff09a
	move.w	olddmacon(pc),d0
	or.w	#$8000,d0
	move.w	d0,$dff096

	move.l	gfxbase(pc),a6
	jsr	-228(a6)	; Waitblit()
	jsr	-462(a6)	; DisOwnBlit()

	lea.l	intname(pc),a1	; Nu mste vi ppna Intuition
	move.l	$4.w,a6
	jsr	-408(a6)	; OldOpenlibrary
	move.l	d0,a2
	tst.l	d0		; Kolla om intuition gick att ppna....
	beq.s	.closegfx	; Hoppa om det inte gick...

	lea.l	34(a2),a1	; Fetcha Viewporten!
	move.l	gfxbase(pc),a6
	jsr	-222(a6)	; Loadviewa in den riktiga viewporten!
	move.l	$26(a6),$dff080	; Och restora gamla copperlistorna...
	move.l	$30(a6),$dff084

	move.l	a2,a1
	move.l	$4.w,a6
	jsr	-414(a6)	; Stng intuition

.closegfx:
	move.l	$4.w,a6
	move.l	gfxbase(pc),a1
	jsr	-414(a6)	; och stng ocks graphics.library...

 IFNE DisableCache
; Nu stter vi p cache-minnet igen...
	cmp.w	#36,20(a6)	; Kolla version igen...Verkligen dumt
	bcs.s	.not20		; om det skulle ndra sig under programmets
				; gng! :-)))
	move.l	oldcache(pc),d0
	moveq	#-1,d1
	jsr	-648(a6)	; CacheControl()
.not20:
 ENDC
	jsr	-138(a6)	; Permit multitasking

	movem.l	(sp)+,d0-a6
	rts

; Den hr rutinen hmtar VBR, vilket r en offset till vektoromrdet
; p hgre processorer n 68000. P en vanlig 68000 r VBR alltid 0.
FetchVBR:
	move.l	a6,-(sp)
	move.l	$4.w,a6			; Hmta exec
	sub.l	a0,a0			; Nollstll a0
	btst	#0,Attnflags+1(a6)	; Kolla om 68010++
	beq.s	.Lower
	move.l	a5,-(sp)
	lea.l	.getVBR(pc),a5
	jsr	-30(a6)		; Vi mste hmta VBR i supervisor mode
	move.l	(sp)+,a5
.lower:	move.l	(sp)+,a6
	rts

.GetVBR:movem.l	a0/a1,-(sp)
	lea.l	MyVBR(pc),a1	; Hr ska vi skriva in VBRen.
	dc.l	$4e7a8801	; Detta r egentligen instruktionen
				; MOVEC VBR,A0 men eftersom ldre versioner
				; av AsmOne inte stdjer den instruktionen
				; gjorde jag ett litet specialtrick hr...
	move.l	a0,(a1)
	movem.l	(sp)+,a0/a1
	rte			; tervnd frn supervisor...

MyVBR:	dc.l	0		; Hr lgger vi VBR!


************* COPPER ************

copper:
	dc.w	$008e,$2c81	; DIWSTRT
	dc.w	$0090,$2cc1	; DIWSTOP
	dc.w	$0092,$0038	; DDFSTRT
	dc.w	$0094,$00d8	; DDFSTOP
	dc.w	$0100,$1200	; BPLCON0
	dc.w	$0102,$0000	; BPLCON1
	dc.w	$0104,$0000	; BPLCON2
	dc.w	$0108,$ffd6	; BPLMOD1 (Negativ den hr gngen!)
	dc.w	$010a,$ffd6	; BPLMOD2 (Ls lngre ner...)

; Hr r de 8 spritepekarna, som vi stller in med rutinen
; SetSpritePointers...
SprPtr:
	dc.w	$0120,$0000,$0122,$0000,$0124,$0000,$0126,$0000
	dc.w	$0128,$0000,$012a,$0000,$012c,$0000,$012e,$0000
	dc.w	$0130,$0000,$0132,$0000,$0134,$0000,$0136,$0000
	dc.w	$0138,$0000,$013a,$0000,$013c,$0000,$013e,$0000

; Vi mste ha ett bitplan pslaget fr att spritarna ska synas...Drfr
; gr jag ett litet trick, och anvnder negativ modulo, vilket gr att
; raden i EmptyBitplane visas ver hela skrmen, och vi behver allts inte
; ha en helt ren skrm utan det rcker med en enda rad.

bplptr:	dc.w	$00e0,$0000,$00e2,$0000

	dc.w	$0180,$0000

	; Alla 16 frger till spritarna!
Cols:	dc.w	$01a0,$0,$01a2,$fff,$01a4,$eee,$01a6,$ccc
	dc.w	$01a8,$0,$01aa,$aaa,$01ac,$999,$01ae,$888
	dc.w	$01b0,$0,$01b2,$777,$01b4,$666,$01b6,$555
	dc.w	$01b8,$0,$01ba,$000,$01bc,$000,$01be,$000

	dc.w	$ffff,$fffe

gfxname:dc.b	'graphics.library',0
intname:dc.b	'intuition.library',0
	even
gfxbase:dc.l	0
oldintena:
	dc.w	0
olddmacon:
	dc.w	0
OldCache:
	dc.l	0

EmptyBitplane:
	blk.l	40,0	; En tom rad som visas ver hela skrmen.

NoSprite:
	dc.w	$0000,$0000	; Tom sprite!

; Hr fljer slumpmssig spritedata fr alla stjrnor.
Sprite0:
	dc.w	$2A22,$2B00
	dc.w	$8000,$0000
	dc.w	$2CD7,$2D00
	dc.w	$8000,$0000
	dc.w	$2E6B,$2F00
	dc.w	$8000,$0000
	dc.w	$30A2,$3100
	dc.w	$8000,$0000
	dc.w	$32FD,$3300
	dc.w	$8000,$0000
	dc.w	$343E,$3500
	dc.w	$8000,$0000
	dc.w	$3605,$3700
	dc.w	$8000,$0000
	dc.w	$3880,$3900
	dc.w	$8000,$0000
	dc.w	$3ABA,$3B00
	dc.w	$8000,$0000
	dc.w	$3C56,$3D00
	dc.w	$8000,$0000
	dc.w	$3E95,$3F00
	dc.w	$8000,$0000
	dc.w	$4011,$4100
	dc.w	$8000,$0000
	dc.w	$4264,$4300
	dc.w	$8000,$0000
	dc.w	$442C,$4500
	dc.w	$8000,$0000
	dc.w	$46EC,$4700
	dc.w	$8000,$0000
	dc.w	$48C4,$4900
	dc.w	$8000,$0000
	dc.w	$4A7B,$4B00
	dc.w	$8000,$0000
	dc.w	$4C41,$4D00
	dc.w	$8000,$0000
	dc.w	$4EAA,$4F00
	dc.w	$8000,$0000
	dc.w	$5006,$5100
	dc.w	$8000,$0000
	dc.w	$5260,$5300
	dc.w	$8000,$0000
	dc.w	$54D5,$5500
	dc.w	$8000,$0000
	dc.w	$568A,$5700
	dc.w	$8000,$0000
	dc.w	$58F6,$5900
	dc.w	$8000,$0000
	dc.w	$5ABE,$5B00
	dc.w	$8000,$0000
	dc.w	$5C31,$5D00
	dc.w	$8000,$0000
	dc.w	$5E67,$5F00
	dc.w	$8000,$0000
	dc.w	$6009,$6100
	dc.w	$8000,$0000
	dc.w	$6295,$6300
	dc.w	$8000,$0000
	dc.w	$6A63,$6B00
	dc.w	$8000,$0000
	dc.w	$6CC3,$6D00
	dc.w	$8000,$0000
	dc.w	$6E30,$6F00
	dc.w	$8000,$0000
	dc.w	$7288,$7300
	dc.w	$8000,$0000
	dc.w	$74DF,$7500
	dc.w	$8000,$0000
	dc.w	$7948,$7A00
	dc.w	$8000,$0000
	dc.w	$7BAA,$7C00
	dc.w	$8000,$0000
	dc.w	$811C,$8200
	dc.w	$8000,$0000
	dc.w	$8375,$8400
	dc.w	$8000,$0000
	dc.w	$85D0,$8600
	dc.w	$8000,$0000
	dc.w	$8E3D,$8F00
	dc.w	$8000,$0000
	dc.w	$959F,$9600
	dc.w	$8000,$0000
	dc.w	$9BDB,$9C00
	dc.w	$8000,$0000
	dc.w	$9E62,$9F00
	dc.w	$8000,$0000
	dc.w	$A629,$A700
	dc.w	$8000,$0000
	dc.w	$B34C,$B400
	dc.w	$8000,$0000
	dc.w	$B5B8,$B600
	dc.w	$8000,$0000
	dc.w	$B97C,$BA00
	dc.w	$8000,$0000
	dc.w	$C628,$C700
	dc.w	$8000,$0000
	dc.w	$D503,$D600
	dc.w	$8000,$0000
	dc.w	$D75D,$D800
	dc.w	$8000,$0000
	dc.w	$0000,$0000

Sprite1:
	dc.w	$2B55,$2C00
	dc.w	$0000,$8000
	dc.w	$2D89,$2E00
	dc.w	$0000,$8000
	dc.w	$2FC3,$3000
	dc.w	$0000,$8000
	dc.w	$3633,$3700
	dc.w	$0000,$8000
	dc.w	$3872,$3900
	dc.w	$0000,$8000
	dc.w	$3AE1,$3B00
	dc.w	$0000,$8000
	dc.w	$43A8,$4400
	dc.w	$0000,$8000
	dc.w	$49F8,$4A00
	dc.w	$0000,$8000
	dc.w	$4E50,$4F00
	dc.w	$0000,$8000
	dc.w	$5700,$5800
	dc.w	$0000,$8000
	dc.w	$5924,$5A00
	dc.w	$0000,$8000
	dc.w	$5D4E,$5E00
	dc.w	$0000,$8000
	dc.w	$5FAA,$6000
	dc.w	$0000,$8000
	dc.w	$617B,$6200
	dc.w	$0000,$8000
	dc.w	$63E3,$6400
	dc.w	$0000,$8000
	dc.w	$719F,$7200
	dc.w	$0000,$8000
	dc.w	$7765,$7800
	dc.w	$0000,$8000
	dc.w	$790B,$7A00
	dc.w	$0000,$8000
	dc.w	$82F9,$8300
	dc.w	$0000,$8000
	dc.w	$84B4,$8500
	dc.w	$0000,$8000
	dc.w	$8655,$8700
	dc.w	$0000,$8000
	dc.w	$8A8F,$8B00
	dc.w	$0000,$8000
	dc.w	$9213,$9300
	dc.w	$0000,$8000
	dc.w	$957D,$9600
	dc.w	$0000,$8000
	dc.w	$97C4,$9800
	dc.w	$0000,$8000
	dc.w	$9E4D,$9F00
	dc.w	$0000,$8000
	dc.w	$A0F5,$A100
	dc.w	$0000,$8000
	dc.w	$A2B0,$A300
	dc.w	$0000,$8000
	dc.w	$A47B,$A500
	dc.w	$0000,$8000
	dc.w	$A803,$A900
	dc.w	$0000,$8000
	dc.w	$AA3D,$AB00
	dc.w	$0000,$8000
	dc.w	$AC9D,$AD00
	dc.w	$0000,$8000
	dc.w	$B561,$B600
	dc.w	$0000,$8000
	dc.w	$B7F2,$B800
	dc.w	$0000,$8000
	dc.w	$B9D0,$BA00
	dc.w	$0000,$8000
	dc.w	$BC8F,$BD00
	dc.w	$0000,$8000
	dc.w	$BE3D,$BF00
	dc.w	$0000,$8000
	dc.w	$C00F,$C100
	dc.w	$0000,$8000
	dc.w	$C26B,$C300
	dc.w	$0000,$8000
	dc.w	$C6AB,$C700
	dc.w	$0000,$8000
	dc.w	$C8E7,$C900
	dc.w	$0000,$8000
	dc.w	$D0C9,$D100
	dc.w	$0000,$8000
	dc.w	$D292,$D300
	dc.w	$0000,$8000
	dc.w	$FD47,$FE00
	dc.w	$0000,$8000
	dc.w	$021D,$0306	; VSTART OCH VSTOP Hgsta bit satt
	dc.w	$0000,$8000
	dc.w	$0C04,$0D06
	dc.w	$0000,$8000
	dc.w	$11CC,$1206
	dc.w	$0000,$8000
	dc.w	$188A,$1906
	dc.w	$0000,$8000
	dc.w	$214E,$2206
	dc.w	$0000,$8000
	dc.w	$2526,$2606
	dc.w	$0000,$8000
	dc.w	$0000,$0000

Sprite2:
	dc.w	$3349,$3400
	dc.w	$8000,$8000
	dc.w	$3593,$3600
	dc.w	$8000,$8000
	dc.w	$37AF,$3800
	dc.w	$8000,$8000
	dc.w	$39ED,$3A00
	dc.w	$8000,$8000
	dc.w	$3BCD,$3C00
	dc.w	$8000,$8000
	dc.w	$3D43,$3E00
	dc.w	$8000,$8000
	dc.w	$3F20,$4000
	dc.w	$8000,$8000
	dc.w	$4172,$4200
	dc.w	$8000,$8000
	dc.w	$43B8,$4400
	dc.w	$8000,$8000
	dc.w	$458C,$4600
	dc.w	$8000,$8000
	dc.w	$47DB,$4800
	dc.w	$8000,$8000
	dc.w	$4F45,$5000
	dc.w	$8000,$8000
	dc.w	$5118,$5200
	dc.w	$8000,$8000
	dc.w	$539B,$5400
	dc.w	$8000,$8000
	dc.w	$5670,$5700
	dc.w	$8000,$8000
	dc.w	$58E4,$5900
	dc.w	$8000,$8000
	dc.w	$5ED0,$5F00
	dc.w	$8000,$8000
	dc.w	$61FD,$6200
	dc.w	$8000,$8000
	dc.w	$63B7,$6400
	dc.w	$8000,$8000
	dc.w	$6586,$6600
	dc.w	$8000,$8000
	dc.w	$6751,$6800
	dc.w	$8000,$8000
	dc.w	$6A15,$6B00
	dc.w	$8000,$8000
	dc.w	$6C40,$6D00
	dc.w	$8000,$8000
	dc.w	$7073,$7100
	dc.w	$8000,$8000
	dc.w	$72AF,$7300
	dc.w	$8000,$8000
	dc.w	$74D3,$7500
	dc.w	$8000,$8000
	dc.w	$76F7,$7700
	dc.w	$8000,$8000
	dc.w	$7BE7,$7C00
	dc.w	$8000,$8000
	dc.w	$7DBE,$7E00
	dc.w	$8000,$8000
	dc.w	$7F8B,$8000
	dc.w	$8000,$8000
	dc.w	$8166,$8200
	dc.w	$8000,$8000
	dc.w	$832D,$8400
	dc.w	$8000,$8000
	dc.w	$853A,$8600
	dc.w	$8000,$8000
	dc.w	$8A07,$8B00
	dc.w	$8000,$8000
	dc.w	$9028,$9100
	dc.w	$8000,$8000
	dc.w	$9263,$9300
	dc.w	$8000,$8000
	dc.w	$9493,$9500
	dc.w	$8000,$8000
	dc.w	$96B7,$9700
	dc.w	$8000,$8000
	dc.w	$A8E8,$A900
	dc.w	$8000,$8000
	dc.w	$B4D2,$B500
	dc.w	$8000,$8000
	dc.w	$C695,$C700
	dc.w	$8000,$8000
	dc.w	$D86E,$D900
	dc.w	$8000,$8000
	dc.w	$EA55,$EB00
	dc.w	$8000,$8000
	dc.w	$F109,$F200
	dc.w	$8000,$8000
	dc.w	$F41D,$F500
	dc.w	$8000,$8000
	dc.w	$F852,$F900
	dc.w	$8000,$8000
	dc.w	$FD7F,$FE00
	dc.w	$8000,$8000
	dc.w	$013A,$0206
	dc.w	$8000,$8000
	dc.w	$0872,$0906
	dc.w	$8000,$8000
	dc.w	$15B1,$1606
	dc.w	$8000,$8000
	dc.w	$0000,$0000

Sprite3:
	dc.w	$2A5A,$2B00
	dc.w	$8000,$0000
	dc.w	$2FC5,$3000
	dc.w	$8000,$0000
	dc.w	$318D,$3200
	dc.w	$8000,$0000
	dc.w	$3A1F,$3B00
	dc.w	$8000,$0000
	dc.w	$3C71,$3D00
	dc.w	$8000,$0000
	dc.w	$3EFC,$3F00
	dc.w	$8000,$0000
	dc.w	$40B8,$4100
	dc.w	$8000,$0000
	dc.w	$42E2,$4300
	dc.w	$8000,$0000
	dc.w	$444E,$4500
	dc.w	$8000,$0000
	dc.w	$4D00,$4E00
	dc.w	$8000,$0000
	dc.w	$4F37,$5000
	dc.w	$8000,$0000
	dc.w	$51A0,$5200
	dc.w	$8000,$0000
	dc.w	$536E,$5400
	dc.w	$8000,$0000
	dc.w	$55E6,$5600
	dc.w	$8000,$0000
	dc.w	$5C97,$5D00
	dc.w	$8000,$0000
	dc.w	$6247,$6300
	dc.w	$8000,$0000
	dc.w	$6401,$6500
	dc.w	$8000,$0000
	dc.w	$6A7A,$6B00
	dc.w	$8000,$0000
	dc.w	$6C20,$6D00
	dc.w	$8000,$0000
	dc.w	$71BD,$7200
	dc.w	$8000,$0000
	dc.w	$7353,$7400
	dc.w	$8000,$0000
	dc.w	$75EF,$7600
	dc.w	$8000,$0000
	dc.w	$8291,$8300
	dc.w	$8000,$0000
	dc.w	$881B,$8900
	dc.w	$8000,$0000
	dc.w	$8B61,$8C00
	dc.w	$8000,$0000
	dc.w	$8DCE,$8E00
	dc.w	$8000,$0000
	dc.w	$93AA,$9400
	dc.w	$8000,$0000
	dc.w	$9646,$9700
	dc.w	$8000,$0000
	dc.w	$9920,$9A00
	dc.w	$8000,$0000
	dc.w	$9B8E,$9C00
	dc.w	$8000,$0000
	dc.w	$9DF4,$9E00
	dc.w	$8000,$0000
	dc.w	$A6DD,$A700
	dc.w	$8000,$0000
	dc.w	$A885,$A900
	dc.w	$8000,$0000
	dc.w	$AA6B,$AB00
	dc.w	$8000,$0000
	dc.w	$AC16,$AD00
	dc.w	$8000,$0000
	dc.w	$AE17,$AF00
	dc.w	$8000,$0000
	dc.w	$B067,$B100
	dc.w	$8000,$0000
	dc.w	$B2CC,$B300
	dc.w	$8000,$0000
	dc.w	$B93D,$BA00
	dc.w	$8000,$0000
	dc.w	$BF0E,$C000
	dc.w	$8000,$0000
	dc.w	$C1A9,$C200
	dc.w	$8000,$0000
	dc.w	$C363,$C400
	dc.w	$8000,$0000
	dc.w	$C6F1,$C700
	dc.w	$8000,$0000
	dc.w	$D92C,$DA00
	dc.w	$8000,$0000
	dc.w	$EB86,$EC00
	dc.w	$8000,$0000
	dc.w	$FEDB,$FF00
	dc.w	$8000,$0000
	dc.w	$0A52,$0B06
	dc.w	$8000,$0000
	dc.w	$1316,$1406
	dc.w	$8000,$0000
	dc.w	$19B3,$1A06
	dc.w	$8000,$0000
	dc.w	$2657,$2706
	dc.w	$8000,$0000
	dc.w	$0000,$0000

Sprite4:
	dc.w	$333F,$3400
	dc.w	$0000,$8000
	dc.w	$35AD,$3600
	dc.w	$0000,$8000
	dc.w	$39D1,$3A00
	dc.w	$0000,$8000
	dc.w	$3E83,$3F00
	dc.w	$0000,$8000
	dc.w	$405B,$4100
	dc.w	$0000,$8000
	dc.w	$4213,$4300
	dc.w	$0000,$8000
	dc.w	$4A99,$4B00
	dc.w	$0000,$8000
	dc.w	$5251,$5300
	dc.w	$0000,$8000
	dc.w	$541F,$5500
	dc.w	$0000,$8000
	dc.w	$56CD,$5700
	dc.w	$0000,$8000
	dc.w	$58B9,$5900
	dc.w	$0000,$8000
	dc.w	$5A80,$5B00
	dc.w	$0000,$8000
	dc.w	$5CF8,$5D00
	dc.w	$0000,$8000
	dc.w	$605E,$6100
	dc.w	$0000,$8000
	dc.w	$693D,$6A00
	dc.w	$0000,$8000
	dc.w	$6E09,$6F00
	dc.w	$0000,$8000
	dc.w	$709C,$7100
	dc.w	$0000,$8000
	dc.w	$73DB,$7400
	dc.w	$0000,$8000
	dc.w	$7A7C,$7B00
	dc.w	$0000,$8000
	dc.w	$7C35,$7D00
	dc.w	$0000,$8000
	dc.w	$81B4,$8200
	dc.w	$0000,$8000
	dc.w	$83FD,$8400
	dc.w	$0000,$8000
	dc.w	$8973,$8A00
	dc.w	$0000,$8000
	dc.w	$9033,$9100
	dc.w	$0000,$8000
	dc.w	$997B,$9A00
	dc.w	$0000,$8000
	dc.w	$9BBF,$9C00
	dc.w	$0000,$8000
	dc.w	$A339,$A400
	dc.w	$0000,$8000
	dc.w	$A505,$A600
	dc.w	$0000,$8000
	dc.w	$A75B,$A800
	dc.w	$0000,$8000
	dc.w	$A9B0,$AA00
	dc.w	$0000,$8000
	dc.w	$ADF1,$AE00
	dc.w	$0000,$8000
	dc.w	$AF91,$B000
	dc.w	$0000,$8000
	dc.w	$BA52,$BB00
	dc.w	$0000,$8000
	dc.w	$BC20,$BD00
	dc.w	$0000,$8000
	dc.w	$BE87,$BF00
	dc.w	$0000,$8000
	dc.w	$C04B,$C100
	dc.w	$0000,$8000
	dc.w	$C2CB,$C300
	dc.w	$0000,$8000
	dc.w	$CCA1,$CD00
	dc.w	$0000,$8000
	dc.w	$D21D,$D300
	dc.w	$0000,$8000
	dc.w	$D450,$D500
	dc.w	$0000,$8000
	dc.w	$E116,$E200
	dc.w	$0000,$8000
	dc.w	$E93F,$EA00
	dc.w	$0000,$8000
	dc.w	$F0B9,$F100
	dc.w	$0000,$8000
	dc.w	$F77C,$F800
	dc.w	$0000,$8000
	dc.w	$F99D,$FA00
	dc.w	$0000,$8000
	dc.w	$FEEF,$FF00
	dc.w	$0000,$8000
	dc.w	$0FCF,$1006
	dc.w	$0000,$8000
	dc.w	$1487,$1506
	dc.w	$0000,$8000
	dc.w	$1661,$1706
	dc.w	$0000,$8000
	dc.w	$1B22,$1C06
	dc.w	$0000,$8000
	dc.w	$0000,$0000

Sprite5:
	dc.w	$2C2D,$2D00
	dc.w	$8000,$8000
	dc.w	$2E83,$2F00
	dc.w	$8000,$8000
	dc.w	$44C1,$4500
	dc.w	$8000,$8000
	dc.w	$4691,$4700
	dc.w	$8000,$8000
	dc.w	$4859,$4900
	dc.w	$8000,$8000
	dc.w	$4A2B,$4B00
	dc.w	$8000,$8000
	dc.w	$4C0D,$4D00
	dc.w	$8000,$8000
	dc.w	$5EA8,$5F00
	dc.w	$8000,$8000
	dc.w	$6787,$6800
	dc.w	$8000,$8000
	dc.w	$695F,$6A00
	dc.w	$8000,$8000
	dc.w	$6BD1,$6C00
	dc.w	$8000,$8000
	dc.w	$6DAA,$6E00
	dc.w	$8000,$8000
	dc.w	$7865,$7900
	dc.w	$8000,$8000
	dc.w	$7ADF,$7B00
	dc.w	$8000,$8000
	dc.w	$7CDA,$7D00
	dc.w	$8000,$8000
	dc.w	$7EC1,$7F00
	dc.w	$8000,$8000
	dc.w	$80A6,$8100
	dc.w	$8000,$8000
	dc.w	$8250,$8300
	dc.w	$8000,$8000
	dc.w	$8405,$8500
	dc.w	$8000,$8000
	dc.w	$8609,$8700
	dc.w	$8000,$8000
	dc.w	$955E,$9600
	dc.w	$8000,$8000
	dc.w	$97DD,$9800
	dc.w	$8000,$8000
	dc.w	$9FA1,$A000
	dc.w	$8000,$8000
	dc.w	$A1D4,$A200
	dc.w	$8000,$8000
	dc.w	$A349,$A400
	dc.w	$8000,$8000
	dc.w	$A52B,$A600
	dc.w	$8000,$8000
	dc.w	$A77A,$A800
	dc.w	$8000,$8000
	dc.w	$AC0D,$AD00
	dc.w	$8000,$8000
	dc.w	$AEA4,$AF00
	dc.w	$8000,$8000
	dc.w	$B0E2,$B100
	dc.w	$8000,$8000
	dc.w	$BB75,$BC00
	dc.w	$8000,$8000
	dc.w	$C232,$C300
	dc.w	$8000,$8000
	dc.w	$C485,$C500
	dc.w	$8000,$8000
	dc.w	$C6BC,$C700
	dc.w	$8000,$8000
	dc.w	$C8E1,$C900
	dc.w	$8000,$8000
	dc.w	$CCFD,$CD00
	dc.w	$8000,$8000
	dc.w	$D0CC,$D100
	dc.w	$8000,$8000
	dc.w	$D26D,$D300
	dc.w	$8000,$8000
	dc.w	$D440,$D500
	dc.w	$8000,$8000
	dc.w	$DA04,$DB00
	dc.w	$8000,$8000
	dc.w	$DC63,$DD00
	dc.w	$8000,$8000
	dc.w	$E1AA,$E200
	dc.w	$8000,$8000
	dc.w	$F5E7,$F600
	dc.w	$8000,$8000
	dc.w	$FA2B,$FB00
	dc.w	$8000,$8000
	dc.w	$0471,$0506
	dc.w	$8000,$8000
	dc.w	$0E43,$0F06
	dc.w	$8000,$8000
	dc.w	$10D9,$1106
	dc.w	$8000,$8000
	dc.w	$16BD,$1706
	dc.w	$8000,$8000
	dc.w	$2336,$2406
	dc.w	$8000,$8000
	dc.w	$2993,$2A06
	dc.w	$8000,$8000
	dc.w	$0000,$0000
