/*       ( -   Workbench`) */

MODULE 'intuition/intuition'  ->    intuition.m

ENUM ERR_NONE, ERR_WIN, ERR_KICK, ERR_PUB ->   

RAISE ERR_WIN IF OpenWindowTagList()=NIL, ->  :  
      ERR_PUB IF LockPubScreen()=NIL      ->    

->     ,     close 

PROC main() HANDLE ->     
  DEF test_window=NIL, test_screen=NIL ->    

  IF KickVersion(37)=FALSE THEN Raise(ERR_KICK) ->  

  ->    
  test_screen:=LockPubScreen('Workbench') ->   

  ->     tag-
  test_window:=OpenWindowTagList(NIL,
                                [WA_LEFT,  0,  WA_TOP,    11,
                                 WA_WIDTH, 640, WA_HEIGHT, 30,
                                 WA_DRAGBAR,       TRUE,
                                 WA_CLOSEGADGET,   TRUE,
                                 WA_SMARTREFRESH,  TRUE,
                                 WA_NOCAREREFRESH, TRUE,
                                 WA_DEPTHGADGET,   TRUE,
                                 WA_IDCMP,         IDCMP_CLOSEWINDOW,
                                 WA_TITLE,         'Window Title',
                                 WA_PUBSCREEN,     test_screen,
                                 NIL])

  ->  
  UnlockPubScreen(NIL, test_screen)

  ->    NIL,    
  test_screen:=NIL

  ->      
  handle_window_events(test_window)

  ->      
EXCEPT DO
  IF test_window THEN CloseWindow(test_window)
  IF test_screen THEN UnlockPubScreen(NIL, test_screen)
  SELECT exception ->    
  CASE ERR_KICK; WriteF('Error: Needs Kickstart V37+\n')
  CASE ERR_PUB;  WriteF('Error: Could not lock public screen\n')
  CASE ERR_WIN;  WriteF('Error: Failed to open window\n')
  ENDSELECT
ENDPROC

->  ,    -  
PROC handle_window_events(win)
  REPEAT
  UNTIL WaitIMessage(win)=IDCMP_CLOSEWINDOW
ENDPROC
