/*
	Source code for at89cx051 programmer

	Compiled with SAS/C

	look at scheme for hardware details

	thanks go to RDC: his picprog.c from devpic package
	helped me to do some tricky system-related things :)

	better viewed with tab size of 2 chars

	$VER: at89cx051 progger (c) LVD, ver 1.0
*/

#include <exec/memory.h>
#include <clib/dos_protos.h>
#include <clib/exec_protos.h>
#include <clib/misc_protos.h>
#include <clib/timer_protos.h>
#include <pragmas/exec_sysbase_pragmas.h>
#include <pragmas/timer_pragmas.h>
#include <pragmas/misc_pragmas.h>
#include <pragmas/dos_pragmas.h>
#include <resources/misc.h>
#include <utility/tagitem.h>
#include <dos/dos.h>
#include <dos/dosextens.h>
#include <dos/dostags.h>

#define ARGTMPL "W=WRITE/K,R=READ/K,V=VERIFY/S,E=ERASE/S,L=LOCK/S,HELP/S"

#define DATA_PORT *((STRPTR)0xBFE101)
#define DATA_DIR  *((STRPTR)0xBFE301)
#define AUX_PORT  *((STRPTR)0xBFD000)
#define AUX_DIR   *((STRPTR)0xBFD200)

#define INPUTS  0x00
#define OUTPUTS 0xFF

#define ATMEL      0x1E
#define AT89C1051  0x11
#define AT89C1051U 0x12
#define AT89C2051  0x21
#define AT89C4051  0x41

struct Library * DOSBase, * SysBase, * TimerBase, * MiscBase;
struct MsgPort * tmrport;
struct timerequest * tmr_rq;

struct RDArgs * argstru;

__far struct FileInfoBlock fib;

STRPTR pportowner;

BPTR file,inp,outp;

ULONG skip=0;

struct
{
	STRPTR write;
	STRPTR read;
	ULONG  verify;
	ULONG  erase;
	ULONG  lock;
	ULONG  help;
} ares = { NULL, NULL, 0, 0, 0, 0 };

struct v_err
{
	ULONG addr;
	UBYTE found;
	UBYTE expected;
};

struct v_err * firsterr;

__far static UBYTE databuf[4096];

ULONG signature;
ULONG flashsize;
ULONG temp;


ULONG          chip_ReadSignature(void);
void           chip_ReadFlash(UBYTE *,ULONG);
void           chip_EraseFlash(void);
struct v_err * chip_VerifyFlash(UBYTE *,ULONG);
void           chip_ProgramFlash(UBYTE *,ULONG);
void           chip_SetLock(void);

UBYTE hard_Init(void);
void  hard_deInit(void);
void  hard_ShutDown(void);
void  hard_SelChipReg(UBYTE,UBYTE);
void  hard_Write(UBYTE);
UBYTE hard_Read(void);
void  hard_IO(UBYTE);

void WR_LO(void);
void WR_HI(void);
void RD_LO(void);
void RD_HI(void);
void WREG_LO(void);
void WREG_HI(void);


__saveds main()
{
	SysBase = *((struct Library **)4L);

	if(DOSBase = OpenLibrary("dos.library",36))
	{
		Printf("\n%s\n\n",6+"$VER: at89cx051 progger (c) LVD, ver 1.0 "__AMIGADATE__);

		inp=Input();
		outp=Output();

		if(argstru = ReadArgs(ARGTMPL,(LONG *)&ares,NULL))
		{
			if( ares.help!=0 )
			{
				Printf("Help on usage:\n\n");
				Printf("HELP:   Print this help.\n");
				Printf("WRITE:  Name of file which should be written to chip.\n");
				Printf("READ:   Name of file to which chip flash memory content should be saved.\n");
				Printf("VERIFY: Verify chip flash memory content after programming and erasing.\n");
				Printf("ERASE:  Erase chip. When reprogramming chip, use ERASE.\n");
				Printf("LOCK:   Disable further reading/writing of flash memory. ERASE clears flash\n");
				Printf("        memory & then resets lock.\n\n");
				Printf("You can mix args:\n");
				Printf("'READ name1 WRITE name2 VERIFY LOCK ERASE' means first save flash\n");
				Printf("to <name1>, then erase chip & write there <name2>, verify it & then set a lock.\n\n");
				Printf("All files are just binaries, starting from zero address in chip flash.\n\n");
				Printf("With no args just signature of chip will be read.\n\n");
				Printf("On beginning, green LED is on, prog is waiting for inserting chip\n");
				Printf("Then press 'enter', action will start.\n");
				Printf("On completion, prog will wait for chip removing, then turn off LEDs.\n\n");

			}
			else
			{
				if(tmrport = CreateMsgPort())
				{
					if(tmr_rq = (struct timerequest *)CreateIORequest(tmrport,sizeof(struct timerequest)))
					{
						if(!OpenDevice(TIMERNAME,UNIT_MICROHZ,(struct IORequest *)tmr_rq,0))
						{
							if(MiscBase = OpenResource(MISCNAME))
							{
								if(pportowner=AllocMiscResource(MR_PARALLELPORT,"at89cx051 progger"))
								{
									Printf("Can't allocate parallel port - it's already owned by %s!\n",pportowner);
								}
								else
								{
									if( hard_Init()!=0 )
									{
										Flush(inp);
										Printf("Insert chip...\n");
										FGetC(inp);

										signature=chip_ReadSignature();
										Printf("Signature is: $%8.lx\n",signature);
										signature>>=16;

										switch(signature)
										{
											case (ATMEL<<8)+AT89C1051:
												Printf("Chip: AT89c1051 (1Kb flash).\n\n");
												flashsize=1024;
												break;
											case (ATMEL<<8)+AT89C1051U:
												Printf("Chip: AT89c1051u (1Kb flash).\n\n");
												flashsize=1024;
												break;
											case (ATMEL<<8)+AT89C2051:
												Printf("Chip: AT89c2051 (2Kb flash).\n\n");
												flashsize=2048;
												break;
											case (ATMEL<<8)+AT89C4051:
												Printf("Chip: AT89c4051 (4Kb flash).\n\n");
												flashsize=4096;
												break;
											default:
												Printf("Unknown, bad or missing chip!\n\n");
												goto NoAction;
										}


										if( ares.read!=NULL )
										{
											if( (file=Open(ares.read,MODE_NEWFILE))!=0 )
											{
												Printf("Reading chip flash content...");Flush(outp);
												chip_ReadFlash(databuf,flashsize);
												Printf(" Done!\n");
												if( flashsize!=Write(file,databuf,flashsize) )
												{
													Printf("Can't successfully write to file <%s>!\n",ares.read);
													skip=1;
												}
												Close(file);
											}
											else
											{
												Printf("Can't open file <%s> for writing flash content!\n",ares.read);
												skip=1;
											}
										Printf("\n");
										}
										if(skip) goto NoAction;


										if( ares.erase!=0 )
										{
											Printf("Erasing chip flash...");Flush(outp);
											chip_EraseFlash();
											Printf(" Done!\n");

											if( ares.verify!=0 )
											{
												for(temp=0;temp<flashsize;temp++)
												{
													databuf[temp]=0xFF;
												}

												Printf("Verifying erase...");Flush(outp);
												firsterr=chip_VerifyFlash(databuf,flashsize);
												if( firsterr->addr==0xFFFFFFFF )
												{
													Printf(" All O.K.!\n");
												}
												else
												{
													Printf(" Failed!\nFirst err at %lx:",firsterr->addr);
													Printf(" expected %lx, found %lx.\n",(ULONG)firsterr->expected,(ULONG)firsterr->found);
													skip=1;
												}
											}
										Printf("\n");
										}
										if(skip) goto NoAction;

										
										if( ares.write!=NULL )
										{
											if( (file=Open(ares.write,MODE_OLDFILE))!=0 )
											{
												ExamineFH(file,&fib);
												if( fib.fib_Size>flashsize )
												{
													Printf("File <%s> (%ld bytes) is larger than flash memory size!\n",ares.write,fib.fib_Size);
													skip=1;
												}
												else
												{
													if( fib.fib_Size!=Read(file,databuf,fib.fib_Size) )
													{
														Printf("Can't successfully read from file <%s>!\n",ares.write);
														skip=1;
													}
													else
													{
														Printf("Programming chip flash...");Flush(outp);
														chip_ProgramFlash(databuf,fib.fib_Size);
														Printf(" Done!\n");

														if( ares.verify!=0 )
														{
															Printf("Verifying program...");Flush(outp);
															firsterr=chip_VerifyFlash(databuf,fib.fib_Size);
															if( firsterr->addr==0xFFFFFFFF )
															{
																Printf(" All O.K.!\n");
															}
															else
															{
																Printf(" Failed!\nFirst err at $%lx:",firsterr->addr);
																Printf(" expected $%lx, found $%lx.\n",(ULONG)firsterr->expected,(ULONG)firsterr->found);
																skip=1;
															}
														}
													}
												}
												Close(file);
											}
											else
											{
												Printf("Can't open file <%s> for programming to flash!\n",ares.write);
												skip=1;
											}
										Printf("\n");
										}
										if(skip) goto NoAction;

										if( ares.lock!=0 )
										{
											Printf("Setting lock...");Flush(outp);
											chip_SetLock();
											Printf(" Done!\n\n");
										}

										NoAction:
										hard_deInit();

										Flush(inp);
										Printf("Remove chip...\n");
										FGetC(inp);

										hard_ShutDown();
									}
									else
									{
										Printf("Bad or missing hardware!\n");
									}

									FreeMiscResource(MR_PARALLELPORT);
								}
							}
							else
							{
								Printf("Can't open %s!\n",MISCNAME);
							}

							CloseDevice((struct IORequest *)tmr_rq);
						}
						else
						{
							Printf("Can't open %s!\n",TIMERNAME);
						}

						DeleteIORequest((struct IORequest *)tmr_rq);
					}
					else
					{
						Printf("Can't create IORequest!\n");
					}

					DeleteMsgPort(tmrport);
				}
				else
				{
					Printf("Can't create msgport!\n");
				}
			}

			FreeArgs(argstru);
		}
		else
		{
			Printf("Error in arguments!\n");
		}

		CloseLibrary(DOSBase);
	}

	return(0);
}



ULONG chip_ReadSignature(void)
{
	ULONG signature=0;
	UBYTE counter;

	hard_SelChipReg(0,3);
	hard_Write(0x98);//0b10011000 - PA & PC4-7 - inputs

	hard_SelChipReg(0,2);
	hard_Write(0x02);

	hard_SelChipReg(0,1);
	hard_Write(0x82);
	hard_Write(0x02);//0b00000010

	for(counter=0;counter<4;counter++)
	{
		hard_SelChipReg(0,0);
		signature=((signature<<8)&0xFFFFFF00)+hard_Read();

		hard_SelChipReg(0,1);
		hard_Write(0x03);//pulse XTAL1 to increment addr
		hard_Write(0x02);
	}

	return signature;
}

void chip_ReadFlash(UBYTE * buffer,ULONG bytecount)
{
	ULONG actualadr;

	hard_SelChipReg(0,3);
	hard_Write(0x98);//0b10011000 - PA & PC4-7 - inputs

	hard_SelChipReg(0,2);
	hard_Write(0x02);

	hard_SelChipReg(0,1);
	hard_Write(0xB2);//0b10110010
	hard_Write(0x32);//0b00110010

	for(actualadr=0;actualadr<bytecount;actualadr++)
	{
		hard_SelChipReg(0,0);
		buffer[actualadr]=hard_Read();

		hard_SelChipReg(0,1);
		hard_Write(0x33);//pulse XTAL1 to increment addr
		hard_Write(0x32);
	}
}

void chip_EraseFlash(void)
{
	ULONG sigmsk;
	
	hard_SelChipReg(0,3);
	hard_Write(0x98);//0b10011000 - PA & PC4-7 - inputs

	hard_SelChipReg(0,2);
	hard_Write(0x02);

	hard_SelChipReg(0,1);
	hard_Write(0x06);//0b00000110 - /PROG high
	hard_Write(0x46);//0b01000110 - raise Vpp to 12v

	tmr_rq->tr_node.io_Command = TR_ADDREQUEST; // prepare timer request for 10ms erase pulse
	tmr_rq->tr_time.tv_secs    = 0;
	tmr_rq->tr_time.tv_micro   = 10*1000;

	sigmsk=1<<(tmrport->mp_SigBit);// extract msgport signal mask from its bitnumber
	
	Forbid();	//since any other task can make Forbid();while(1); or something like,
						//erase pulse can become VERY long, & this can damage chip.
						//so we make Forbid() then waiting in loop for timer request complete :-E

	hard_Write(0x44);//0b01000100 - begin /PROG pulse
	
	SendIO( (struct IORequest *)tmr_rq );//initiate timer request

	while( !(SetSignal(0L,sigmsk)&sigmsk) );//wait for message by looking at msgport signal

	hard_Write(0x46);//0b01000110 - end /PROG pulse

	Permit(); //at least, everything starts functioning :)

	WaitIO( (struct IORequest *)tmr_rq );//request already completed, so this just removes it from replyport

	hard_Write(0x06);// turn off +12v
}

struct v_err * chip_VerifyFlash(UBYTE * buffer,ULONG bytecount)
{
	static struct v_err ferr;
	ULONG actualadr;

	ferr.addr=0xFFFFFFFF;

	hard_SelChipReg(0,3);
	hard_Write(0x98);//0b10011000 - PA & PC4-7 - inputs

	hard_SelChipReg(0,2);
	hard_Write(0x02);

	hard_SelChipReg(0,1);
	hard_Write(0xB2);//0b10110010
	hard_Write(0x32);//0b00110010

	for(actualadr=0;actualadr<bytecount;actualadr++)
	{
		hard_SelChipReg(0,0);

		if( (ferr.expected=buffer[actualadr])!=(ferr.found=hard_Read()) )
		{
			ferr.addr=actualadr;
			break;
		}

		hard_SelChipReg(0,1);
		hard_Write(0x33);//pulse XTAL1 to increment addr
		hard_Write(0x32);
  }

	return &ferr;
}

void chip_ProgramFlash(UBYTE * buffer,ULONG bytecount)
{
	ULONG actualadr;

	hard_SelChipReg(0,3);
	hard_Write(0x88);//0b10001000 - PC4-7 - inputs

	hard_SelChipReg(0,2);
	hard_Write(0x02);

	hard_SelChipReg(0,1);
	hard_Write(0xBA);//0b10111010
	hard_Write(0x3A);//0b00111010

	hard_Write(0x7A);//0b01111010 - Raise Vpp to 12v

	for(actualadr=0;actualadr<bytecount;actualadr++)
	{
		hard_SelChipReg(0,0);
		hard_Write(buffer[actualadr]);

		hard_SelChipReg(0,1);
		hard_Write(0x78);//0b01111000
		hard_Write(0x7A);//0b01111010 - pulse /PROG

		hard_SelChipReg(0,2);
		while( !(hard_Read()&0x80) ); // wait until prog cycle done
		
		hard_SelChipReg(0,1);
		hard_Write(0x7B);//pulse XTAL1 to increment addr
		hard_Write(0x7A);
	}

	hard_Write(0x3A);//turn off 12v
	hard_Write(0x80);// all pins to GND

	hard_SelChipReg(0,0);
	hard_Write(0x00);

	hard_SelChipReg(0,2);
	hard_Write(0x03);// power-off & small delay
	hard_Write(0x03);
	hard_Write(0x02);// power-on
}

void chip_SetLock(void)
{
	hard_SelChipReg(0,3);
	hard_Write(0x98);//0b10011000 - PA & PC4-7 - inputs

	hard_SelChipReg(0,2);
	hard_Write(0x02);

	hard_SelChipReg(0,1);
	hard_Write(0xBE);//0b10111110 - prepare for 1st lock bit programming
	hard_Write(0x3E);//0b00111110

	hard_Write(0x7E);//0b01111110 - Raise Vpp to 12v

	hard_Write(0x7C);//0b01111100
	hard_Write(0x7E);//0b01111110 - pulse /PROG

	tmr_rq->tr_node.io_Command = TR_ADDREQUEST; // wait 3ms for lockbit writing
	tmr_rq->tr_time.tv_secs    = 0;
	tmr_rq->tr_time.tv_micro   = 3*1000;
	DoIO( (struct IORequest *)tmr_rq ); // perform timer request
	
	hard_Write(0x4E);//0b01001110 - 2nd bit programming

	hard_Write(0x4C);
	hard_Write(0x4E);// pulse /PROG

	tmr_rq->tr_node.io_Command = TR_ADDREQUEST;
	tmr_rq->tr_time.tv_secs    = 0;
	tmr_rq->tr_time.tv_micro   = 3*1000;
	DoIO( (struct IORequest *)tmr_rq );
	
	hard_Write(0x0E);// turn off 12v
}




UBYTE	hard_Init(void)
{// make init of hardware
	UBYTE ok=1;
	
  hard_IO(INPUTS);

	AUX_DIR|=0x07;	//make BUSY, SEL, POUT pins outputs
	WR_HI();RD_HI();WREG_LO();	//set their initial states

	hard_SelChipReg(0,3);//select conf reg of first chip
	hard_Write(0x80);//write its value

	hard_SelChipReg(0,0);
	hard_Write(0);

	hard_SelChipReg(0,1);
	hard_Write(0x80);//HV1=1 - RST/Vpp tied to GND

	hard_SelChipReg(0,2);
	hard_Write(0x01);//turn on green LED

	//check if init ok: look at port regs state
	hard_SelChipReg(0,0);
	if( hard_Read()!=0x00 ) ok=0;

	hard_SelChipReg(0,1);
	if( hard_Read()!=0x80 ) ok=0;

	hard_SelChipReg(0,2);
	if( hard_Read()!=0x01 ) ok=0;

	return ok;// return 0 if error init, otherwise non-0 (1)
}

void hard_deInit(void)
{//prepare for chip removing
	hard_SelChipReg(0,3);
	hard_Write(0x80);// all 8255 pins - outputs

	hard_SelChipReg(0,0);
	hard_Write(0);

	hard_SelChipReg(0,1);
	hard_Write(0x80);//HV1=1 - RST/Vpp tied to GND

	hard_SelChipReg(0,2);
	hard_Write(0x01);//turn off power, turn on green LED
}

voidhard_ShutDown(void)
{//shutdown hardware ;)
	hard_SelChipReg(0,0);
	hard_Write(0);

	hard_SelChipReg(0,1);
	hard_Write(0x80);//HV1=1 - RST/Vpp tied to GND

	hard_SelChipReg(0,2);
	hard_Write(0x03);//turn off LEDs & power

	hard_SelChipReg(0xFF,0);// deselect 8255 chip: /CS=1
}

void hard_SelChipReg(UBYTE chipnum,UBYTE regnum)
{// selects chip & reg by writing to flipflops
	UBYTE flipflops;

	if( chipnum<=5 )
	{
		flipflops=(0x04<<chipnum);
		flipflops^=0xFF;
	}
	else
	{
		flipflops=0xFF;
	}

	flipflops=(flipflops&0xFC)|(regnum&0x03);

	hard_IO(OUTPUTS);
	DATA_PORT=flipflops;
	WREG_HI();WREG_LO();
}


void hard_IO(UBYTE newmode)
{
	static UBYTE oldmode=1; // modes are either 0 or 0xff, so first init will occur always

	if( (newmode==INPUTS) || (newmode==OUTPUTS) )
	{
		if( oldmode!=newmode )
		{
			oldmode=newmode;
			DATA_DIR=newmode;
		}
	}
}


void hard_Write(UBYTE byte)
{
	hard_IO(OUTPUTS);
	DATA_PORT=byte;
	WR_LO();WR_HI();
}

UBYTE hard_Read(void)
{
	UBYTE read;
	hard_IO(INPUTS);
	RD_LO();
	read=DATA_PORT;
	RD_HI();

	return read;
}


void WR_LO(void)
{
	AUX_PORT&=0xFD;
}

void WR_HI(void)
{
	AUX_PORT|=0x02;
}

void RD_LO(void)
{
	AUX_PORT&=0xFE;
}

void RD_HI(void)
{
	AUX_PORT|=0x01;
}

void WREG_LO(void)
{
	AUX_PORT&=0xFB;
}

void WREG_HI(void)
{
	AUX_PORT|=0x04;
}

