//________________________________________________________________________________________________________________________________________________________________________

#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <math.h>

#include "psplugin.h"

//________________________________________________________________________________________________________________________________________________________________________

#define cMaxPlugins 100
int render = 1;

rShinePluginInformation_t rInfo[cMaxPlugins];
bool MouseOver[cMaxPlugins];

//________________________________________________________________________________________________________________________________________________________________________

extern "C" __declspec(dllexport)
void close( int ID )
{
	render = 0;
}

//________________________________________________________________________________________________________________________________________________________________________

extern "C" __declspec(dllexport)
void update( int timer, int ID, rShinePluginUpdate_t rShinePluginUpdate )
{
	if( 1 == render )
	{
		if( MouseOver[ID] )
		{
			memset( rInfo[ID].renderBuffer, 255, rInfo[ID].xres*rInfo[ID].yres*4 );
		}
		else
		{
			for( int i=0; i<rInfo[ID].xres*rInfo[ID].yres; i++ )
			{
				rInfo[ID].renderBuffer[i] = rand()%0xffffff;
			}
		}
	}
}

//________________________________________________________________________________________________________________________________________________________________________

extern "C"__declspec(dllexport)
void open( rShinePluginInformation_t rShinePluginInformation ) 
{
	static char tempFilename[4096];
	if( cMaxPlugins <= rShinePluginInformation.ID )
	{
		render = 0;
		MessageBox( NULL, "ID Error", "Too many plugins of this kind", MB_OK );
	}
	else
	{
		render = 1;

		// init local data
		memcpy( &rInfo[rShinePluginInformation.ID], &rShinePluginInformation, sizeof( rShinePluginInformation_t ) );

		// load image
		//shineLibrary* poLib = new shineLibrary();
		//poLib->openArchive( rShinePluginInformation.libraryName );
		//poLib->seekFile( Filename );
		//poLib->readPCX( poLib->getFile(), where );
		//poLib->closeArchive();
		//delete poLib;
	}
}

//________________________________________________________________________________________________________________________________________________________________________

extern "C" __declspec(dllexport)
rShinePluginAction_t* event( eShinePluginEvent_t eShinePluginEvent, int mouseX, int mouseY, int ID )
{
	switch( eShinePluginEvent )
	{
		case cSPMouseOver:
			MouseOver[ID] = true;
			break;
		case cSPMouseLeft:
			break;
		case cSPMouseAway:
			MouseOver[ID] = false;
			break;
	}

  return NULL;
}

//________________________________________________________________________________________________________________________________________________________________________
