unit coolmaus;

interface
type pixelarray=array[1..8,1..8] of byte;

var mousehg:pixelarray;
    mousebild:array[0..1] of pixelarray;


function knopf:integer;
function hor:integer;
function ver:integer;
procedure cursoran;
procedure cursoraus;
procedure init;
procedure grenzen(links,oben,rechts,unten:integer);
procedure setzmaus(hor,ver:integer);
procedure restorehg(x,y:word);
procedure savehg(x,y:word);
procedure putmouse(x,y,nr:word);
procedure initmausbild;

implementation
uses dos;
var reg:registers;

procedure initmausbild;
var f:file;
begin
     assign(f,'mouse.dat');
     reset(f,1);
     blockread(f,mousebild,sizeof(mousebild));
     close(f);
end;

procedure savehg(x,y:word);
var zx,zy,cy:word;
begin
  cy:=0;
  y:=(y*320)-640;
  x:=x-1;
  for zy:=1 to 8 do begin
    inc(cy,320);
    for zx:=1 to 8 do
      mousehg[zx,zy]:=mem[$A000:x+zx+y+cy];
  end;
end;

procedure restorehg(x,y:word);
var zx,zy,cy:word;
begin
  cy:=0;
  y:=(y*320)-640;
  x:=x-1;
  for zy:=1 to 8 do begin
    inc(cy,320);
    for zx:=1 to 8 do
      mem[$A000:x+zx+y+cy]:=mousehg[zx,zy];
  end;
end;

procedure putmouse(x,y,nr:word);
var zx,zy,cy:word;
begin
  cy:=0;
  y:=(y*320)-640;
  x:=x-1;
  for zy:=1 to 8 do begin
    inc(cy,320);
    for zx:=1 to 8 do
      if mousebild[nr,zx,zy]<>0 then mem[$A000:zx+x+cy+y]:=mousebild[nr,zx,zy];
  end;
end;

function Knopf:integer;
         begin
              with reg do
                   begin
                        ax:=3;
                        intr(51,reg);
                        knopf:=bx;
                   end;
         end;
function hor:integer;
         begin
              with reg do
                   begin
                        ax:=3;
                        intr(51,reg);
                        hor:=cx;
                   end;
         end;
function ver:integer;
         begin
              with reg do
                   begin
                        ax:=3;
                        intr(51,reg);
                        ver:=dx;
                   end;
         end;

procedure init;
          begin
               with reg do
                    begin
                         ax:=0;
                         intr(51,reg);
                    end;
          end;
procedure cursoran;
          begin
               with reg do
                    begin
                         ax:=1;
                         intr(51,reg);
                    end;
          end;
procedure cursoraus;
          begin
               with reg do
                    begin
                         ax:=2;
                         intr(51,reg);
                    end;
          end;
procedure setzmaus(hor,ver:integer);
          begin
               with reg do
                    begin
                         ax:=4;
                         cx:=hor;
                         dx:=ver;
                         intr(51,reg);
                    end;
          end;
procedure grenzen(links,oben,rechts,unten:integer);
          begin
               with reg do
                    begin
                         ax:=7;
                         cx:=links;
                         dx:=rechts;
                         intr(51,reg);
                         ax:=8;
                         cx:=oben;
                         dx:=unten;
                         intr(51,reg);
                    end;
          end;

begin
end.
