// can't remember where i found that code
// credits go to the appropriate author

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>
#include "waveout.h"

#define MAX_BUFFERS 8

static HWND MMSYS_WindowHandle;
static ULong MMSYS_ProcessedBytes;
static bool MMSYS_Open;
static ULong MMSYS_Buffers;
static ULong MMSYS_Buffersize;
static ULong MMSYS_Freq;
static ULong MMSYS_Bits;
static ULong MMSYS_Channels;
static ULong MMSYS_SampleSize;
static HWAVEOUT MMSYS_WaveOut = NULL;
static WAVEHDR MMSYS_WaveHeader[MAX_BUFFERS];
static bool MMSYS_Paused;

static void CALLBACK WaveProc(HWAVEOUT hwi,UINT uMsg,DWORD dwInstance,DWORD dwParam1,DWORD dwParam2)
{
 WAVEHDR *WH = (WAVEHDR *)dwParam1;
 if(uMsg == MM_WOM_DONE)
 {
  waveOutUnprepareHeader(hwi,WH,sizeof(WAVEHDR));
  WH->dwUser = 0;
  if(MMSYS_Buffers) MMSYS_Buffers--;
 }
}

bool AUDIO_Open(ULong Frequency,ULong Bits,ULong Channels,ULong Buffersize)
{
 ULong X;
 MMRESULT Res;
 static WAVEFORMATEX WFE;

 MMSYS_Freq = Frequency;
 MMSYS_SampleSize = (Bits >> 3) << (Channels - 1);
 MMSYS_Buffersize = (Buffersize * MMSYS_SampleSize) / MAX_BUFFERS;
 MMSYS_Buffers = 0;
 MMSYS_Bits = Bits;
 MMSYS_Channels = Channels;
 if(Channels > 2) return false;
 if(Bits != 16 && Bits != 8) return false;
 memset(&WFE,0,sizeof(WAVEFORMATEX));
 WFE.wFormatTag = WAVE_FORMAT_PCM;
 WFE.nChannels = (UWord)Channels;
 WFE.nSamplesPerSec = Frequency;
 WFE.wBitsPerSample = (UWord)Bits;
 WFE.nBlockAlign = (WFE.wBitsPerSample >> 3) << (WFE.nChannels - 1);
 WFE.nAvgBytesPerSec = WFE.nSamplesPerSec * WFE.nBlockAlign;
 for(X=0;X<MAX_BUFFERS;X++)
 {
  MMSYS_WaveHeader[X].dwBufferLength = MMSYS_Buffersize;
  MMSYS_WaveHeader[X].lpData = (SByte *)calloc(1,MMSYS_Buffersize);
  MMSYS_WaveHeader[X].dwUser = 0;
  MMSYS_WaveHeader[X].dwLoops = 0;
  MMSYS_WaveHeader[X].dwFlags = 0;
  MMSYS_WaveHeader[X].lpNext = NULL;
  if(MMSYS_WaveHeader[X].lpData == NULL) break;
 }
 Res = waveOutOpen(&MMSYS_WaveOut,
	 WAVE_MAPPER,
	 &WFE,
	 (unsigned long)WaveProc,
	 0,
	 CALLBACK_FUNCTION);
 return true;
}

void AUDIO_Close()
{
 ULong X;
 waveOutReset(MMSYS_WaveOut);
 Sleep(77);
 waveOutClose(MMSYS_WaveOut);
 for(X=0;X<MAX_BUFFERS;X++) if(MMSYS_WaveHeader[X].lpData) free(MMSYS_WaveHeader[X].lpData);
}

bool AUDIO_Write(void *Buf)
{
 ULong Cur = 0, X; UByte *Buffer = (UByte *)Buf;
 for(X=0;X<MAX_BUFFERS;X++) if(!MMSYS_WaveHeader[X].dwUser) Cur = X;
 MMSYS_WaveHeader[Cur].dwBufferLength = MMSYS_Buffersize;
 MMSYS_WaveHeader[Cur].dwFlags = 0;
 MMSYS_WaveHeader[Cur].dwUser = 1;
 MMSYS_WaveHeader[Cur].lpNext = NULL;
 MMSYS_WaveHeader[Cur].dwLoops = 0;
 CopyMemory(MMSYS_WaveHeader[Cur].lpData,Buffer,MMSYS_Buffersize);
 if(waveOutPrepareHeader(MMSYS_WaveOut,&MMSYS_WaveHeader[Cur],sizeof(WAVEHDR)) != MMSYSERR_NOERROR) return false;
 if(waveOutWrite(MMSYS_WaveOut,&MMSYS_WaveHeader[Cur],sizeof(WAVEHDR)) != MMSYSERR_NOERROR) return false;
 MMSYS_Buffers++;
 return true;
}

bool AUDIO_Pause()
{
 if(MMSYS_Paused)
 {
  waveOutRestart(MMSYS_WaveOut);
  MMSYS_Paused = false;
 } else
 {
  waveOutPause(MMSYS_WaveOut);
  MMSYS_Paused = true;
 }
 return true;
}

bool AUDIO_GetPauseState()
{
 return MMSYS_Paused;
}

bool AUDIO_Reset()
{
 ULong X;
 waveOutReset(MMSYS_WaveOut); Sleep(77);
 for(X=0;X<MAX_BUFFERS;X++) MMSYS_WaveHeader[X].dwUser = 0;
 MMSYS_Buffers = 0;
 return true;
}

ULong AUDIO_GetWriteLength()
{
 return MMSYS_Buffersize / MMSYS_SampleSize;
}

bool AUDIO_Ready()
{
 if(MMSYS_Buffers < MAX_BUFFERS - 1) return true;
 return false;
}

void AUDIO_Init()
{
 MMSYS_ProcessedBytes = 0;
 MMSYS_Paused = false;
 MMSYS_Open = false;
}

void AUDIO_Kill()
{
 if(MMSYS_Open) AUDIO_Close();
 MMSYS_Open = false;
}
