{ Nmeth kos 1995 }

program KeyMagic;

uses Crt;

var
  SoundOn: Boolean;
  C: Integer;
  I: Byte;
  LEDs: Array[0..2] of Boolean;


procedure RefreshLEDs;
var
  LEDOn: Byte;
begin
  LEDOn := 0;
  If LEDs[0] then LEDOn := LEDOn or $02;
  If LEDs[1] then LEDOn := LEDOn or $04;
  If LEDs[2] then LEDOn := LEDOn or $01;
  Port[$60] := $ED;
  Delay(10);
  Port[$60] := LEDOn;
  Delay(10);
end;

procedure SetALED(LED, Color: Byte);
begin
  LED := LED and $03;
  If Color <> 0 then LEDs[LED] := true
    else LEDs[LED] := false;
  RefreshLEDs;
end;

procedure ClearLEDs;
var
  I: Byte;
begin
  For I := 0 to 2 do LEDs[I] := false;
end;

procedure RestoreLEDs;
var
  BIOSKey: Byte;
begin
  BIOSKey := Mem[$0000:$0417];
  For I := 0 to 2 do LEDs[I] := false;
  If BIOSKey and $20 = $20 then LEDs[0] := true;
  If BIOSKey and $40 = $40 then LEDs[1] := true;
  If BIOSKey and $10 = $10 then LEDs[2] := true;
  RefreshLEDs;
end;

procedure BreakOut;
begin
  If KeyPressed then
    begin
      ReadKey;
      RestoreLEDs;
      Nosound;
      Halt;
    end;
end;

procedure Right;
var
  J,
  F: Integer;
begin
 C := 0;
 F := 0;
 WriteLn('1. Light goes right...');
 repeat
  For I := 0 to 2 do
    begin
      SetALED(I, 1);
      For J := 1 to 100 do
       begin
         Inc(F);
         If SoundOn then Sound(F * 5);
         Delay(1);
       end;
    end;
  F := 0;
  NoSound;
  For I := 0 to 2 do
    begin
      SetALED(I, 0);
      Delay(100);
    end;
  BreakOut;
  Inc(C);
  until C = 10;
end;

procedure Left;
var
  J,
  F: Integer;
begin
 F := 500;
 C := 0;
 WriteLn('2. Light goes left...');
 repeat
  For I := 2 downto 0 do
    begin
      SetALED(I, 1);
      For J := 1 to 100 do
       begin
         Dec(F);
         If SoundOn then Sound(F * 5);
         Delay(1);
       end;
    end;
  F := 500;
  NoSound;
  For I := 2 downto 0 do
    begin
      SetALED(I, 0);
      Delay(100);
    end;
  BreakOut;
  Inc(C);
  until C = 10;
end;

procedure Vibrations;
begin
 C := 0;
 WriteLn('3. Flickering lights...');
  repeat
    SetALED(Random(3), Random(2) - 1);
    If SoundOn then Sound(Random(10000));
    Delay(20);
    BreakOut;
    Inc(C);
  until C = 250;
  NoSound;
end;

procedure RandomLEDs;
begin
 C := 0;
 WriteLn('4. LEDs lights randomly...');
  repeat
    For I := 0 to 2 do LEDs[I] := false;
    SetALED(Random(3), 1);
    If SoundOn then Sound(Random(10) * 100);
    Delay(50);
    BreakOut;
    Inc(C);
  until C = 200;
end;

procedure KnightRider;
var
  I, J, F: Integer;
begin
 C := 0;
 WriteLn('5. Knight Rider...');
  repeat
    F := 1000 - 3 * 90 * 2;
    For I := 0 to 2 do
      begin
        For J := 0 to 2 do LEDs[J] := false;
        SetALED(I, 1);
        For J := 1 to 90 do
          begin
            Inc(F, 2);
            If SoundOn then Sound(F);
            Delay(1);
          end;
      end;
    F := 1000;
    For I := 2 downto 0 do
      begin
        For J := 0 to 2 do LEDs[J] := false;
        SetALED(I, 1);
        For J := 1 to 90 do
        begin
          Dec(F, 2);
          If SoundOn then Sound(F);
          Delay(1);
        end;
      end;
  BreakOut;
  Inc(C);
  until C = 15;
end;

procedure Equalizer;
var
  J: Integer;
  L: Byte;
begin
 C := 0;
 WriteLn('6. Digital Equalizer...');
  repeat
    For I := 0 to 2 do LEDs[I] := false;
    L := Random(4);
    If L <> 0 then
      begin
        For I := 0 to L - 1 do LEDs[I] := true;
      end;
    RefreshLEDs;
    For J := 0 to 145 do
    If SoundOn then
    begin
      Sound((L + 1) * 150);
      Sound((L + 1) * 151);
      Sound((L + 1) * 152);
      Delay(1);
    end;
    BreakOut;
    Inc(C);
  until C = 50;
  NoSound;
end;

procedure Crash;
var
  J, I: Integer;
begin
  WriteLn('7. System crash..');
  C := 0;
  { 1 LED villog lassan... }
  WriteLn;
  repeat
    ClearLEDs;
    If C and 16 = 16 then
      begin
        SetALed(0, 1);
        If SoundOn then Sound(100);
      end
    else
      NoSound;
    RefreshLEDs;
    Delay(20);
    BreakOut;
    Inc(C);
  until C = 100;
  { 2 - LED lass, gyorsabb }
  C := 0;
  repeat
    ClearLEDs;
    If C and 16 = 16 then LEDs[0] := true;
    If (C) and 8 = 8 then
      begin
        LEDs[1] := true;
        If SoundOn then Sound(400);
      end
      else
        NoSound;
    Delay(10);
    RefreshLEDs;
    BreakOut;
    Inc(C);
  until C = 100;
  { 3 LED }
  C := 0;
  repeat
    ClearLEDs;
    If C and 16 = 16 then LEDs[0] := true;
    If (C) and 8 = 8 then LEDs[1] := true;
    If (C) and 4 = 4 then
      begin
        LEDs[2] := true;
        If SoundOn then Sound(800);
      end
      else
        NoSound;
    Delay(10);
    RefreshLEDs;
    BreakOut;
    Inc(C);
  until C = 100;
  { robbans }
  For J := 0 to 2 do LEDs[J] := true;
  RefreshLEDs;
  For I := 0 to 10000 do
  begin
    IF SoundOn then Sound(Mem[$FF00:I]);
    Delay(1);
    BreakOut;
  end;
  For I := 10000 downto 6000 do
  begin
    If SoundOn then Sound(I);
    Delay(1)
  end;
  LEDs[1] := false;
  RefreshLEDs;
  For I := 6000 downto 3000 do
  begin
    If SoundOn then Sound(I);
    Delay(1)
  end;
  LEDs[2] := false;
  RefreshLEDs;
  For I := 3000 downto 0 do
  begin
    If SoundOn then Sound(I);
    Delay(1)
  end;
  LEDs[0] := false;
  RefreshLEDs;
  NoSound;
  Delay(1000);
end;

procedure PlayMagic;
begin
  Right;
  Left;
  Vibrations;
  RandomLEDs;
  KnightRider;
  Equalizer;
  Crash;
end;

begin
  WriteLn;
  Writeln('                       LED DEMO  (c) 1995 Nmeth kos');
  Write('');
  WriteLn(' Use /NOSOUND parameter to disable sound effects, press ANY key to exit demo!');
  WriteLn;
  SoundOn := true;
  If (ParamStr(1) = '/NOSOUND') or
     (ParamStr(1) = '/nosound') then SoundOn := false;
  PlayMagic;
  RestoreLEDs;
end.