.286

segment data
w equ word ptr
b equ byte ptr
num_voices equ 14

;**************************************************************************
;***                    D A T E N S E G M E N T                         ***
;**************************************************************************

  gefunden      db ?

;**************************************************************************
;***                      Z U W E I S U N G E N                         ***
;**************************************************************************

  Play_Voice equ 0
  Stop_Voice equ 3
  Bit8       equ 0
  Bit16      equ 4
  No_Loop    equ 0
  Mit_Loop   equ 8
  Unidirect  equ 0
  Bidirect   equ 16
  Go_forw    equ 0
  Go_Back    equ 64
data ends

;**************************************************************************
;***                      C O D E S E G M E N T                         ***
;**************************************************************************

segment code
  assume cs:code, ds:data

;**************************************************************************
;***               P U B L I C  -  D E K L A R A T I O N E N            ***
;**************************************************************************


  u_base     dw 240h
  u_status   dw u_base+006h
  u_voice    dw u_base+102h
  u_command  dw u_base+103h
  u_Datalo   dw u_base+104h
  u_Datahi   dw u_base+105h
  u_DramIO   dw u_base+107h



oldUVolumes dw 01000h,0B000h,0B100h,0B200h,0B300h,0B400h,0B500h,0B600h,0B700h
         dw 0B800h,0B900h,0BA00h,0BB00h,0BC00h,0BD00h,0BE00h,0BF00h
         dw 0C000h,0C100h,0C200h,0C300h,0C400h,0C500h,0C600h,0C700h
         dw 0C800h,0C900h,0CA00h,0CB00h,0CC00h,0CD00h,0CE00h,0CF00h
         dw 0D000h,0D100h,0D200h,0D300h,0D400h,0D500h,0D600h,0D700h
         dw 0D800h,0D900h,0DA00h,0DB00h,0DC00h,0DD00h,0DE00h,0DF00h
         dw 0E000h,0E100h,0E200h,0E300h,0E400h,0E500h,0E600h,0E700h
         dw 0E800h,0E900h,0EA00h,0EB00h,0EC00h,0ED00h,0EE00h,0EF00h


UVolumes  DW 1500h
	DW 40004,42600,44752,45648,46544,47624,48448,49232
	DW 50048,50584,51112,51656,52184,52584,52976,53376
	DW 53752,54016,54280,54520,54768,55024,55280,55544
	DW 55776,56048,56288,56536,56784,56992,57184,57384
	DW 57616,57752,57888,58000,58112,58248,58368,58480
	DW 58600,58720,58840,58960,59088,59208,59336,59464
	DW 59584,59720,59816,59944,60072,60176,60312,60408
	DW 60544,60648,60784,60888,60992,61064,61176,61248


Voice_Divisor db 43,40,37,35,33,31,30,28,27,26,25,24,23,22,21,20,20,19,18

FFtable dw   66,   70,   74,   78,   83,   88,   93,   99,  104,  111
        dw  117,  124,  132,  139,  148,  156,  166,  176,  186,  197
        dw  209,  221,  234,  248,  263,  279,  295,  313,  331,  351
        dw  372,  394,  418,  442,  469,  497,  526,  557,  591,  626
        dw  663,  702,  744,  788,  835,  885,  938,  993, 1052, 1115
        dw 1181, 1251, 1326, 1405, 1488, 1577, 1671, 1770, 1875, 1987
        dw 2105, 2230, 2362, 2503, 2652, 2809, 2977, 3154, 3341, 3540


Modoktave  dw 1712,1616,1525,1440,1359,1283,1211
           dw 1143,1078,961,907,856,808,763,720
           dw 679,641,605,571,539,509,480,453,428
           dw 404,381,360,340,321,303,286,270,254
           dw 240,227,214,202,191,180,170,160,151
           dw 143,135, 127,120,113,107,101,95,90
           dw 85,80,76,71,67,64,60,57,54,50,47,45
           dw 42,40,38,36,34,32,30

public U_StartVoice
public u_VoiceBalance
public u_VoiceVolume
public u_delay
public u_Initialize
public u_Voicefreq
public Ultra_Mem2Gus
public u_Voicedata
public ffaktor
public Notennr
public dos_getmem
public dos_freemem
public detect_gus
public init_gus_base
public GusSound_ein
public GusSound_aus
public voice_rampin
public voice_slidein

u_delay proc pascal
; **************************************************************************
; *** Wartet die fr Double-writes bentigte Zeit                        ***
; **************************************************************************
  mov dx,300h
  in al,dx
  in al,dx
  in al,dx
  in al,dx
  in al,dx
  in al,dx
  in al,dx
  ret
u_delay endp

U_StartVoice proc pascal Nr,Modus : byte
; **************************************************************************
; *** Startet die Ausgabe auf einem GUS-Kanal                            ***
; **************************************************************************
  mov dx,w u_voice                ; Stimme whlen
  mov al,byte ptr Nr
  out dx,al
  mov dx,w u_command
  mov al,0                        ; Voice Mode
  out dx,al
  mov dx,w u_DataHi
  mov al,Modus                    ; MODUS Byte setzen
  out dx,al
  ret
U_StartVoice endp

u_VoiceBalance proc pascal Nr,balance : byte
; **************************************************************************
; *** Stellt die Pan-Position fr einen Kanal ein (0 - 15)               ***
; **************************************************************************
  mov dx,w u_Voice                ; Stimme whlen
  mov al,byte ptr Nr
  out dx,al
  mov dx,w u_Command              ; Befehl Set Pan-Position
  mov al,0Ch
  out dx,al
  mov dx,w u_dataHi               ; Position schreiben
  mov al,balance
  out dx,al
  ret
u_VoiceBalance endp

u_VoiceVolume proc pascal Nr:byte,Vol:word
; **************************************************************************
; *** Stellt die Lautstrke fr einen Kanal ein  (0 - 63)                ***
; **************************************************************************
    mov dx,w u_Voice              ; Stimme whlen
    mov al,Nr
    out dx,al
    mov dx,w u_Command            ; Befehl Lautstrke setzen
    mov al,9
    out dx,al
    mov dx,w u_DataLo             ; GUS-Lautstrke aus Tabelle laden
    mov di,vol                    ; und setzen
    shl di,1
    mov ax,word ptr [offset uVolumes + di]
    out dx,ax
    ret
u_VoiceVolume  endp

u_Initialize proc near
; **************************************************************************
; *** Initialisiert die Ultrasound                                       ***
; **************************************************************************
  mov bx,w u_Command
  mov cx,w u_datahi
  mov dx,bx
  mov al,4ch                      ; Init - Register whlen
  out dx,al
  mov dx,cx
  mov al,0                        ; Init durchfhren
  out dx,al
  call u_delay                    ; warten
  call u_delay
  mov dx,bx
  mov al,4ch
  out dx,al
  mov dx,cx
  mov al,1                        ; Init beenden
  out dx,al
  call u_delay
  call u_delay
  mov dx,bx                       ; DMA Control Register resetten
  mov al,41h
  out dx,al
  mov dx,cx
  mov al,0
  out dx,al
  mov dx,bx                       ; Timer Control Register resetten
  mov al,45h
  out dx,al
  mov dx,cx
  mov al,0
  out dx,al
  mov dx,bx                       ; Sampling Control Register resetten
  mov al,49h
  out dx,al
  mov dx,cx
  mov al,0
  out dx,al
  mov dx,bx                       ; Anzahl Stimmen setzen
  mov al,0Eh
  out dx,al
  add dx,2
  mov al,Num_Voices
  or  al,0C0h
  out dx,al
  mov dx,w u_status               ; Evtl. DMA Interrupts leeren
  in al,dx
  mov dx,bx
  mov al,41h
  out dx,al
  mov dx,cx
  in al,dx
  mov dx,bx                       ; Evtl. Sampling Interrupts leeren
  mov al,49h
  out dx,al
  mov dx,cx
  in al,dx
  mov dx,bx                       ; IRQ Status Register lesen
  mov al,8Fh                      ; ==> Es liegen jetzt keine unbearbeiteten
  out dx,al                       ;     Interrupts an
  mov dx,cx
  in al,dx
  push bx                         ; In Schleife die Stimmen ausschalten
  push cx
  mov cx,0
@VoiceClearLoop:
  mov dx,w u_Voice                ; Stimme whlen
  mov al,cl
  out dx,al
  inc dx
  mov al,0                        ; Voice Modus setzen
  out dx,al
  add dx,2
  mov al,3                        ; Stimme stoppen
  out dx,al
  sub dx,2                        ; Lautstrke auf 0 setzen
  mov al,0dh
  out dx,al
  add dx,2
  mov al,3
  out dx,al
  inc cx
  cmp cx,32                       ; fr alle Stimmen wiederholen
  jnz @VoiceClearLoop
  pop cx
  pop bx
  mov dx,bx                       ; Eventuell aufgetretene Interrupts
  mov al,41h                      ; "abarbeiten"
  out dx,al
  mov dx,cx
  in al,dx
  mov dx,bx
  mov al,49h
  out dx,al
  mov dx,cx
  in al,dx
  mov dx,bx
  mov al,8fh
  out dx,al
  mov dx,cx
  in al,dx
  mov dx,bx                       ; Reset durchfhren
  mov al,4ch
  out dx,al
  mov dx,cx                       ; GF1 Master IRQ einschalten
  mov al,7
  out dx,al
  ret
u_Initialize endp

u_Voicefreq proc pascal Nr:byte,Freq:word
; **************************************************************************
; *** Stellt die Frequenz ein, mit der der Kanal abgespielt wird         ***
; **************************************************************************
  mov dx,w u_Voice                ; Stimme adressieren
  mov al,Nr
  out dx,al
  mov dx,w u_Command              ; Befehl Voicefreqenz schreiben
  mov al,1
  out dx,al                       ; Freq := Freqenz DIV
  xor bx,bx                       ;         Voice_Divisor[num_voices-13]
  mov bl,num_voices
  mov ax,Freq
;  mov di,bx
;  sub di,14
;  xor bx,bx
;  xor dx,dx
;  mov bl,byte ptr [voice_Divisor+di]
;  div bx
  mov dx,w u_DataLo
  out dx,ax
  ret
u_Voicefreq endp


Ultra_Mem2Gus proc pascal sampp:dword,start:dword,laenge:word
; **************************************************************************
; *** Kopiert einen Speicherbereich aus dem RAM ins GUS-Ram              ***
; **************************************************************************
    push ds
    push si
    mov si,[bp+12]                ; Segment
    mov ds,si
    mov si,[bp+10]                ; Offset
    mov dx,w u_Command            ; Hi-Byte der GUS-DRAM Adresse setzen
    mov al,44h
    out dx,al
    mov dx,w u_DataHi
    mov ax,[bp+08]                ; hstart
    out dx,al
    mov cx,[bp+4]                 ; Lnge laden
@Copy_loop:
    mov dx,w u_Command            ; Lo-Byte der GUS-DRAM Adresse setzen
    mov al,43h
    out dx,al
    mov dx,w u_DataLo
    mov ax,[bp+06]                ; lstart
    out dx,ax
    mov dx,w u_DramIo             ; Byte laden und ausgeben
    lodsb
    out dx,al
    cmp word ptr [bp+06],0ffffh   ; lstart = 0ffffh ?
    je @ueberlauf
    inc word ptr [bp+06]          ; lstart++
    jmp @weiter
@ueberlauf:
    inc word ptr [bp+08]          ; hstart ++
    mov word ptr [bp+06],0        ; lstart auf 0
    mov dx,w u_Command            ; Hi-Byte der GUS-DRAM Adresse setzen
    mov al,44h
    out dx,al
    mov dx,w u_DataHi
    mov ax,[bp+08]                ; hstart
    out dx,al
@weiter:
    loop @copy_loop
    pop si
    pop ds
    ret
Ultra_Mem2Gus endp

u_Voicedata proc pascal start,lsta,llaenge:dword,Nr:word
; **************************************************************************
; *** Setzt die Partameter fr einen Kanal                               ***
; **************************************************************************
    mov dx,w u_Voice              ; Stimme whlen
    mov ax,Nr
    out dx,al
    mov dx,w u_command            ; Stimmenanfang setzen
    mov al,0ah
    out dx,al
    mov ax, word ptr [start+2]
    mov cx, word ptr [start]
    mov bx,cx
    shr ax,7
    shr cx,7
    shl bx,9
    or  ax,bx
    mov dx,w u_DataLo
    out dx,ax
    mov dx,w u_Command
    mov al,0bh
    out dx,al
    mov dx,w u_datalo
    mov ax,word ptr [start]
    shl ax,9
    out dx,ax
    mov dx,w u_command            ; Loop-Start setzen
    mov al,2
    out dx,al
    mov ax, word ptr [lsta]
    mov cx, word ptr [lsta+2]
    mov bx,cx
    shr ax,7
    shr cx,7
    shl bx,9
    or  ax,bx
    mov dx,w u_DataLo
    out dx,ax
    mov dx,w u_Command
    mov al,3
    out dx,al
    mov dx,w u_datalo
    mov ax,word ptr [lsta]
    shl ax,9
    out dx,ax
    mov dx,w u_command            ; Loop-Ende setzen
    mov al,4
    out dx,al
    mov ax, word ptr [llaenge]
    mov cx, word ptr [llaenge+2]
    mov bx,cx
    shr ax,7
    shr cx,7
    shl bx,9
    or  ax,bx
    mov dx,w u_DataLo
    out dx,ax
    mov dx,w u_Command
    mov al,5
    out dx,al
    mov dx,w u_datalo
    mov ax,word ptr [llaenge]
    shl ax,9
    out dx,ax
   ret
u_Voicedata endp

ffaktor proc pascal t:word
; **************************************************************************
; ***  Liefert die Frequenz des in "t" bergebenen Tons                  ***
; **************************************************************************
 mov di,t
 sub di,5
 shl di,1
 mov ax,word ptr [offset fftable+di]
 ret
ffaktor endp

Notennr proc pascal hoehe:word
; **************************************************************************
; *** Bestimmt die Nummer der Note ber die "hoehe" des Tons aus der     ***
; *** MOD-Datei                                                          ***
; **************************************************************************
  mov gefunden,1
  xor di,di
@schleife:
  mov ax,word ptr Modoktave[di]
  cmp hoehe,ax
  ja note_gefunden
  add di,2
;  cmp di,128
  cmp di,140
  jae @weiter_arbeiten
  jmp @schleife
note_gefunden:
  mov gefunden,0
@weiter_arbeiten:
  mov ax,255
  cmp gefunden,0
  jne Ende_Notennr
  mov ax,di
  shr ax,1
  inc ax
Ende_Notennr:
  ret
Notennr endp

dos_getmem proc pascal zeiger:dword,menge:word
; **************************************************************************
; *** Allociert einen (max. 64 KB grosen) Speicherbereich im DOS-Ram     ***
; **************************************************************************
  push ds
  mov bx,menge
  shr bx,4
  inc bx
  mov ah,48h
  int 21h
  mov bx,w [zeiger+2]
  mov ds,bx
  mov bx,w [zeiger]
  mov w [bx],0
  mov w [bx+2],ax
  pop ds
  ret
dos_getmem endp

dos_freemem proc pascal zeiger:dword
; **************************************************************************
; *** Gibt einen ber dos_getmem allocierten Bereich wieder frei         ***
; **************************************************************************
  mov ax,word ptr [zeiger+2]
  mov es,ax
  mov ah,49h
  int 21h
  ret
dos_freemem endp

detect_gus proc near
; **************************************************************************
; *** Die Routine dient zur Erkennung der Gravis Ultrasound. Der Base-   ***
; *** Port wird erkannt. Die Funktion liefert 0, wenn die Karte gefunden ***
; *** wurde, ansonsten 1.                                                ***
; **************************************************************************
  mov di,1F0h
@detect_loop:                     ; In einer Schleife mgliche Ports testen
  add di,10h
  mov dx,di
  add dx,103h                     ; Initialisierung versuchen
  mov al,4Ch
  out dx,al
  mov dx,di
  add dx,105h
  mov al,0
  out dx,al ;?????
  call u_delay
  call u_delay
  mov dx,di
  add dx,103h
  mov al,4Ch
  out dx,al
  mov dx,di
  add dx,105h
  mov al,1
  out dx,al ;????
  mov dx,di                       ; Versuchen, Daten in das GUS-Ram zu
  add dx,103h                     ; schreiben
  mov al,43h
  out dx,al
  mov dx,di
  add dx,105h
  mov al,0h
  out dx,al
  mov dx,di
  add dx,103h
  mov al,44h
  out dx,al
  mov dx,di
  add dx,105h
  mov al,0h
  out dx,al
  mov dx,di
  add dx,107h
  mov al,0AAh
  out dx,al
  call u_delay                    ; entsprechend warten, damit uns der GF1
  call u_delay                    ; nicht dazwischen pfuschen kann
  call u_delay
  call u_delay
  call u_delay
  call u_delay
  xor ax,ax                       ; Wert aus GUS-Ram zurcklesen
  mov dx,di
  add dx,107h
  in  al,dx
  cmp al,0AAh                     ; Gelesener Wert = geschriebenem Wert ?
  je  @Karte_gefunden             ; Juhuuuu, Karte gefunden !
  cmp di,280h
  jae @Karte_nicht_gefunden       ; Keine Karte an den Ports zu finden  :(
  jmp @detect_loop                ; Neuen Port versuchen
@Karte_gefunden:
  mov w u_base,di                 ; Basisregister der Karte initialisieren
  mov ax,di
  add ax,6
  mov w u_status,ax
  mov ax,di
  add ax,102h
  mov w u_voice,ax
  mov ax,di
  add ax,103h
  mov w u_command,ax
  mov ax,di
  add ax,104h
  mov w u_Datalo,ax
  mov ax,di
  add ax,105h
  mov w u_Datahi,ax
  mov ax,di
  add ax,107h
  mov w u_DramIO,ax
  mov ax,0
  jmp @Ende_Kartenerkennung
@Karte_nicht_gefunden:
  mov ax,1
@Ende_Kartenerkennung:
  ret
detect_gus endp

init_gus_base proc pascal gbase : word;
; **************************************************************************
; *** Die Routine dient zur Erkennung der Gravis Ultrasound. Der Base-   ***
; *** Port wird erkannt. Die Funktion liefert 0, wenn die Karte gefunden ***
; *** wurde, ansonsten 1.                                                ***
; **************************************************************************
  mov di,gbase
  mov dx,di
  add dx,103h                     ; Initialisierung versuchen
  mov al,4Ch
  out dx,al
  mov dx,di
  add dx,105h
  mov al,0
  out dx,al ;?????
  call u_delay
  call u_delay
  mov dx,di
  add dx,103h
  mov al,4Ch
  out dx,al
  mov dx,di
  add dx,105h
  mov al,1
  out dx,al ;????

  mov w u_base,di                 ; Basisregister der Karte initialisieren
  mov ax,di
  add ax,6
  mov w u_status,ax
  mov ax,di
  add ax,102h
  mov w u_voice,ax
  mov ax,di
  add ax,103h
  mov w u_command,ax
  mov ax,di
  add ax,104h
  mov w u_Datalo,ax
  mov ax,di
  add ax,105h
  mov w u_Datahi,ax
  mov ax,di
  add ax,107h
  mov w u_DramIO,ax
  mov ax,0
  ret
init_gus_base endp


GusSound_aus proc near
; **************************************************************************
; *** Schaltet die Sound-Ausgabe der GUS aus                             ***
; **************************************************************************
  mov dx,w u_base
  in  al,dx
  or  al,2
  out dx,al
  ret
GusSound_aus endp

GusSound_ein proc near
; **************************************************************************
; *** Schaltet die Sound-Ausgabe (Wavetabel) der GUS ein.                ***
; **************************************************************************
  mov dx,w u_base
  in  al,dx
  and al,0FDh
  out dx,al
  ret
GusSound_ein endp

voice_rampin proc pascal Stimme:byte,vol : word;
; **************************************************************************
; *** Eine Alternative zum dirketen Setzen der Lautstrke einer Stimme.  ***
; *** Der Player verliert etwas an Agressivitt, jedoch wird evtl.       ***
; *** Knacken erheblich reduziert.                                       ***
; **************************************************************************
  mov dx,w u_voice                ; Stimme whlen
  mov al,byte ptr Stimme
  out dx,al
  mov dx,w u_command              ; Ramping-Faktor setzen
  mov al,6
  out dx,al
  mov dx,w u_datahi
  mov al,00111111b
  out dx,al
  mov dx,w u_Command              ; Aktuelle Lautstrke anpassen
  mov al,9
  out dx,al
  mov dx,w u_datahi
  mov al,00010010b
  out dx,al
  mov dx,w u_command              ; Ramping Start-Lautstrke setzen
  mov al,7
  out dx,al
  mov dx,w u_datahi
  mov al,00010010b
  out dx,al
  mov dx,w u_command              ; Ramping End-Lautstrke setzen
  mov al,8
  out dx,al
  mov dx,w u_datahi
  mov di,word ptr vol
  shl di,1
  mov ax,word ptr [offset uVolumes + di]
  shr ax,8
  out dx,al
  mov dx,w u_command              ; Ramping Richtung im Volume Control
  mov al,0dh                      ; Register setzen
  out dx,al
  mov dx,w u_datahi
  mov al,0
  out dx,al
  ret
voice_rampin endp

voice_slidein proc pascal nr,speed : byte,vol : word;
  mov dx,w u_voice                ; Stimme whlen
  mov al,byte ptr nr
  out dx,al
  mov dx,w u_command              ; Ramping-Faktor setzen
  mov al,6
  out dx,al
  mov dx,w u_datahi
  mov al,byte ptr speed
  out dx,al
  mov dx,w u_Command              ; Aktuelle Lautstrke anpassen
  mov al,9
  out dx,al
  mov dx,w u_datahi
  mov al,00010010b
  out dx,al
  mov dx,w u_command              ; Ramping Start-Lautstrke setzen
  mov al,7
  out dx,al
  mov dx,w u_datahi
  mov al,00010010b
  out dx,al
  mov dx,w u_command              ; Ramping End-Lautstrke setzen
  mov al,8
  out dx,al
  mov dx,w u_datahi
  mov di,word ptr vol
  shl di,1
  mov ax,word ptr [offset uVolumes + di]
  shr ax,8
  out dx,al
  mov dx,w u_command              ; Ramping Richtung im Volume Control
  mov al,0dh                      ; Register setzen
  out dx,al
  mov dx,w u_datahi
  mov al,0
  out dx,al
  ret
voice_slidein endp

public gus_speaker_on
gus_speaker_on proc pascal
  mov dx,u_base
  mov al,4
  out dx,al
  ret
gus_speaker_on endp

public get_stimmenposition
get_stimmenposition proc pascal stimme : word
  mov dx,w u_command
  mov al,4
  out dx,al
  mov dx,w u_datahi
  in  ax,dx
  mov cx,ax

  ret
get_stimmenposition endp

public get_detected_base
get_detected_base proc pascal
  mov ax,u_base
  ret
get_detected_base endp

code ends
end

