unit NonStop;                         {Makes your program UNSTOPPABLE!}

interface

 var
   Intr09 : pointer absolute $0000:$0024; {Interrupt $09, keyboard ISR}
   OldIntr09 : pointer;                   {Original Interrupt $09     }

const
   NoBoot  : boolean = true;              {flag to disable soft boot  }
   NoBreak : boolean = False;              {flag to disable Ctrl-Break }
   NoCtrlC : boolean = False;              {flag to disable Ctrl-C     }

 procedure InstallNonStopISR;
 procedure NonStopExitProc;

implementation

 var
   PreNonStopExitProc : pointer;

 const
   Installed : boolean = false;

 procedure NonStopISR; External; {$L NonStop}

 procedure InstallNonStopISR;

 begin
  if not Installed then
  begin
   OldIntr09 := Intr09;
   inline($fa);                       {CLI - disable interrupts         }
   Intr09 := @NonStopISR;              {Link NonStop into interrupt chain}
   inline($fb);                       {STI - enable interrupts          }
   PreNonStopExitProc := ExitProc;    {Save old ExitProc                }
   ExitProc := @NonStopExitProc;      {Link in NonStopExitProc          }
   Installed := true;
  end;
 end;

 procedure NonStopExitProc;

 begin
  ExitProc := PreNonStopExitProc;      {Point ExitProc to next  }
  inline($fa);                         {CLI - disable interrupts}
  Intr09 := OldIntr09;                 {Restore Original Vector }
  inline($fb);                         {STI - enable interrupts }
 end;

end.