Unit NormVGA;
{$A+,D+,E+,G+,N+,B-,F-,I-,L-,P-,Q-,R-,S-,T-,V-,X-} {...damit es luft...}
Interface

Type
  FarbPalette = Array[0..255] of Record
                                   R,G,B : Byte;
                                 End;
  Zeichen_Satz = Array[0..255] of Array[0..7] of Byte;
  LinePuffer = Array[0..520] of Byte;
  VideoRam = Array[0..64049] of Byte;
  VideoPointer = ^VideoRam;
  String12 = String[12];

  TFliHeader = Record
                 Size : LongInt;
                 Magic,Frames,Width,Height,Depth,Flags,Speed,Expand : Word;
                 Dummy : Array[1..108] of Byte;
               End;

  TFrameHeader = Record
                   Size : LongInt;
                   Magic,Chunks : Word;
                   Expand : Array[1..8] of Byte;
                 End;

  TChunk = Record
             Size : LongInt;
             CType : Word;
           End;

  TCache = Array[1..61440] of Byte;

  SPal = Array[0..255] of Record
                                   R,G,B : Byte;
                                 End;

  TVGA = Object
    Constructor Init(NeuerModus : Boolean);
      Procedure SetPalette(Pal : FarbPalette);
      Procedure GetPalette(S,Nr : Integer; Var Pal : FarbPalette);
      Procedure ReadPAL(DateiName : String);
      Procedure SavePAL(DateiName : String; Pal : FarbPalette);
      Procedure SetColor(Nr,R,G,B : Byte);
      Procedure ClearScreen;
      Procedure ClearMemPage;
      Procedure ClearPage(VideoPage : VideoPointer);
      Procedure ReadGFX(DateiName : String; IntoMemory : Boolean);
      Procedure ReadGFXNr(DateiName : String; IntoMemory : Boolean; Nr : integer);
      Procedure ReadGFXOfFile(DateiName : String; Position : longint; IntoMemory : Boolean);
      Procedure ReadSDT(SDTName : String; gfxName : String12; IntoMemory : Boolean);
      Procedure ReadRaw(DateiName : String; PalName : String; IntoMemory : Boolean);
      Procedure ReadRawofFile(DateiName : String; P : longint; IntoMemory : Boolean);
      Procedure ReadMGP(MGPName : String; gfxName : String12; IntoMemory : Boolean);
      Procedure Hide;
      Procedure Show;
      Procedure CopyPal(Source, Target : FarbPalette);
      Procedure MakePalBlack(Pal : FarbPalette);
      Procedure Make_bw(WorkPal : FarbPalette);
      Procedure FadeInAll(UnHide : Boolean);
      Procedure FadeOutAll;
      Procedure FadeTo(ZielPalette : FarbPalette);
      Procedure FadeColorsOut(Anfang,Ende : Byte);
      Procedure FadeColorsIn(Anfang,Ende : Byte);
      Procedure Print(Text : String; X,Y : Integer; Farbe : Byte);
      Procedure PrintMem(Text : String; X,Y : Integer; Farbe : Byte);
      Procedure SetPixel(X,Y : Integer; Farbe : Byte);
      Function GetPixel(X,Y : Integer) : Byte;
      Procedure SaveGFX(DateiName : String);
      Procedure SaveRaw(PalDatName : String; PicDatName : String);
      Procedure ReadPcx(f : String; x,y : Word; IntoMem : Boolean; Skip : Byte);
      Procedure PlayFLI(DatNam : string; Anzahl : integer; SlowDown : Integer; StopFli : Boolean;
      Frame : integer; Time : Integer);
      Procedure Zoom(LObenX,LObenY,Breite,Hoehe,NeueX,NeueY,NeueBreite,NeueHoehe : Integer);
      Procedure MemZoom(LObenX,LObenY,Breite,Hoehe,NeueX,NeueY,NeueBreite,NeueHoehe : Integer);
      procedure Rotiere(AXPos, AYPos, EXPos, EYPos, Direction: Word);
      procedure CopyAll(AXPos,AYPos,Laenge1,Breite1,EXPos,EYPos:Word;Delet:Boolean);
      Procedure MakeGray;
      Procedure MakeColored;
      Procedure ZeichenSatz_Laden;
      Procedure FadePrint(Text : String; X,Y : Integer; Zeit : LongInt);
      Procedure FadeInPrint(Text : String; X,Y : Integer; Zeit : LongInt);
      Procedure FadeOutPrint(Text : String; X,Y : Integer; Zeit : LongInt);
      Procedure Wait(MSek : Integer);
      Procedure Line(VonX,VonY,BisX,BisY : Integer; Farbe : Byte);
      Procedure MemLine(VonX,VonY,BisX,BisY : Integer; Farbe : Byte);
      Procedure Box(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte; FillBox : Boolean);
      Procedure MemBox(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte; FillBox : Boolean);
      Procedure Fill(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte);
      Procedure FillMem(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte);
      Procedure CopyPage(target, source : VideoPointer);
      Procedure ShowMemPage;
      Procedure ShowMem(VideoPage : VideoPointer; Zeile,Anzahl,NeueZeile : Word);
      Procedure ShowPage(VideoPage : VideoPointer);
      Procedure WaitRetrace;
      Procedure WaitDisplay;
      Procedure LoadFont(DateiName : String);
      Procedure RetraceWait(MSek : Integer);
      procedure SetPal1(s,nr:Integer; var p);
      procedure GetPal1(s,nr:Integer; var p);
      Procedure ReadPGP(DateiName : String; IntoMemory : Boolean);
      Procedure SavePGP(DateiName : String);
      Procedure ClearMemoryScreen;
      Procedure SetMemoryPixel(X,Y : Integer; Farbe : Byte);
      Function GetMemoryPixel(X,Y : Integer) : Byte;
    Destructor Done;
  End;


  TSprPuffer = Array[0..22499] of Byte;
  SprPuffer = ^TSprPuffer;

  TSPRITE = Object
    Width,Height : Byte;
    Sprite : SprPuffer;
    Groesse : Integer;
    Constructor Init(Breite,Hoehe : Byte);
      Procedure GrabSprite(X,Y : Integer);
      Procedure DropSprite(X,Y : Integer);
      Procedure ToggleSprite(X,Y : Integer);
      Procedure GrabSpriteFromMemory(X,Y : Integer);
      Procedure DropSpriteIntoMemory(X,Y : Integer);
      Procedure ToggleSpriteIntoMemory(X,Y : Integer);
      Procedure GrabSpriteFromPage(X,Y : Integer; Page : VideoPointer);
      Procedure DropSpriteIntoPage(X,Y : Integer; Page : VideoPointer);
      Procedure ToggleSpriteIntoPage(X,Y : Integer; Page : VideoPointer);
      Procedure SaveSprite(DateiName : String);
      Procedure LoadSprite(DateiName : String);
    Destructor Done;
  End;
      Function IsVga : Boolean;
      Procedure FastMove(Var Source,Dest; Count : Word);
      Procedure CompMove(Var Source,Dest; Count : Word);
      Function KeyIsPressed : Boolean;
      Procedure CopyMem2VRam(Source : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
      Procedure SpriteCopyMem2VRam(Source : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
      Procedure CopyVRam2VRam(X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
      Procedure CopyMem2Mem(Source,Dest : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
      Procedure SpriteCopyMem2Mem(Source,Dest : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
      Procedure InitPage(Var Seite : VideoPointer);
      Procedure DonePage(Var Seite : VideoPointer);
      Procedure ModifyVRam;
      Procedure UnModifyVRam;
      Procedure WriteSDT(SDTName : String; gfxNamen : Array of String12; Menge : Byte);

Var
  ZweiteSeite : VideoPointer;
  DritteSeite : VideoPointer;
  ZeichenSatz : Zeichen_Satz;
  ActivePal : FarbPalette;
  FNT : Boolean;
  DEBUG : Boolean;
  Use8000h : Boolean;
  Counter: Byte;
  Datnam: String;Anzahl: Byte;Wit: Boolean; Time: Byte; Frame: Integer;
  i,j:Word;
  key,skey : char;
  origpal, zielpal : array [0..767] of Byte;
  VGA : TVGA;

Const
  BildXMax = 1600;
  BildYMax = 1200;
  B_XMax = 320;
  B_YMax = 200;
  XS = 50;
  YS = 50;

Implementation
Uses Dos;
Type
  DateiPuffer = Array[0..65534] of Byte;
  DateiZeiger = ^DateiPuffer;

Var
  OldInt10h : Procedure;

Function IsVga : Boolean; Assembler;
Asm
  Mov AH,1Ah
  Xor AL,AL
  PushF
  Call OldInt10h
  Cmp AL,1Ah
  Je @Jmp1
  Mov AL,False
  Jmp @Jmp2
  @Jmp1:
  Mov AL,True
  @Jmp2:
End;

Procedure FastMove(Var Source,Dest; Count : Word); Assembler;
Asm
  Push DS
  LDS SI,Source
  LES DI,Dest
  Mov CX,Count
  Db 66h
  Rep MovsW
  Pop DS
End;

Procedure CompMove(Var Source,Dest; Count : Word); Assembler;
Asm
  Push DS
  LDS SI,Source
  LES DI,Dest
  Mov CX,Count
  Shr CX,2
  @Looping:
  LodsB
  Or AL,AL
  Je @NoDrop
  Mov ES:[DI],AL
  @NoDrop:
  Inc DI
  LodsB
  Or AL,AL
  Je @NoDrop1
  Mov ES:[DI],AL
  @NoDrop1:
  Inc DI
  LodsB
  Or AL,AL
  Je @NoDrop2
  Mov ES:[DI],AL
  @NoDrop2:
  Inc DI
  LodsB
  Or AL,AL
  Je @NoDrop3
  Mov ES:[DI],AL
  @NoDrop3:
  Inc DI
  Dec CX
  Jne @Looping
  Pop DS
End;

Function KeyIsPressed : Boolean; Assembler;
Asm
  Mov AX,0040h
  Mov ES,AX
  Mov DI,001Ah
  Mov BL,ES:[DI]
  Mov DI,001Ch
  Mov CL,ES:[DI]
  Cmp BL,CL
  Jne @Gleich
  Mov AL,False
  Jmp @Ende
  @Gleich:
  Mov AL,True
  @Ende:
End;

Procedure CopyMem2VRam(Source : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
Var
  CounterY : Byte;

Begin
  For CounterY := 0 to Pred(Hoehe) do
    FastMove(Source^[(CounterY + Y) * 320 + X],Mem[$A000 + (CounterY + NeueY) * 20 : NeueX],Breite shr 2);
End;

Procedure SpriteCopyMem2VRam(Source : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
Var
  CounterY : Byte;

Begin
  For CounterY := 0 to Pred(Hoehe) do
    CompMove(Source^[(CounterY + Y) * 320 + X],Mem[$A000 + (CounterY + NeueY) * 20 : NeueX],Breite shr 2);
End;

Procedure CopyVRam2VRam(X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
Var
  CounterY : Byte;

Begin
  For CounterY := 0 to Pred(Hoehe) do
    FastMove(Mem[$A000 + (CounterY + Y) * 20 : X],Mem[$A000 + (CounterY + NeueY) * 20 : NeueX],Breite shr 2);
End;

Procedure CopyMem2Mem(Source,Dest : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
Var
  CounterY : Byte;

Begin
  For CounterY := 0 to Pred(Hoehe) do
    FastMove(Source^[(CounterY + Y) * 320 + X],Dest^[(CounterY + NeueY) * 320 + NeueX],Breite shr 2);
End;

Procedure SpriteCopyMem2Mem(Source,Dest : VideoPointer; X,Y,NeueX,NeueY : Integer; Breite,Hoehe : integer);
Var
  CounterY : Byte;

Begin
  For CounterY := 0 to Pred(Hoehe) do
    CompMove(Source^[(CounterY + Y) * 320 + X],Dest^[(CounterY + NeueY) * 320 + NeueX],Breite shr 2);
End;

Procedure InitPage(Var Seite : VideoPointer);
Begin
  GetMem(Seite,64050);
  FillChar(Seite^,64050,0);
End;

Procedure DonePage(Var Seite : VideoPointer);
Begin
  FillChar(Seite^,64050,0);
  FreeMem(Seite,64050);
End;

Procedure ModifyVRam; Assembler;
Asm
  Mov DX,3C4h
  Mov AL,04
  Out DX,AL
  Inc DX
  In AL,DX
  And AL,11110111b
  Or AL,04
  Out DX,AL
End;

Procedure UnModifyVRam; Assembler;
Asm
  Mov DX,3C4h
  Mov AL,04
  Out DX,AL
  Inc DX
  In AL,DX
  And AL,11110111b
  And AL,04
  Not AL
  Out DX,AL
End;

Procedure WriteSDT(SDTName : String; gfxNamen : Array of String12; Menge : Byte);
Type
  THeader = Record
{              Signature : Array[1..3] of Char;}
              Eintraege : Byte;
              Namen     : Array[1..70] of String12;
              Groessen  : Array[1..70] of Word;
            End;

Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  SizeCounter : LongInt;
  PufferPos : Integer;
  FileCounter : Byte;
  sig : Array[1..20] of char;
  Pal : FarbPalette;
  Header : THeader;
  SDTFile : File;
  F : File;
  i, o : Integer;
  NumRead, NumWritten: Word;
  Buf: array[1..2048] of Char;

Begin
  Writeln('Creating SDT Graphics Library "' + SDTName + '"');
  Assign(SDTFile,SDTName);
  Rewrite(SDTFile,1);
  sig:='SDT Graphics Library';
  BlockWrite(SDTFile,sig,20);
{  Header.Signature := 'SDT';}
  Header.Eintraege := Menge;
  writeln('Writing Header...');
  for i:=0 to Menge do begin;
  Assign(F,GFXNamen[i]);
  Reset(F,1);
  Header.Groessen[i]:=FileSize(F);
  Header.Namen[i]:=GFXNamen[i];
  for o := 1 to Length(GFXNamen[i]) do
  Header.Namen[i,o] := UpCase(Header.Namen[i,o]);
  Close(F);
  end;
  BlockWrite(SDTFile,Header,SizeOf(THeader));
  for i:=0 to Menge do begin;
  writeln('Copying ' + Header.Namen[i] + ' into Library...');
  Assign(F,Header.Namen[i]);
  Reset(F,1);
  repeat
    BlockRead(F, Buf, SizeOf(Buf), NumRead);
    BlockWrite(SDTFile, Buf, NumRead, NumWritten);
  until (NumRead = 0) or (NumWritten <> NumRead);
  Close(F);
  end;
  Close(SDTFile);
end;

Constructor TVGA.Init(NeuerModus : Boolean);
Var
  Sync_Save_Byte : Byte;

Begin
  If (NeuerModus = True) then
  Asm
    Xor AH,AH
    Mov AL,12h
    PushF
    Call OldInt10h
    Mov DX,3CCh
    In AL,DX
    Mov Sync_Save_Byte,AL
    Xor AH,AH
    Mov AL,13h
    PushF
    Call OldInt10h
    Mov AH,Sync_Save_Byte
    And AL,0C0h
    Mov DX,03CCh
    In AL,DX
    And AL,00111111b
    Or AL,AH
    Mov DX,03C2h
    Out DX,AL
  End
  Else
  Asm
    Mov AX,13h
    PushF
    Call OldInt10h
  End;
  GetMem(ZweiteSeite,64050);
  FillChar(ZweiteSeite^,64050,0);
  GetMem(DritteSeite,64050);
  FillChar(DritteSeite^,64050,0);
  FastMove(Ptr($FFA6,$E)^,ZeichenSatz,256);
  FastMove(Ptr(MemW[$0:$7E],MemW[$0:$7C])^,Ptr(Seg(ZeichenSatz),Ofs(ZeichenSatz) + 1024)^,256);
  GetPalette(0,255,ActivePal);
End;

Procedure TVGA.SetPalette(Pal : FarbPalette); Assembler;
Asm
  Push DS
  LDS SI,Pal
  Mov DX,3C8h
  Xor AL,AL
  Out DX,AL
  Inc DX
  Mov CX,768
  Rep OutsB
  Pop DS
End;

Procedure TVGA.GetPalette(S,Nr : Integer; Var Pal : FarbPalette); Assembler;
Asm
  Mov AH,10h
  Mov AL,17h
  Mov BX,S
  Mov CX,Nr
  LES DX,Pal
  PushF
  Call OldInt10h
End;

Procedure TVGA.ReadPAL(DateiName : String);
Var
  Pal : FarbPalette;
  PALFile : File;

Begin
  Assign(PALFile,DateiName);
  Reset(PALFile,1);
  BlockRead(PALFile,Pal,768);
  Close(PALFile);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
End;

Procedure TVGA.SavePAL(DateiName : String; Pal : FarbPalette);
Var
  PALFile : File;

Begin
  Assign(PALFile,DateiName);
  ReWrite(PALFile,1);
  BlockWrite(PALFile,Pal,768);
  Close(PALFile);
End;

Procedure TVGA.SetColor(Nr,R,G,B : Byte); Assembler;
Asm
  Mov DX,3C8h
  Mov AL,Nr
  Out DX,AL
  Inc DX
  Mov AL,R
  Out DX,AL
  Mov AL,G
  Out DX,AL
  Mov AL,B
  Out DX,AL
End;

Procedure TVGA.ClearScreen; Assembler;
Asm
  Mov DX,3C4h
  Mov AL,04
  Out DX,AL
  Inc DX
  In AL,DX
  And AL,11110111b
  Or AL,04
  Out DX,AL
  Mov AX,0A000h
  Mov ES,AX
  Xor DI,DI
  Mov CX,16000
  Xor AL,AL
  @Loop:
  StosB
  Add DI,3
  Dec CX
  Jne @Loop
  Mov DX,3C4h
  Mov AL,04
  Out DX,AL
  Inc DX
  In AL,DX
  And AL,11110111b
  And AL,04
  Not AL
  Out DX,AL
End;

Procedure TVGA.ClearMemPage; Assembler;
Asm
  LES DI,ZweiteSeite
  Mov CX,16000
  Db 66h
  Xor AX,AX
  Db 66h
  Rep StosW
End;

Procedure TVGA.ClearPage(VideoPage : VideoPointer); Assembler;
Asm
  LES DI,VideoPage
  Mov CX,16000
  Db 66h
  Xor AX,AX
  Db 66h
  Rep StosW
End;

Procedure TVGA.ReadRaw(DateiName : String; PalName : String; IntoMemory : Boolean);
Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  PufferPos : Integer;
  Pal : FarbPalette;
  Datei : File;
  FOXHdr : string;

Begin
  Assign(Datei,PalName);
  Reset(Datei,1);
  BlockRead(Datei,Pal,768);
  close(Datei);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  Assign(Datei,DateiName);
  Reset(Datei,1);
  DateiGroesse := FileSize(Datei);
  If (IntoMemory=True) then
  Begin
  BlockRead(Datei,ZweiteSeite^,DateiGroesse);
  End
  Else
  begin
  BlockRead(Datei,Mem[$A000 : 0000],DateiGroesse);
  end;
  Close(Datei);
End;

Procedure TVGA.ReadRawofFile(DateiName : String; P : longint; IntoMemory : Boolean);
Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  PufferPos : Integer;
  Pal : FarbPalette;
  Datei : File;
  FOXHdr : string;

Begin
  Assign(Datei,DateiName);
  Reset(Datei,1);
  Seek(Datei,P);
  BlockRead(Datei,Pal,768);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  DateiGroesse := 64000;
  If (IntoMemory=True) then
  Begin
  BlockRead(Datei,ZweiteSeite^,DateiGroesse);
  End
  Else
  begin
  BlockRead(Datei,Mem[$A000 : 0000],DateiGroesse);
  end;
  Close(Datei);
End;


Procedure TVGA.Readgfx(DateiName : String; IntoMemory : Boolean);
Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  PufferPos : Integer;
  Pal : FarbPalette;
  Datei : File;
  FOXHdr : String;

Begin
  Assign(Datei,DateiName);
  Reset(Datei,1);
  BlockRead(Datei,FOXHdr,7);
  BlockRead(Datei,Pal,768);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  DateiGroesse := FileSize(Datei) - FilePos(Datei);
  If (Use8000h = False) then
  Begin
    GetMem(gfxPuffer,DateiGroesse + 50);
    BlockRead(Datei,gfxPuffer^,DateiGroesse);
  End Else BlockRead(Datei,Mem[$8000 : 0000],DateiGroesse);
  PufferPos := 0; RamPos := 0;
  Repeat
    If (Use8000h = False) then
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
      End;
      Inc(RamPos,gfxPuffer^[Succ(PufferPos)]);
    End Else
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
      End;
      Inc(RamPos,Mem[$8000 : Succ(PufferPos)]);
    End;
    Inc(PufferPos,2);
  Until RamPos > 64050;
  If (Use8000h = False) then FreeMem(gfxPuffer,DateiGroesse + 50);
  Close(Datei);
End;

Procedure TVGA.ReadGFXOffile(DateiName : String; Position : longint; IntoMemory : Boolean);
Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  PufferPos : Integer;
  Pal : FarbPalette;
  Datei : File;
  FOXHdr : string;

Begin
  Assign(Datei,DateiName);
  Reset(Datei,1);
  seek(Datei,Position);
  BlockRead(Datei,FOXHdr,7);
  BlockRead(Datei,Pal,768);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  DateiGroesse := FileSize(Datei) - FilePos(Datei);
  If (Use8000h = False) then
  Begin
    GetMem(gfxPuffer,DateiGroesse + 50);
    BlockRead(Datei,gfxPuffer^,DateiGroesse);
  End Else BlockRead(Datei,Mem[$8000 : 0000],DateiGroesse);
  PufferPos := 0; RamPos := 0;
  Repeat
    If (Use8000h = False) then
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
      End;
      Inc(RamPos,gfxPuffer^[Succ(PufferPos)]);
    End Else
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
      End;
      Inc(RamPos,Mem[$8000 : Succ(PufferPos)]);
    End;
    Inc(PufferPos,2);
  Until RamPos > 64050;
  If (Use8000h = False) then FreeMem(gfxPuffer,DateiGroesse + 50);
  Close(Datei);
End;


Procedure TVGA.ReadSDT(SDTName : String; gfxName : String12; IntoMemory : Boolean);
Type
  THeader = Record
{              Signature : Array[1..3] of Char;}
              Eintraege : Byte;
              Namen     : Array[1..70] of String12;
              Groessen  : Array[1..70] of Word;
            End;

Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  SizeCounter : LongInt;
  PufferPos : Integer;
  FileCounter : Byte;
  Pal : FarbPalette;
  Sig : Array[1..20] of char;
  Header : THeader;
  i : integer;
  SDTFile : File;

Begin
  SizeCounter := SizeOf(THeader);
  FileCounter := 1;
  Assign(SDTFile,SDTName);
  Reset(SDTFile,1);
  BlockRead(SDTFile,sig,20);
  BlockRead(SDTFile,Header,SizeOf(THeader));
{  If (Header.Signature <> 'SDT Graphics Library') then}
  for i := 1 to Length(GFXName) do
  GFXName[i] := UpCase(GFXName[i]);
  If (Sig <> 'SDT Graphics Library') then
  Begin
    Close(SDTFile);
    Exit;
  End;
  While (Header.Namen[FileCounter] <> gfxName) or (FileCounter > Header.Eintraege) do
  Begin
    Inc(SizeCounter,Header.Groessen[FileCounter]);
    Inc(FileCounter);
  End;
  If (FileCounter > Header.Eintraege) then
  Begin
    Close(SDTFile);
    Exit;
  End;
  Seek(SDTFile,SizeCounter);
  BlockRead(SDTFile,Pal,768);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  DateiGroesse := Header.Groessen[FileCounter];
  If (Use8000h = False) then
  Begin
    GetMem(gfxPuffer,DateiGroesse + 50);
    BlockRead(SDTFile,gfxPuffer^,DateiGroesse);
  End Else BlockRead(SDTFile,Mem[$8000 : 0000],DateiGroesse);
  PufferPos := 0; RamPos := 0;
  Repeat
    If (Use8000h = False) then
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
      End;
      Inc(RamPos,gfxPuffer^[Succ(PufferPos)]);
    End Else
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
      End;
      Inc(RamPos,Mem[$8000 : Succ(PufferPos)]);
    End;
    Inc(PufferPos,2);
  Until RamPos > 64050;
  If (Use8000h = False) then FreeMem(gfxPuffer,DateiGroesse + 50);
  Close(SDTFile);
End;

Procedure TVGA.ReadGFXNr(DateiName : String; IntoMemory : Boolean; Nr : integer);
Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  PufferPos : Integer;
  Pal : FarbPalette;
  Datei : File;
  SPosition : longint;
  FI : Boolean;
  tc : char;
  sc, ic1 : integer;
  ic : longint;
  FOXHdr : string;

Begin
  Assign(Datei,DateiName);
  Reset(Datei,1);
  sc:=0;
  ic:=0;
  FI:=False;
  repeat
  FOXHdr:=' ';
  BlockRead(Datei, FoxHdr, 7, ic1);
  Seek(Datei,FilePos(Datei)-6);
   if FOXHdr='GFX.SDT' then
   begin;
      inc(sc);
      if sc=Nr then begin; FI:=True; SPosition:=FilePos(Datei)-1;
      end;
   end;
  until (eof(Datei)) or FI;
  if (eof(Datei)) and (not FI) then begin;
    Close(Datei);
    Done;
    asm;
      mov ax,3
      int 10h
    end;
    writeln('SDTGFX error: Couldn`t find bitmap');
    halt(1);
  end;
  Close(Datei);
  Assign(Datei,DateiName);
  Reset(Datei,1);
  Seek(Datei,SPosition);
  BlockRead(Datei,Pal,768);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  DateiGroesse := FileSize(Datei) - FilePos(Datei);
  If (Use8000h = False) then
  Begin
    GetMem(gfxPuffer,DateiGroesse + 50);
    BlockRead(Datei,gfxPuffer^,DateiGroesse);
  End Else BlockRead(Datei,Mem[$8000 : 0000],DateiGroesse);
  PufferPos := 0; RamPos := 0;
  Repeat
    If (Use8000h = False) then
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
      End;
      Inc(RamPos,gfxPuffer^[Succ(PufferPos)]);
    End Else
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
      End;
      Inc(RamPos,Mem[$8000 : Succ(PufferPos)]);
    End;
    Inc(PufferPos,2);
  Until RamPos > 64050;
  If (Use8000h = False) then FreeMem(gfxPuffer,DateiGroesse + 50);
  Close(Datei);
End;

Procedure TVGA.ReadMGP(MGPName : String; gfxName : String12; IntoMemory : Boolean);
Type
  THeader = Record
              Signature : Array[1..3] of Char;
              Eintraege : Byte;
              Namen     : Array[1..70] of String12;
              Groessen  : Array[1..70] of Word;
            End;

Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  SizeCounter : LongInt;
  PufferPos : Integer;
  FileCounter : Byte;
  Pal : FarbPalette;
  Header : THeader;
  MGPFile : File;

Begin
  SizeCounter := SizeOf(THeader);
  FileCounter := 1;
  Assign(MGPFile,MGPName);
  ReSet(MGPFile,1);
  BlockRead(MGPFile,Header,SizeOf(THeader));
  If (Header.Signature <> 'MGP') then
  Begin
    Close(MGPFile);
    Exit;
  End;
  While (Header.Namen[FileCounter] <> gfxName) or (FileCounter > Header.Eintraege) do
  Begin
    Inc(SizeCounter,Header.Groessen[FileCounter]);
    Inc(FileCounter);
  End;
  If (FileCounter > Header.Eintraege) then
  Begin
    Close(MGPFile);
    Exit;
  End;
  Seek(MGPFile,SizeCounter);
  BlockRead(MGPFile,Pal,768);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  DateiGroesse := Header.Groessen[FileCounter];
  If (Use8000h = False) then
  Begin
    GetMem(gfxPuffer,DateiGroesse + 50);
    BlockRead(MGPFile,gfxPuffer^,DateiGroesse);
  End Else BlockRead(MGPFile,Mem[$8000 : 0000],DateiGroesse);
  PufferPos := 0; RamPos := 0;
  Repeat
    If (Use8000h = False) then
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
      End;
      Inc(RamPos,gfxPuffer^[Succ(PufferPos)]);
    End Else
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
      End;
      Inc(RamPos,Mem[$8000 : Succ(PufferPos)]);
    End;
    Inc(PufferPos,2);
  Until RamPos > 64050;
  If (Use8000h = False) then FreeMem(gfxPuffer,DateiGroesse + 50);
  Close(MGPFile);
End;

Procedure TVGA.Hide; Assembler;
Asm
  Cli
  Mov DX,3DAh
  In AL,DX
  Mov DX,3BAh
  In AL,DX
  Mov DX,3C0h
  Xor AL,AL
  Out DX,AL
  Sti
End;

Procedure TVGA.Show; Assembler;
Asm
  Cli
  Mov DX,3DAh
  In AL,DX
  Mov DX,3BAh
  In AL,DX
  Mov DX,3C0h
  Mov AL,20h
  Out DX,AL
  Sti
End;

Procedure TVGA.FadeInAll(UnHide : Boolean);
Var
  PalCounter,PalCounter2 : Byte;
  Pal : FarbPalette;

Begin
  FillChar(Pal,768,0);
  WaitRetrace;
  SetPalette(Pal);
  If (UnHide = True) then Show;
  For PalCounter := 63 downto 1 do
  Begin
    For PalCounter2 := 0 to 255 do
    Begin
      If (ActivePal[PalCounter2].R - PalCounter >= 0) then Inc(Pal[PalCounter2].R);
      If (ActivePal[PalCounter2].G - PalCounter >= 0) then Inc(Pal[PalCounter2].G);
      If (ActivePal[PalCounter2].B - PalCounter >= 0) then Inc(Pal[PalCounter2].B);
    End;
    WaitRetrace;
    SetPalette(Pal);
  End;
End;

Procedure TVGA.FadeOutAll;
Var
  Counter,Counter2 : Byte;

Begin
  For Counter := 0 to 63 do
  Begin
    For Counter2 := 0 to 255 do
    Begin
      If (ActivePal[Counter2].R > 0) then Dec(ActivePal[Counter2].R);
      If (ActivePal[Counter2].G > 0) then Dec(ActivePal[Counter2].G);
      If (ActivePal[Counter2].B > 0) then Dec(ActivePal[Counter2].B);
    End;
    WaitRetrace;
    SetPalette(ActivePal);
  End;
End;

Procedure TVGA.MakePalBlack(Pal : FarbPalette);
begin;
FillChar(Pal,768,0);
end;

Procedure TVGA.CopyPal(Source, Target : FarbPalette);
begin;
move(Source, Target, 768);
end;

Procedure TVGA.Make_bw(WorkPal : FarbPalette);
Var i,sum:Word;                 {Wertung: 30% rot, 59% grn, 11% blau}
Begin
  For i:=0 to 255 do Begin
    Sum:=Round(WorkPal[i].R*0.3 + WorkPal[i].G*0.59 + WorkPal[i].B*0.11);
    WorkPal[i].R:=Sum; {Alle gleich => Palette wird S/W}
    WorkPal[i].G:=Sum;
    WorkPal[i].B:=Sum;
  End;
End;

Procedure TVGA.FadeTo(ZielPalette : FarbPalette);
Var
  Counter1,Counter2 : Byte;

Begin
  For Counter2 := 0 to 63 do
  Begin
    For Counter1 := 0 to 255 do
    Begin
      If (ActivePal[Counter1].R > ZielPalette[Counter1].R) then Dec(ActivePal[Counter1].R)
        Else If (ActivePal[Counter1].R < ZielPalette[Counter1].R) then Inc(ActivePal[Counter1].R);
      If (ActivePal[Counter1].G > ZielPalette[Counter1].G) then Dec(ActivePal[Counter1].G)
        Else If (ActivePal[Counter1].G < ZielPalette[Counter1].G) then Inc(ActivePal[Counter1].G);
      If (ActivePal[Counter1].B > ZielPalette[Counter1].B) then Dec(ActivePal[Counter1].B)
        Else If (ActivePal[Counter1].B < ZielPalette[Counter1].B) then Inc(ActivePal[Counter1].B);
    End;
    WaitRetrace;
    SetPalette(ActivePal);
  End;
End;

Procedure TVGA.FadeColorsOut(Anfang,Ende : Byte);
Var
  Counter,Counter2 : Byte;

Begin
  WaitRetrace;
  For Counter := 0 to 63 do
  Begin
    For Counter2 := Anfang to Ende do
    Begin
      If (ActivePal[Counter2].R > 0) then Dec(ActivePal[Counter2].R) Else ActivePal[Counter2].R := 0;
      If (ActivePal[Counter2].G > 0) then Dec(ActivePal[Counter2].G) Else ActivePal[Counter2].G := 0;
      If (ActivePal[Counter2].B > 0) then Dec(ActivePal[Counter2].B) Else ActivePal[Counter2].B := 0;
      SetColor(Counter2,ActivePal[Counter2].R,ActivePal[Counter2].G,ActivePal[Counter2].B);
    End;
    WaitRetrace;
  End;
End;

Procedure TVGA.FadeColorsIn(Anfang,Ende : Byte);
Var
  Counter,Counter2 : Byte;
  Pal : FarbPalette;

Begin
  FillChar(Pal[Anfang],(Ende - Anfang) * 3,0);
  WaitRetrace;
  SetPalette(Pal);
  Show;
  For Counter := 63 downto 1 do
  Begin
    For Counter2 := Anfang to Ende do
    Begin
      If (ActivePal[Counter2].R - Counter >= 0) then Inc(Pal[Counter2].R);
      If (ActivePal[Counter2].G - Counter >= 0) then Inc(Pal[Counter2].G);
      If (ActivePal[Counter2].B - Counter >= 0) then Inc(Pal[Counter2].B);
      SetColor(Counter2,Pal[Counter2].R,Pal[Counter2].G,Pal[Counter2].B);
    End;
    WaitRetrace;
  End;
End;

Procedure TVGA.Print(Text : String; X,Y : Integer; Farbe : Byte);
Var
  ZeichenPuffer,BytePuffer,Schleife2 : Byte;
  Schleife1 : Integer;

Begin
  For Schleife1 := 1 to Length(Text) do
  Begin
    ZeichenPuffer := Mem[Seg(Text) : Ofs(Text) + Schleife1];
    For Schleife2 := 0 to 7 do
    Begin
      BytePuffer := ZeichenSatz[ZeichenPuffer][Schleife2];
      Asm
        Mov AX,0A000h
        Mov ES,AX
        Mov AX,320
        Mul Y
        Add AX,X
        Mov DI,AX
        Mov AH,Farbe
        Mov BH,BytePuffer

        Mov AL,BH
        And AL,10000000b
        Or AL,AL
        Je @NoBit0
        Mov ES:[DI],AH
        @NoBit0:
        Inc DI

        Mov AL,BH
        And AL,01000000b
        Or AL,AL
        Je @NoBit1
        Mov ES:[DI],AH
        @NoBit1:
        Inc DI

        Mov AL,BH
        And AL,00100000b
        Or AL,AL
        Je @NoBit2
        Mov ES:[DI],AH
        @NoBit2:
        Inc DI

        Mov AL,BH
        And AL,00010000b
        Or AL,AL
        Je @NoBit3
        Mov ES:[DI],AH
        @NoBit3:
        Inc DI

        Mov AL,BH
        And AL,00001000b
        Or AL,AL
        Je @NoBit4
        Mov ES:[DI],AH
        @NoBit4:
        Inc DI

        Mov AL,BH
        And AL,00000100b
        Or AL,AL
        Je @NoBit5
        Mov ES:[DI],AH
        @NoBit5:
        Inc DI

        Mov AL,BH
        And AL,00000010b
        Or AL,AL
        Je @NoBit6
        Mov ES:[DI],AH
        @NoBit6:
        Inc DI

        Mov AL,BH
        And AL,00000001b
        Or AL,AL
        Je @NoBit7
        Mov ES:[DI],AH
        @NoBit7:
        Inc Integer Ptr Y
      End;
    End;
    Dec(Y,8);
    Inc(X,8);
  End;
End;

Procedure TVGA.PrintMem(Text : String; X,Y : Integer; Farbe : Byte);
Var
  ZeichenPuffer,BytePuffer,Schleife2 : Byte;
  Schleife1 : Integer;

Begin
  For Schleife1 := 1 to Length(Text) do
  Begin
    ZeichenPuffer := Mem[Seg(Text) : Ofs(Text) + Schleife1];
    For Schleife2 := 0 to 7 do
    Begin
      BytePuffer := ZeichenSatz[ZeichenPuffer][Schleife2];
      Asm
        Mov ES,Word(ZweiteSeite + 2)
        Mov AX,320
        Mul Y
        Add AX,X
        Mov DI,AX
        Mov AH,Farbe
        Mov BH,BytePuffer

        Mov AL,BH
        And AL,10000000b
        Or AL,AL
        Je @NoBit0
        Mov ES:[DI],AH
        @NoBit0:
        Inc DI

        Mov AL,BH
        And AL,01000000b
        Or AL,AL
        Je @NoBit1
        Mov ES:[DI],AH
        @NoBit1:
        Inc DI

        Mov AL,BH
        And AL,00100000b
        Or AL,AL
        Je @NoBit2
        Mov ES:[DI],AH
        @NoBit2:
        Inc DI

        Mov AL,BH
        And AL,00010000b
        Or AL,AL
        Je @NoBit3
        Mov ES:[DI],AH
        @NoBit3:
        Inc DI

        Mov AL,BH
        And AL,00001000b
        Or AL,AL
        Je @NoBit4
        Mov ES:[DI],AH
        @NoBit4:
        Inc DI

        Mov AL,BH
        And AL,00000100b
        Or AL,AL
        Je @NoBit5
        Mov ES:[DI],AH
        @NoBit5:
        Inc DI

        Mov AL,BH
        And AL,00000010b
        Or AL,AL
        Je @NoBit6
        Mov ES:[DI],AH
        @NoBit6:
        Inc DI

        Mov AL,BH
        And AL,00000001b
        Or AL,AL
        Je @NoBit7
        Mov ES:[DI],AH
        @NoBit7:
        Inc Integer Ptr Y
      End;
    End;
    Dec(Y,8);
    Inc(X,8);
  End;
End;

Procedure TVGA.Wait(MSek : Integer);
Var
  Counter : Integer;

Begin
  For Counter := 1 to MSek do
  Asm
    Hlt
  End;
End;

Procedure TVGA.RetraceWait(MSek : Integer); Assembler;
Asm
  Xor CX,CX
  @Loop1:
  Mov DX,3DAh
  @Jump1:
  In AL,DX
  Test AL,8D
  Jz @Jump1
  @Jump2:
  In AL,DX
  Test AL,8D
  Jnz @Jump2
  Inc CX
  Cmp CX,MSek
  Jne @Loop1
End;

Procedure TVGA.Line(VonX,VonY,BisX,BisY : Integer; Farbe : Byte);
Var
  D,Dx,Dy,AIncr,BIncr,XIncr,YIncr,X,Y : Integer;

  Procedure SwapInt(Var Integer1,Integer2 : Integer);
  Var
    Zahl : Integer;

  Begin
    Zahl := Integer2;
    Integer2 := Integer1;
    Integer1 := Zahl;
  End;

Begin
  If (Abs(BisX - VonX) < Abs(BisY - VonY)) then
  Begin
    If (VonY > BisY) then
    Begin
      SwapInt(VonX,BisX);
      SwapInt(VonY,BisY);
    End;
    If (BisX > VonX) then XIncr := 1
      Else XIncr := - 1;
    Dy := BisY - VonY;
    Dx := Abs(BisX - VonX);
    D := 2 * Dx - Dy;
    AIncr := 2 * (Dx - Dy);
    BIncr := 2 * Dx;
    X := VonX; Y := VonY;
    Mem[$A000 + Y * 20 : X] := Farbe;
    For Y := Succ(VonY) to BisY do
    Begin
      If (D >= 0) then
      Begin
        Inc(X,XIncr);
        Inc(D,AIncr);
      End
      Else Inc(D,BIncr);
      Mem[$A000 + Y * 20 : X] := Farbe;
    End;
  End
  Else
  Begin
    If (VonX > BisX) then
    Begin
      SwapInt(VonX,BisX);
      SwapInt(VonY,BisY);
    End;
    If (BisY > VonY) then YIncr := 1
      Else YIncr := - 1;
    Dx := BisX - VonX;
    Dy := Abs(BisY - VonY);
    D := 2 * Dy - Dx;
    AIncr := 2 * (Dy - Dx);
    BIncr := 2 * Dy;
    X := VonX; Y := VonY;
    Mem[$A000 + Y * 20 : X] := Farbe;
    For X := Succ(VonX) to BisX do
    Begin
      If (D >= 0) then
      Begin
        Inc(Y,YIncr);
        Inc(D,AIncr);
      End
      Else Inc(D,BIncr);
      Mem[$A000 + Y * 20 : X] := Farbe;
    End;
  End;
End;

Procedure TVGA.MemLine(VonX,VonY,BisX,BisY : Integer; Farbe : Byte);
Var
  D,Dx,Dy,AIncr,BIncr,XIncr,YIncr,X,Y : Integer;

  Procedure SwapInt(Var Integer1,Integer2 : Integer);
  Var
    Zahl : Integer;

  Begin
    Zahl := Integer2;
    Integer2 := Integer1;
    Integer1 := Zahl;
  End;

Begin
  If (Abs(BisX - VonX) < Abs(BisY - VonY)) then
  Begin
    If (VonY > BisY) then
    Begin
      SwapInt(VonX,BisX);
      SwapInt(VonY,BisY);
    End;
    If (BisX > VonX) then XIncr := 1
      Else XIncr := - 1;
    Dy := BisY - VonY;
    Dx := Abs(BisX - VonX);
    D := 2 * Dx - Dy;
    AIncr := 2 * (Dx - Dy);
    BIncr := 2 * Dx;
    X := VonX;
    Y := VonY;
    ZweiteSeite^[Y * 320 + X] := Farbe;
    For Y := VonY + 1 to BisY do
    Begin
      If (D >= 0) then
      Begin
        Inc(X,XIncr);
        Inc(D,AIncr);
      End
      Else Inc(D,BIncr);
      ZweiteSeite^[Y * 320 + X] := Farbe;
    End;
  End
  Else
  Begin
    If (VonX > BisX) then
    Begin
      SwapInt(VonX,BisX);
      SwapInt(VonY,BisY);
    End;
    If (BisY > VonY) then YIncr := 1
      Else YIncr := - 1;
    Dx := BisX - VonX;
    Dy := Abs(BisY - VonY);
    D := 2 * Dy - Dx;
    AIncr := 2 * (Dy - Dx);
    BIncr := 2 * Dy;
    X := VonX;
    Y := VonY;
    ZweiteSeite^[Y * 320 + X] := Farbe;
    For X := VonX + 1 to BisX do
    Begin
      If (D >= 0) then
      Begin
        Inc(Y,YIncr);
        Inc(D,AIncr);
      End
      Else Inc(D,BIncr);
      ZweiteSeite^[Y * 320 + X] := Farbe;
    End;
  End;
End;

Procedure TVGA.Box(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte; FillBox : Boolean);
Begin
  Line(LObenX,LObenY,RUntenX,LObenY,Farbe);
  Line(LObenX,LObenY,LObenX,RUntenY,Farbe);
  Line(RUntenX,RUntenY,RUntenX,LObenY,Farbe);
  Line(RUntenX,RUntenY,LObenX,RUntenY,Farbe);
  If (FillBox = True) then Fill(Succ(LObenX),Succ(LObenY),RUntenX,Pred(RUntenY),Farbe);
End;

Procedure TVGA.MemBox(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte; FillBox : Boolean);
Begin
  MemLine(LObenX,LObenY,RUntenX,LObenY,Farbe);
  MemLine(LObenX,LObenY,LObenX,RUntenY,Farbe);
  MemLine(RUntenX,RUntenY,RUntenX,LObenY,Farbe);
  MemLine(RUntenX,RUntenY,LObenX,RUntenY,Farbe);
  If (FillBox = True) then FillMem(Succ(LObenX),Succ(LObenY),RUntenX,Pred(RUntenY),Farbe);
End;

Procedure TVGA.Fill(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte);
Var
  FillCounter,FillWidth : Integer;

Begin
  FillWidth := RUntenX - LObenX;
  For FillCounter := LObenY to RUntenY do
  FillChar(Mem[$A000 + FillCounter * 20 : LObenX],FillWidth,Farbe);
End;

Procedure TVGA.FillMem(LObenX,LObenY,RUntenX,RUntenY : Integer; Farbe : Byte);
Var
  FillCounter,FillWidth : Integer;

Begin
  FillWidth := RUntenX - LObenX;
  For FillCounter := LObenY to RUntenY do
    FillChar(ZweiteSeite^[FillCounter * 320 + LObenX],FillWidth,Farbe);
End;

Procedure TVGA.ShowMemPage; Assembler;
Asm
  Push DS
  LDS SI,ZweiteSeite
  Mov AX,0A000h
  Mov ES,AX
  Xor DI,DI
  Mov CX,16000
  Db 66h
  Rep MovsW
  Pop DS
End;

Procedure TVGA.CopyPage(target, source : VideoPointer);
Begin;
{Mem[Seg(ZweiteSeite^) + Y * 20 : X] := Mem[Seg(ZweiteSeite^) + Y * 20 : X];}
End;

Procedure TVGA.ShowMem(VideoPage : VideoPointer; Zeile,Anzahl,NeueZeile : Word); Assembler;
Asm
  Push DS
  Mov DS,Word(VideoPage + 2)
  Mov AX,320
  Mul Zeile
  Mov SI,AX
  Mov AX,0A000h
  Mov ES,AX
  Mov AX,320
  Mul NeueZeile
  Mov DI,AX
  Mov CX,Anzahl
  Db 66h
  Rep MovsW
  Pop DS
End;

Procedure TVGA.ShowPage(VideoPage : VideoPointer); Assembler;
Asm
  Push DS
  LDS SI,VideoPage
  Mov AX,0A000h
  Mov ES,AX
  Xor DI,DI
  Mov CX,16000
  Db 66h
  Rep MovsW
  Pop DS
End;

Procedure TVGA.WaitRetrace; Assembler;
Asm
  Mov AH,08h
  Mov DX,3DAh
  @Jump1:
  In AL,DX
  And AL,AH
  Jnz @Jump1
  @Jump2:
  In AL,DX
  And AL,AH
  Jz @Jump2
End;

Procedure TVGA.WaitDisplay; Assembler;
Asm
  Mov AH,8d
  Mov DX,3DAh
  @Jump1:
  In AL,DX
  And AL,AH
  Jz @Jump1
  @Jump2:
  In AL,DX
  And AL,AH
  Jnz @Jump2
End;

Procedure TVGA.LoadFont(DateiName : String);
Var
   Datei : File Of Zeichen_Satz;
Begin
  Assign(Datei,DateiName);
  Reset(Datei);
  Read(Datei,ZeichenSatz);
  Close(Datei);
End;

Procedure TVGA.SetPixel(X,Y : Integer; Farbe : Byte);
Begin
  Mem[$A000 + Y * 20 : X] := Farbe;
End;

Function TVGA.GetPixel(X,Y : Integer) : Byte;
Begin
  GetPixel := Mem[$A000 + Y * 20 : X];
End;

Procedure TVGA.Savegfx(DateiName : String);
Var
  AlteFarbe,Anzahl,Farbe : Byte;
  PixelCounter : Word;
  Pal : FarbPALETTE;
  Ziel : File;
  FOXHdr : string;

Begin
  FOXHdr:='GFX.SDT';
  Assign(Ziel,DateiName);
  ReWrite(Ziel,1);
  GetPalette(0,255,Pal);
  BlockWrite(Ziel,FOXHdr,7);
  BlockWrite(Ziel,Pal,SizeOf(Pal));
  Farbe := Mem[$A000 : 0000];
  AlteFarbe := Farbe;
  Anzahl := 0;
  For PixelCounter := 0 to 64000 do
  Begin
    Farbe := Mem[$A000 : PixelCounter];
    If (AlteFarbe = Farbe) then Inc(Anzahl)
    Else
    Begin
      BlockWrite(Ziel,AlteFarbe,1);
      BlockWrite(Ziel,Anzahl,1);
      AlteFarbe := Farbe;
      Anzahl := 1;
    End;
    If (Anzahl = 255) then
    Begin
      BlockWrite(Ziel,AlteFarbe,1);
      BlockWrite(Ziel,Anzahl,1);
      Anzahl := 0;
    End;
  End;
  Close(Ziel);
End;

Procedure TVGA.SaveRaw(PalDatName : String; PicDatName : String);
Var
  AlteFarbe,Anzahl,Farbe : Byte;
  PixelCounter : Word;
  Pal : FarbPALETTE;
  Ziel : File;
  x : pointer;

Begin
  Assign(Ziel,PalDatName);
  ReWrite(Ziel,1);
  GetPalette(0,255,Pal);
  BlockWrite(Ziel,Pal,SizeOf(Pal));
  Close(Ziel);
  Assign(Ziel,PicDatName);
  ReWrite(Ziel,1);
  For PixelCounter := 0 to 63999 do
  Begin
    Farbe := Mem[$A000 : PixelCounter];
    BlockWrite(Ziel,Farbe,1);
  End;
  Close(Ziel);
End;

procedure TVGA.SetPal1(s,nr:Integer; var p);
  ASSEMBLER;
  asm
    mov BX,s
    mov CX,nr
    mov AH,10h
    mov AL,12h
    les DX,p
    int 10h
  end;
procedure TVGA.GetPal1(s,nr:Integer; var p);
  ASSEMBLER;
  asm
    mov BX,s
    mov CX,nr
    mov AH,10h
    mov AL,17h
    les DX,p
    int 10h
  end;

Procedure TVGA.ReadPcx(f : String; x,y : Word; IntoMem : Boolean; Skip : Byte);
  var q : file;
      Ohne_Farbe : Byte;
      b : Array[0..2047] OF BYTE;
      anz,pos,c,w,h,e,pack: Word;
  begin
    Assign(q,f); Reset(q,1);
    BlockRead(q,b,128,anz);
    if (b[0]<>10) OR (b[3]<>8) then
       begin Close(q); Exit end;
    w:=succ((b[9]-b[5])*256+b[8]-b[4]);
    h:=succ((b[11]-b[7])*256+b[10]-b[6]);
    pack:=0; c:=0; e:=y+h;
    repeat
      BlockRead(q,b,2048,anz);
      pos:=0;
      while (pos<anz) AND (y<e) do begin
        if pack<>0
           then begin
             for c:=c to c+pack do
              If (Ohne_Farbe-1<>b[pos]) OR (Ohne_Farbe=0) then
               if IntoMem then
               begin
               vga.SetMemoryPixel(x+c,y,b[pos]);
               end
               else
               begin
               vga.SetPixel(x+c,y,b[pos]);
               end;
             pack:=0; end
           else if (b[pos] AND $C0)=$C0
             then pack:=b[pos] AND $3F
             else begin
               If (Ohne_Farbe-1<>b[pos]) OR (Ohne_Farbe=0) then
               if IntoMem then
               begin
               vga.SetMemoryPixel(x+c,y,b[pos]);
               end
               else
               begin
               vga.SetPixel(x+c,y,b[pos]);
               end;
               Inc(c) end;
           Inc(pos);
           if c=w then
              begin c:=0; Inc(y) end;
        end;
    until (anz=0) or (y=e);
    Seek(q,FileSize(q)-3*256-1);
    BlockRead(q,b,3*256+1);
    if b[0]=12 then begin
       for x:=1 to 3*256+1 do
         b[x]:=b[x] SHR 2;
     SetPal1(0,256,b[1]);
    end;
    close(q);
  vga.GetPalette(0,255,ActivePal);
  end;

Procedure TVGA.Zoom(LObenX,LObenY,Breite,Hoehe,NeueX,NeueY,NeueBreite,NeueHoehe : Integer);
Var
  FaktorX,FaktorY,RestX,RestY,Dummy,Zaehler1,Zaehler2 : word;
  StartSpalte,StartReihe : word;
  Schleife1,Schleife2 : word;

Begin
  FaktorX := Breite div NeueBreite;
  RestX := Breite mod NeueBreite;
  FaktorY := Hoehe div NeueHoehe;
  RestY := Hoehe mod NeueHoehe;
  StartSpalte := LObenX + FaktorX;
  StartReihe := LObenY + FaktorY;
  For Schleife2 := 0 to NeueHoehe do
  Begin
    Inc(Zaehler2);
    If (Schleife2 = 0) then Zaehler2 := 0;
    For Schleife1 := 0 to NeueBreite do
    Begin
      Inc(Zaehler1);
      If (Schleife1 = 0) then Zaehler1 := 0;
      SetPixel(NeueX + Schleife1,NeueY + Schleife2,GetPixel(StartSpalte + Zaehler1 * FaktorX + Zaehler1 *
         RestX div NeueBreite,StartReihe + Zaehler2 * FaktorX + Zaehler2 * RestY div NeueHoehe));
    End;
  End;
End;

Procedure TVGA.MemZoom(LObenX,LObenY,Breite,Hoehe,NeueX,NeueY,NeueBreite,NeueHoehe : Integer);
Var
  FaktorX,FaktorY,RestX,RestY,Dummy,Zaehler1,Zaehler2 : longint;
  StartSpalte,StartReihe : longint;
  Schleife1,Schleife2 : longInt;

Begin
  FaktorX := Breite div NeueBreite;
  RestX := Breite mod NeueBreite;
  FaktorY := Hoehe div NeueHoehe;
  RestY := Hoehe mod NeueHoehe;
  StartSpalte := LObenX + FaktorX;
  StartReihe := LObenY + FaktorY;
  For Schleife2 := 0 to NeueHoehe do
  Begin
    Inc(Zaehler2);
    If (Schleife2 = 0) then Zaehler2 := 0;
    For Schleife1 := 0 to NeueBreite do
    Begin
      Inc(Zaehler1);
      If (Schleife1 = 0) then Zaehler1 := 0;
      SetPixel(NeueX + Schleife1,NeueY + Schleife2,GetMemoryPixel(StartSpalte + Zaehler1 * FaktorX + Zaehler1 *
         RestX div NeueBreite,StartReihe + Zaehler2 * FaktorX + Zaehler2 * RestY div NeueHoehe));
    End;
  End;
End;

procedure TVGA.Rotiere(AXPos, AYPos, EXPos, EYPos, Direction: Word);
var Schleife001,Schleife002 : Integer;
    PixelPuffer : Array[0..319] of Byte;
begin
 AXPos:=AXPos+1;
 case Direction of
  1: begin     { Rotiere links }
      for Schleife001:=AYPos to EYPos do
       PixelPuffer[Schleife001-AYPos]:=GetPixel(AXPos,Schleife001);
       CopyAll(AXPos+1,AYPos,EXPos-AXPos-1,EYPos-AYPos,AXPos,AYPos,TRUE);
      for Schleife001:=AYPos to EYPos do
       SetPixel(EXPos,Schleife001,PixelPuffer[Schleife001-AYPos]);
     end;
  2: begin     { Rotiere links }
     end;
  3: begin     { Rotiere links }
     end;
  4: begin     { Rotiere links }
     end;
 end;
end;

procedure TVGA.CopyAll(AXPos,AYPos,Laenge1,Breite1,EXPos,EYPos:Word;Delet:Boolean);
var Schleife001,Schleife002 : Integer;
    Dummy : Byte;
begin
 for Schleife001:=0 to Laenge1 do
  for Schleife002:=0 to Breite1 do
  begin
   Dummy:=GetPixel(AXPos+Schleife001,AYPos+Schleife002);
   if Delet then
    SetPixel(EXPos+Schleife001,EYPos+Schleife002,Dummy)
   else
     if Dummy<>0 then SetPixel(EXPos+Schleife001,EYPos+Schleife002,Dummy);
  end;
end;

Procedure TVGA.MakeGray; Assembler;
Asm
  Mov AH,12h
  Mov BL,33h
  Mov AL,0
  Int 10h
End;

Procedure TVGA.MakeColored; Assembler;
Asm
  Mov AH,12h
  Mov BL,33h
  Mov AL,1
  Int 10h
End;

Destructor TVGA.Done;
Begin
  ClearScreen;
  FillChar(ZweiteSeite^,64050,0);
  FreeMem(ZweiteSeite,64050);
  FreeMem(DritteSeite,64050);
  Asm
    Mov AX,03h
    PushF
    Call OldInt10h
  End;
End;

Procedure TVGA.ZeichenSatz_Laden;
Begin
  Move(Ptr($FFA6,$E)^,ZeichenSatz,128 * 8);
  Move(Ptr(MemW[$0:$7E],MemW[$0:$7C])^,Ptr(Seg(ZeichenSatz),Ofs(ZeichenSatz) + 128 * 8)^,128*8);
End;

Procedure TVGA.FadePrint(Text : String; X,Y : Integer; Zeit : LongInt);
Var
  FadeCounter : Byte;

Begin
  For FadeCounter := 30 downto 16 do
  Begin
    Print(Text,X,Y,FadeCounter);
    Wait(1);
  End;
  Wait(Zeit);
  For FadeCounter := 16 to 30 do
  Begin
    Print(Text,X,Y,FadeCounter);
    Wait(1);
  End;
End;

Procedure TVGA.FadeInPrint(Text : String; X,Y : Integer; Zeit : LongInt);
Var
  FadeCounter : Byte;

Begin
  For FadeCounter := 30 downto 16 do
  Begin
    Print(Text,X,Y,FadeCounter);
    Wait(Zeit);
  End;
End;

Procedure TVGA.FadeOutPrint(Text : String; X,Y : Integer; Zeit : LongInt);
Var
  FadeCounter : Byte;

Begin
  For FadeCounter := 16 to 30 do
  Begin
    Print(Text,X,Y,FadeCounter);
    Wait(Zeit);
  End;
End;

Procedure TVGA.ClearMemoryScreen;
Begin
  FillChar(ZweiteSeite^,64000,0);
End;

Procedure TVGA.SetMemoryPixel(X,Y : Integer; Farbe : Byte);
Begin
  Mem[Seg(ZweiteSeite^) + Y * 20 : X] := Farbe;
End;

Function TVGA.GetMemoryPixel(X,Y : Integer) : Byte;
Begin
  GetMemoryPixel := Mem[Seg(ZweiteSeite^) + Y * 20 : X];
End;






Constructor TSPRITE.Init(Breite,Hoehe : Byte);
Begin
  Width := Breite;
  Height := Hoehe;
  Groesse := (Width * Height) + 10;
  GetMem(Sprite,Groesse);
  FillChar(Sprite^,Groesse,0);
End;

Procedure TSPRITE.GrabSprite(X,Y : Integer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    FastMove(Mem[$A000 + CounterY * 20 : X],Sprite^[(CounterY - Y) * Succ(Width)],Width shr 2);
End;

Procedure TSPRITE.DropSprite(X,Y : Integer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    FastMove(Sprite^[(CounterY - Y) * Succ(Width)],Mem[$A000 + CounterY * 20 : X],Width shr 2);
End;

Procedure TSPRITE.ToggleSprite(X,Y : Integer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    if FNT then
    begin
    CompMove(Sprite^[(CounterY - Y) * Succ(Width)],ZweiteSeite^[CounterY * 320 + X],Width);
    end
    else
    begin
    CompMove(Sprite^[(CounterY - Y) * Succ(Width)],Mem[$A000 + CounterY * 20 : X],Width);
    end;
End;

Procedure TSPRITE.GrabSpriteFromMemory(X,Y : Integer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    FastMove(ZweiteSeite^[CounterY * 320 + X],Sprite^[(CounterY - Y) * Succ(Width)],Width shr 2);
End;

Procedure TSPRITE.DropSpriteIntoMemory(X,Y : Integer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    FastMove(Sprite^[(CounterY - Y) * Succ(Width)],ZweiteSeite^[CounterY * 320 + X],Width shr 2);
End;

Procedure TSPRITE.ToggleSpriteIntoMemory(X,Y : Integer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    CompMove(Sprite^[(CounterY - Y) * Succ(Width)],ZweiteSeite^[CounterY * 320 + X],Width);
End;

Procedure TSPRITE.GrabSpriteFromPage(X,Y : Integer; Page : VideoPointer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    FastMove(Page^[CounterY * 320 + X],Sprite^[(CounterY - Y) * Succ(Width)],Width shr 2);
End;

Procedure TSPRITE.DropSpriteIntoPage(X,Y : Integer; Page : VideoPointer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    FastMove(Sprite^[(CounterY - Y) * Succ(Width)],Page^[CounterY * 320 + X],Width shr 2);
End;

Procedure TSPRITE.ToggleSpriteIntoPage(X,Y : Integer; Page : VideoPointer);
Var
  CounterY : Byte;

Begin
  For CounterY := Y to Y + Pred(Height) do
    CompMove(Sprite^[(CounterY - Y) * Succ(Width)],Page^[CounterY * 320 + X],Width);
End;

Procedure TSPRITE.SaveSprite(DateiName : String);
Var
  Datei : File;

Begin
  Assign(Datei,DateiName);
  ReWrite(Datei,1);
  BlockWrite(Datei,Width,1);
  BlockWrite(Datei,Height,1);
  BlockWrite(Datei,Sprite^,Groesse);
  Close(Datei);
End;

Procedure TSPRITE.LoadSprite(DateiName : String);
Var
  Breite,Hoehe : Byte;
  Datei : File;

Begin
  Assign(Datei,DateiName);
  ReSet(Datei,1);
  BlockRead(Datei,Breite,1);
  BlockRead(Datei,Hoehe,1);
  If (Breite <> Width) or (Hoehe <> Height) then
  Begin
    FreeMem(Sprite,Groesse);
    Width := Breite;
    Height := Hoehe;
    Groesse := (Width * Height) + 10;
    GetMem(Sprite,Groesse);
    BlockRead(Datei,Sprite^,Groesse);
  End
  Else BlockRead(Datei,Sprite^,Groesse);
  Close(Datei);
End;

Destructor TSPRITE.Done;
Begin
  FillChar(Sprite^,Groesse,0);
  FreeMem(Sprite,Groesse);
End;

Procedure TVGA.SavePGP(DateiName : String);
Var
  AlteFarbe,Anzahl,Farbe : Byte;
  PixelCounter : Word;
  Pal : FarbPALETTE;
  Ziel : File;

Begin
  Assign(Ziel,DateiName);
  ReWrite(Ziel,1);
  GetPalette(0,255,Pal);
  BlockWrite(Ziel,Pal,SizeOf(Pal));
  Farbe := Mem[$A000 : 0000];
  AlteFarbe := Farbe;
  Anzahl := 0;
  For PixelCounter := 0 to 64000 do
  Begin
    Farbe := Mem[$A000 : PixelCounter];
    If (AlteFarbe = Farbe) then Inc(Anzahl)
    Else
    Begin
      BlockWrite(Ziel,AlteFarbe,1);
      BlockWrite(Ziel,Anzahl,1);
      AlteFarbe := Farbe;
      Anzahl := 1;
    End;
    If (Anzahl = 255) then
    Begin
      BlockWrite(Ziel,AlteFarbe,1);
      BlockWrite(Ziel,Anzahl,1);
      Anzahl := 0;
    End;
  End;
  Close(Ziel);
End;

Procedure TVGA.ReadPGP(DateiName : String; IntoMemory : Boolean);
Var
  DateiGroesse,RamPos : Word;
  gfxPuffer : DateiZeiger;
  PufferPos : Integer;
  Pal : FarbPalette;
  Datei : File;

Begin
  Assign(Datei,DateiName);
  Reset(Datei,1);
  BlockRead(Datei,Pal,768);
  SetPalette(Pal);
  Move(Pal,ActivePal,768);
  DateiGroesse := FileSize(Datei) - FilePos(Datei);
  If (Use8000h = False) then
  Begin
    GetMem(gfxPuffer,DateiGroesse + 50);
    BlockRead(Datei,gfxPuffer^,DateiGroesse);
  End Else BlockRead(Datei,Mem[$8000 : 0000],DateiGroesse);
  PufferPos := 0; RamPos := 0;
  Repeat
    If (Use8000h = False) then
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],gfxPuffer^[Succ(PufferPos)],gfxPuffer^[PufferPos]);
      End;
      Inc(RamPos,gfxPuffer^[Succ(PufferPos)]);
    End Else
    Begin
      Case IntoMemory of
        True : FillChar(ZweiteSeite^[RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
        False : FillChar(Mem[$A000 : RamPos],Mem[$8000 : Succ(PufferPos)],Mem[$8000 : PufferPos]);
      End;
      Inc(RamPos,Mem[$8000 : Succ(PufferPos)]);
    End;
    Inc(PufferPos,2);
  Until RamPos > 64050;
  If (Use8000h = False) then FreeMem(gfxPuffer,DateiGroesse + 50);
  Close(Datei);
End;


Procedure TVGA.PlayFLI(DatNam : string; Anzahl : integer; SlowDown : Integer; StopFli : Boolean;
                       Frame : integer; Time : Integer);
var  VideoRam : Array[0..64050] of Byte Absolute $A000 : $0000;
     BildBreite,BildHoehe,DeltaX,DeltaY : LongInt;
     OrigPalette,NewPalette : FarbPalette;
     Index,Schleife,Gelesen,SSt : Word;
     FrameHeader : TFrameHeader;
     FliHeader : TFliHeader;
     DateiName : String;
     Cache : ^TCache;
     Chunk : TChunk;
     Datei : File;
     Taste : Char;


Procedure SetPalette1(Var PalPuffer); Assembler;
Asm
  Mov BX,0
  Mov CX,256
  Mov AH,10h
  Mov AL,12h
  Les DX,PalPuffer
  Int 10h
End;

Procedure GetPalette1(Var PalPuffer); Assembler;
Asm
  Mov AH,10h
  Mov AL,17h
  Mov BX,0
  Mov CX,256
  Les DX,PalPuffer
  Int 10h
End;

Procedure WaitRetrace1; Assembler;
Asm
  Mov DX,3DAh
  @Jump1:
  In AL,DX
  Test AL,8D
  Jnz @Jump1
  @Jump2:
  In AL,DX
  Test AL,8D
  Jz @Jump2
End;

Procedure InitMode13h;
Begin
  GetPalette1(OrigPalette);
  Asm
    Mov AX,0013h
    Int 10h
  End;
  SetPalette1(NewPalette);
End;

Procedure DoneMode13h;
Begin
  SetPalette1(OrigPalette);
  Asm
    Mov Ax,0003h
    Int 10h
  End;
End;

Function UpString(Text : String) : String;
Var
  Counter : Byte;

Begin
  For Counter := 1 to Length(Text) do
  Case Text[Counter] of
    '' : Text[Counter] := '';
    '' : Text[Counter] := '';
    '' : Text[Counter] := '';
    '' : Text[Counter] := '';
    Else Text[Counter] := UpCase(Text[Counter]);
  End;
  UpString := Text;
End;

Function Ceil(RealZahl : Real) : Integer;
Var
  Dummy : Integer;

Begin
  Dummy := Trunc(RealZahl);
  If (Frac(RealZahl) > 0) then Inc(Dummy);
  Ceil := Dummy;
End;

Function ReadByte : Byte;
Var
  Dummy : Word;

Begin
  If (Index > SizeOf(Cache^)) then
  Begin
    BlockRead(Datei,Cache^,SizeOf(Cache^),Dummy);
    Index := 1;
  End;
  ReadByte := Cache^[Index];
  Inc(Index);
End;

Procedure ReadPalette;
Var
  F,FNeu,W,P,Pakete : Word;
  FIndex,FStart : Byte;

Begin
  W := 0; FIndex := 0;
  BlockRead(Datei,Pakete,2);
  For P := 1 to Pakete do
  Begin
    FNeu := 0;
    BlockRead(Datei,FStart,1);
    BlockRead(Datei,FNeu,1);
    Inc(FIndex,FStart);
    If (FNeu = 0) then
    Begin
      FIndex := 0;
      FNeu := 256;
    End;
    For F := 1 to FNeu do
    Begin
      BlockRead(Datei,NewPalette[FIndex],3);
      Inc(FIndex); Inc(W);
    End;
  End;
  SetPalette1(NewPalette);
  If (Odd(W) = True) then BlockRead(Datei,F,1);
End;

Procedure RLEDecodieren;
Begin
  If (Chunk.Size - 6 > SizeOf(Cache^)) then
  Begin
    DoneMode13h;
    WriteLn('Der Cache ist zu klein !');
    Halt;
  End;
  BlockRead(Datei,Cache^,Chunk.Size - 6);
  Asm
    Cld
    Push DS
    LDS SI,Cache
    Mov AX,0A000h
    Mov ES,AX
    Xor BX,BX
    @Start1:
    LodsB
    Xor DH,DH
    Mov DL,AL
    Cmp AL,00
    Je @Ende1
    Mov AX,320
    Push DX
    Mul BX
    Pop DX
    Mov DI,AX
    Xor AH,AH
    @Start2:
    LodsB
    Cmp AX,128
    Jl @Fuellen
    Not AL
    Inc AX
    Mov CX,AX
    Rep MovsB
    Jmp @Ende2
    @Fuellen:
    Mov CX,AX
    LodsB
    Rep StosB
    @Ende2:
    Dec DX
    Cmp DX,00
    Jg @Start2
    @Ende1:
    Inc BX
    Cmp BX,200
    Jl @Start1
    Pop DS
    Inc SI
    Mov Index,SI
  End;
  If (Index < Chunk.Size - 5) then
    Seek(Datei,FilePos(Datei) - (Chunk.Size - 5 - Index));
End;

Procedure ZeilenDecodieren;
Var
  ZStart,ZNeu,ZEnde : Word;

Begin
  If (Chunk.Size - 6 > SizeOf(Cache^)) then
  Begin
    DoneMode13h;
    Halt;
  End;
  BlockRead(Datei,Cache^,Chunk.Size - 6);
  ZStart := Cache^[2] Shl 8 + Cache^[1];
  ZNeu := Cache^[4] Shl 8 + Cache^[3];
  ZEnde := Pred(ZStart + ZNeu);
  Asm
    Cld
    Push DS
    LDS SI,Cache
    Add SI,4
    Mov AX,0A000h
    Mov ES,AX
    Mov BX,ZStart
    @Start1:
    LodsB
    Xor DH,DH
    Mov DL,AL
    Cmp AL,0
    Je @Ende1
    Mov AX,320
    Push DX
    Mul BX
    Pop DX
    Mov DI,AX
    Xor AH,AH
    @Start2:
    LodsB
    Add DI,AX
    LodsB
    Cmp AX,128
    Jl @Fuellen
    Not AL
    Inc AX
    Mov CX,AX
    LodsB
    Rep StosB
    Jmp @Ende2
    @Fuellen:
    Mov CX,AX
    Rep MovsB
    @Ende2:
    Dec DX
    Cmp DX,0
    Jg @Start2
    @Ende1:
    Inc BX
    Cmp BX,ZEnde
    Jle @Start1
    Pop DS
  End;
End;

Procedure PlayMovie(Time: Byte; Frame: Integer);
Var
  FilePosAlt : LongInt;
  F,C : Word;
  B : Byte;

Begin
  For F := 1 to FliHeader.Frames do
  Begin
    If (FilePos(Datei) < FilePosAlt + FrameHeader.Size) and (F > 1) then Seek(Datei,FilePosAlt + FrameHeader.Size);
    FilePosAlt := FilePos(Datei);
    BlockRead(Datei,FrameHeader,SizeOf(FrameHeader));
    For C := 1 to FrameHeader.Chunks do
    Begin
      BlockRead(Datei,Chunk,SizeOf(Chunk));
      Case Chunk.CType of
        11 : ReadPalette;
        12 : ZeilenDecodieren;
        13 : FillChar(VideoRam,64050,0);
        15 : RLEDecodieren;
        16 : BlockRead(Datei,VideoRam,64000);
      End;
    End;
    VGA.WaitRetrace;
    If F = Frame Then VGA.Wait(Time);
    VGA.Wait(SlowDown);
  End;
End;

Procedure PlayMovie2;
Var
  FilePosAlt : LongInt;
  F,C : Word;
  B : Byte;

Begin
  For F := 1 to FliHeader.Frames do
  Begin
    If (FilePos(Datei) < FilePosAlt + FrameHeader.Size) and (F > 1) then Seek(Datei,FilePosAlt + FrameHeader.Size);
    FilePosAlt := FilePos(Datei);
    BlockRead(Datei,FrameHeader,SizeOf(FrameHeader));
    For C := 1 to FrameHeader.Chunks do
    Begin
      BlockRead(Datei,Chunk,SizeOf(Chunk));
      Case Chunk.CType of
        11 : ReadPalette;
        12 : ZeilenDecodieren;
        13 : FillChar(VideoRam,64050,0);
        15 : RLEDecodieren;
        16 : BlockRead(Datei,VideoRam,64000);
      End;
    End;
    VGA.WaitRetrace;
    VGA.Wait(SlowDown);
  End;
End;

Begin
Assign(Datei,Datnam);
Reset(Datei,1);
VGA.Init(False);
Key:='5';
BildBreite := 0; BildHoehe := 0; DeltaX := 0; DeltaY := 0;
New(Cache); FillChar(Cache^,61440,0);
For Counter:= 1 to Anzahl do
  Begin
  Seek(Datei,0);
  BlockRead(Datei,FliHeader,SizeOf(FliHeader));
  If StopFLI = True Then PlayMovie(Time,Frame) Else PlayMovie2;
End;
Close(Datei);
Dispose(Cache);
end;





Begin
  GetIntVec($10,Addr(OldInt10h));
  VGA.GetPalette(0,255,ActivePal);
  Use8000h := False;
  FNT:=False;
End.