USES AGFX;

{-f-l-i----------------------------------------------------------------------}
const scrseg:word = $a000;
      b255:byte=255;
var
   fapg:file;
   fsiz:word;
   lower,b,bw,bb:byte;
   w,x,xx,y,z,indeks:word;
   w1:word;
   b1,b2,b3:byte;
   li:longint;
   fakbak:^tfake;
   fbseg:word;
TYPE
  fliheader = RECORD
                SIZE : LONGINT;
                htype : WORD;
                framecount : WORD;
                width : WORD;
                height : WORD;
                bitsperpixel : WORD;
                FLAGS : INTEGER;
                speed : INTEGER;
                nexthead : LONGINT;
                framesintable : LONGINT;
                hfile : INTEGER;
                hframe1OFFSET : LONGINT;
                strokes : LONGINT;
                session : LONGINT;
                reserved : ARRAY [1..88] OF BYTE;
              END;
  frameheader = RECORD
                  SIZE : LONGINT;
                  ftype : WORD;
                  chunks : WORD;
                  expand : ARRAY [1..8] OF BYTE;
                END;
  chunkheader = RECORD
                  SIZE : LONGINT;
                  id : WORD;
                END;
  RGB = RECORD
          r, g, b : BYTE;
        END;
  paltype = ARRAY [0..255] OF RGB;
VAR
  h: fliheader;
  pal : ^paltype;
  fh: frameheader;
  CH: chunkheader;
  licznik,inx, i, j : WORD;
  speed : WORD;
  f,ff: FILE;
  fname : STRING;
  firstframe : LONGINT;
  linecountic:word;
  playflag:boolean;
  currentframe:word;
  currentflipos:longint;
{----------------------------------------------------------------------------}

{-f-l-i----p-r-o-c-e-d-u-r-e-s-----------------------------------------------}
PROCEDURE decodeFLI_black; ASSEMBLER;
ASM
mov cx,16000
mov es,SCRSEG
xor ax,ax
mov di,ax
db $66; rep stosw
end;

PROCEDURE decodeFLI_brun; ASSEMBLER;
var linecount : word;
ASM
mov linecount,200
mov ax,0a000h
mov es,ax
xor di,di
push ds
mov ax,fakeseg
mov ds,ax
xor ax,ax
mov bx,ds
mov dx,ax
and ax,15
mov si,ax
shr dx,4
add bx,dx
mov ds,bx
cld
mov dx,di
xor ah,ah
@linelp:
mov di,dx
lodsb
mov bl,al
test bl,bl
jmp @endulcloop
@ulcloop:
lodsb
test al,al
js @ucopy
mov cx,ax
lodsb
rep stosb
dec bl
jnz @ulcloop
jmp @ulcout
@ucopy:
neg al
mov cx,ax
rep movsb
dec bl
@endulcloop:
jnz @ulcloop
@ulcout:
add dx,320
dec linecount
jnz @linelp
pop ds
end;

PROCEDURE decodeFLI_lc; ASSEMBLER;
var linecount : word;
ASM
mov es,scrseg
xor di,di
push ds
{lds ax,fake}
mov ax,fakeseg
mov ds,ax
xor ax,ax
mov bx,ds
mov dx,ax
and ax,15
mov si,ax
shr dx,4
add bx,dx
mov ds,bx
cld
lodsw
mov dx,ax
shl ax,8
shl dx,6
add ax,dx
add di,ax
lodsw
mov linecount,ax
mov dx,di
xor ah,ah
@linelp:
mov di,dx
lodsb
mov bl,al
test bl,bl
jmp @endulcloop
@ulcloop:
lodsb
add di,ax
lodsb
test al,al
js @ulcrun
mov cx,ax
rep movsb
dec bl
jnz @ulcloop
jmp @ulcout
@ulcrun:
neg al
mov cx,ax
lodsb
rep stosb
dec bl
@endulcloop:
jnz @ulcloop
@ulcout:
add dx,320
dec linecount
jnz @linelp
pop ds
end;

PROCEDURE decodeFLI_copy; ASSEMBLER;
ASM
mov ax,SCRSEG
mov es,ax
xor di,di
push ds
{lds ax,fake}
mov ax,fakeseg
mov ds,ax
xor ax,ax
mov bx,ds
mov dx,ax
and ax,15
mov si,ax
shr dx,4
add bx,dx
mov ds,bx
mov cx,16000
db $66; rep movsw
pop ds
end;

PROCEDURE decodeFLI_color; ASSEMBLER;
ASM
les ax,pal
mov bx,es
mov dx,ax
and ax,15
mov di,ax
shr dx,4
add bx,dx
mov es,bx
push ds
{lds ax,fake}
mov ax,fakeseg
mov ds,ax
xor ax,ax
mov bx,ds
mov dx,ax
and ax,15
mov si,ax
shr dx,4
add bx,dx
mov ds,bx
cld
lodsw
mov bx,ax
test bx,bx
jmp @endu
@u:
lodsb
add di,ax
add di,ax
add di,ax
lodsb
or al,al
jnz @u2
mov ax,256
@u2:
mov cx,ax
add cx,ax
add cx,ax
rep movsb
dec bx
@endu:
jnz @u
sub di,768
mov si,di
push es
pop ds
mov cx,256
mov bl,0
@setpal:
mov dx,3c8h
mov al,bl
out dx,al
inc dx
lodsb
out dx,al
lodsb
out dx,al
lodsb
out dx,al
inc bl
loop @setpal
pop ds
end;

procedure writel(wr:byte);
begin
blockwrite(fapg,wr,1);
end;

procedure kill255;
var kx:word;
begin
for kx:=0 to 64000 do if mem[$a000:kx]=255 then mem[$a000:kx]:=0;
end;

procedure apgsave(nazwa:string);
begin
assign(fapg,nazwa);
rewrite(fapg,1);
for indeks:=0 to 64000 do begin
li:=indeks;
b:=mem[$a000:li];
w1:=0;
repeat
mem[$a000:li]:=100;w1:=w1+1;li:=li+1;
until (mem[$a000:li]<>b) or (w1=255) or (li>=64000);
dec(li);
if w1>3 then begin
writel(b255);
writel(lo(w1));
writel(hi(w1));
writel(b);end else for x:=1 to w1 do writel(b);
if li>64000 then begin close(f);exit;end;
indeks:=li;
end;
close(fapg);
end;


procedure playflisimple(fname:string);
begin
assign(f,fname);
reset(f,1);
blockread(f,h,sizeof(h));
speed:=h.speed;
firstframe:=filepos(f);
for i:=1 to h.framecount do begin
blockread(f,fh,sizeof(fh));
if fh.chunks>0 then
for j:=1 to fh.chunks do begin
blockread(f,ch,sizeof(ch));
blockread(f,mem[fakeseg:0],ch.size-sizeof(ch));
case ch.id of
11:decodeFLI_color;
12:decodeFLI_lc;
13:decodeFLI_black;
15:decodeFLI_brun;
16:decodeFLI_copy;
end;
kill255;
copyfake($a000,fbseg);
apgsave(AWTS(I)+'.apg');
copyfake(fbseg,$a000);
end;
end;
close(f);
end;

type aflinfo=array[1..100] of record
     start:longint;
     size:longint;
     end;
var
     framesdata:Aflinfo;
     iframes:byte;

BEGIN
if paramstr(2)='' then begin
 asettext;
 writeln('  FLI to AFL Converter                                   ');
 writeln('  AFLs only owner is AxHELL                              ');
 writeln('  PARAMETRS :  FLI2AFL <infile> <outfile>                ');
 writeln('  WHERE :  infile - FLI animation file with extension    ');
 writeln('          outfile - ALF animation file with extension    ');
 writeln('');
 halt(255);
 end;
ASETMODE;
asetfake;
new(fakbak);
fbseg:=seg(fakbak^);
new(pal);
PLAYFLISIMPLE(paramstr(1));
iframes:=h.framecount;
assign(ff,paramstr(2));
rewrite(ff,1);
agetpal(blackpal);
blockwrite(ff,blackpal,sizeof(blackpal));
for i:=1 to iframes do begin
assign(f,AWTS(I)+'.apg');
reset(f,1);
framesdata[i].size:=filesize(f);
if i>1 then
framesdata[i].start:=framesdata[i-1].start+framesdata[i-1].size else
framesdata[i].start:=768;
blockread(f,mem[fakeseg:0],framesdata[i].size);
blockwrite(ff,mem[fakeseg:0],framesdata[i].size);
erase(f);
close(f);
end;
for i:=1 to iframes do begin
blockwrite(ff,framesdata[i],sizeof(framesdata[i]));
end;
blockwrite(ff,iframes,1);
close(ff);
dispose(pal);
dispose(fakbak);
afreefake;
ASETTEXT;
END.