//*****************************************************************************
//	Plain light
//*****************************************************************************


//*****************************************************************************
//	Attributes
//*****************************************************************************
//float4x4		g_ProjMatrix				: PROJ;
float4x4		g_WorldMatrix				: WORLD;
float4x4		g_ViewProjMatrix		: VIEWPROJ;
float4x4		g_ViewMatrix				: VIEW;
float				g_fTime							: TIME;

float4			g_BlurVector				: EFFECTVEC;
//*****************************************************************************
//	Constants
//*****************************************************************************

//*****************************************************************************
//	Textures
//*****************************************************************************


texture BGTexture : TX1 ;			// colorball is here


//*****************************************************************************
//  Texture Samplers
//*****************************************************************************

sampler FullScreenSampler = sampler_state
{
    Texture = (BGTexture) ;
    MinFilter = LINEAR  ;
    MagFilter = LINEAR  ;
} ;

//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//  shaders
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************

struct FS_VS_In
{
	float4 Position		: POSITION0;
	float2 TexCoord		: TEXCOORD0;
};

struct FS_VS_Out
{
	float4 Position		: POSITION;
	float2 TexCoord		: TEXCOORD0;
	float2 BlurVec		: TEXCOORD1;
} ;


FS_VS_Out FS_VS (FS_VS_In In)
{
	FS_VS_Out Out;
	Out.Position = In.Position;//mul(In.Position, g_ProjMatrix);
	Out.TexCoord.xy = In.TexCoord;

//	float3 p = mul(float4(-1,0,0,1), g_ViewProjMatrix);
//						- mul(float4(1,0,0,1), g_ViewProjMatrix);
//	float2 blurvec = normalize(float2(p.x, -p.y));
//	Out.BlurVec = 0.0035f*blurvec;
	Out.BlurVec = 0.007f*float2(g_BlurVector.x, -g_BlurVector.y);
	return Out;
}

struct FS_PS_In
{
	float4 TexCoord		: TEXCOORD0;
	float2 BlurVec		: TEXCOORD1;
} ;

struct FS_PS_Out
{
	float4 Color	: COLOR0 ;
} ;


FS_PS_Out MotionBlur_PS (FS_PS_In In)
{
	FS_PS_Out Out;
	float2 texp = In.TexCoord;
	float4 Color = tex2D(FullScreenSampler, texp - 4*In.BlurVec);
	Color += tex2D(FullScreenSampler, texp - 3*In.BlurVec);
	Color += tex2D(FullScreenSampler, texp - 2*In.BlurVec);
	Color += tex2D(FullScreenSampler, texp - 1*In.BlurVec);
	Color += tex2D(FullScreenSampler, texp);
	Color += tex2D(FullScreenSampler, texp + 1*In.BlurVec);
	Color += tex2D(FullScreenSampler, texp + 2*In.BlurVec);
	Color += tex2D(FullScreenSampler, texp + 3*In.BlurVec);
	Color += tex2D(FullScreenSampler, texp + 4*In.BlurVec);
	Color /= 9.0f;
	Out.Color = Color;
	return Out;
}

//*****************************************************************
//*****************************************************************
//*****************************************************************
//
// Techniques
//
//*****************************************************************
//*****************************************************************
//*****************************************************************


technique MotionBlur
{
	pass P0
    {
			ZEnable = false ;
			ZWriteEnable = false;
			CullMode = NONE ;
			AlphaBlendEnable = true;
			srcblend = srcalpha;
			destblend = invsrcalpha;
			VertexShader = compile vs_2_0 FS_VS();
			PixelShader = compile ps_2_0 MotionBlur_PS();
    }
}
