;  A_RENDER.ASM -- draws scenery // A.R-M. 7/93

        IDEAL
        MODEL Compact, Pascal
        RADIX 10
        P286

        INCLUDE "globals.inc"
        INCLUDE "a_ray_t.inc"        ; include SRay type def

SideMargin = (160-WindowWidth/2)/16  ; margin before screen start

MACRO   TURN TurnAngle
        push [Ray]
        push TurnAngle
        call TurnRay
        ENDM

        DATASEG

EXTRN Column0 : Byte
EXTRN NumberOfBearings : Word
EXTRN ScrHeight : Word

RenderRay       SRay    <>


        CODESEG

EXTRN FillWithFloorSky : NEAR

EXTRN ShootRay    : NEAR
EXTRN Project     : NEAR
EXTRN Dump16cols  : NEAR

PUBLIC Render           ;(Ray:Near ptr; WallTextures:Near ptr)
PUBLIC TurnRay          ;(Ray:Near ptr; Angle:integer)
PUBLIC AdvanceRay       ;(Ray:Near ptr; AdvX,AdvY : integer);

; Note: WallTextures format:
;
;           dd  P(south), P(west), P(north), P(east)  ; wall code 1
;           dd  P(south), P(west), P(north), P(east)  ; wall code 2
;           . . . . . . . . . . . . . . . . . . . . .
;           dd  P(south), P(west), P(north), P(east)  ; wall code n

; where P(north) = seg:ofs pointer to texture for north side of
; wall, etc.  (wall code 0 is reserved for empty squares)


        PROC Render NEAR
        ARG Ray : NEAR PTR SRay, WallTextures : NEAR PTR
        LOCAL SaveSector : Word, SaveAngle : Word, SaveLength : Word, \
              ColumnAddress : Word, \
              ScrOfs : Word, Xcoord : Word, Xblock : Word, \
              Step : Word, ColMask : Word
          pusha

          mov di, [Ray]
          mov ax, [di+SRay.Angle]
          mov bx, [di+SRay.Sector]
          mov cx, [di+SRay.Length]
          mov [SaveAngle], ax
          mov [SaveSector],bx
          mov [SaveLength], cx

          Turn +160d-16d*SideMargin

          xor ax, ax
          mov [di+SRay.Length], ax ; set length to 0

          mov ax, 100d           ; center screen vertically
          mov bx, [ScrHeight]
          shr bx,1
          sub ax, bx             ; ax = 100-ScrHeight/2
          shl ax,4
          mov bx, ax
          shl ax,2
          add bx, ax             ; bx = (100-ScrHeight/2)*80
          add bx, 4*SideMargin

          mov [ScrOfs], bx

; Loop for 1 to 20 16-pixel blocks Ŀ

          mov [Xcoord], 16d*SideMargin
          mov [Xblock], 0

          mov cx, 20d-2*SideMargin
@@loop1:  push cx

          mov [ColMask], 1

; Loop for 1 to 4 Mask offsets at same addr Ŀ

          mov [ColumnAddress], offset Column0
          call FillWithFloorSky

          mov cx, 4
@@loop2:  push cx

          mov [Step], 0

; Loop for 1 to 4 bytes in a dword Ŀ

          mov cx, 4
@@loop3:  push cx

          push [Ray]                 ; = offset Ray
          push offset RenderRay
          call ShootRay

;  - - - -  DRAW ONE COLUMN  - - - - - Ŀ

; RenderRay.Length = path length
;               al = contents code
;               ah = wall side (0..3)
;               dx = offset along wall (0..32767)

          push ax
          dec al
          xor bx, bx
          add bl, al
          shl bx, 2                   ; bx = offset WallTextures
          add bl, ah                  ;      + 16*(contents code, al)
          shl bx, 2                   ;      +  4*(wall side, ah)
          add bx, [WallTextures]

          les di, [dword ptr bx]      ; es:di -> Texture

IF TexRes EQ 128d
          xor dl, dl
          shr dx,1                    ; dx now from (0..127)*128
ENDIF
IF TexRes EQ 64d
          and dx, 0111111000000000b
          shr dx, 3                   ; dx now from (0..63)*64
ENDIF
          add di, dx                  ; es:di -> Texture[column]

          pop ax
          push ds
          push [ColumnAddress]
          push es
          push di                     ; FAR PTR to column of texture
          push ax                     ; wall side
          push [Step]                 ; 0,1,2,3 column no. in dword
          push [Xcoord]
          mov dx, [RenderRay.Length]
          push dx                     ; distance for projection
          call Project                ; project column on screen

;  - - - - - - - - - - - - - - - - - - 

          inc [Step]
          Turn -4
          add [Xcoord],4

          pop cx
          loop @@loop3

; end for bytes in a dword 

          add [ColumnAddress], 200d*4

          shl [ColMask],1
          Turn +15
          sub [Xcoord],15

          pop cx
          loop @@loop2

; end for mask values 

          push [ScrOfs]               ; ofs in current page
          push [Xblock]
          call Dump16cols             ; dump 4 cols to screen

          add [ScrOfs], 4
          Turn -12
          add [Xcoord],12

          inc [Xblock]
          pop cx

          loop @@OutOf
          jmp @@Range
@@OutOf:  jmp @@loop1    ; this was a "loop @@loop1", but it got
@@Range:                 ; one miserable byte out of range!

; end for the 20 16-pixel blocks 

; restore Ray's bearing & length

          mov di, [Ray]
          mov ax, [SaveAngle]
          mov bx, [SaveSector]
          mov cx, [SaveLength]
          mov [di+SRay.Angle], ax
          mov [di+SRay.Sector],bx
          mov [di+SRay.Length],cx

          popa
          ret
        ENDP

; Another little message for debugger fans:

        db '. Hiya, there! How''s it going? :-) // ARM .'

; // TurnRay

        PROC TurnRay NEAR
        ARG Ray : NEAR PTR SRay, TurnAngle : Word
        USES ax, bx, cx, di

          mov cx, [NumberOfBearings]

          mov di, [Ray]
          mov ax, [di+SRay.Angle]
          mov bx, [di+SRay.Sector]

          add ax, [TurnAngle]
          js @@negative
          cmp ax, cx
          jl @@leave

@@positive:
          inc bx
          cmp bx,8
          jne @@2
          xor bx,bx
@@2:      sub ax, cx
          cmp ax, cx
          jge @@positive
          jmp @@leave

@@negative:
          dec bx
          jns @@1
          mov bx, 7
@@1:      add ax, cx
          js @@negative

@@leave:
          mov [di+SRay.Sector], bx
          mov [di+SRay.Angle], ax
          ret
        ENDP


; // AdvanceRay

        PROC AdvanceRay NEAR
        ARG Ray : NEAR PTR SRay, AdvX : Word, AdvY : Word
P386
          mov di, [Ray]

          movzx ax, [di+SRay.MapX]
          shl eax,16
          mov bx, [di+SRay.FineX]
          shl bx,1
          mov ax,bx
          movzx ebx, [AdvX]
          add eax,ebx
          shr ax,1
          mov [di+SRay.FineX], ax
          shr eax,16
          mov [di+SRay.MapX], al

          movzx ax, [di+SRay.MapY]
          shl eax,16
          mov bx, [di+SRay.FineY]
          shl bx,1
          mov ax,bx
          movzx ebx, [AdvY]
          add eax,ebx
          shr ax,1
          mov [di+SRay.FineY], ax
          shr eax,16
          mov [di+SRay.MapY], al

P286
          ret
        ENDP


        END

