{----------------------------------------------------------}
{ LOWTEST                                                  }
{ Geoffrey Silverton  1/1993                               }
{                                                          }
{ Tests the LOWRES unit.                                   }
{----------------------------------------------------------}

program LowTest;
uses crt, lowres;

const
  LX1 = 5;                 { Location of lower boxes }
  LY1 = 32;
  LX2 = 76;
  LY2 = 95;

  RX1 = 82;
  RY1 = 32;
  RX2 = 154;
  RY2 = 95;


{ Draw a "shadow box" border }
procedure shadow_box(x1, y1, x2, y2: integer;
                     c_light, c_dark: byte;
                     out: boolean);
  begin
    if out then         { "pop out" border }
      begin
        lline(x1, y1, x2-1, y1, c_light);
        lline(x1, y1, x1, y2-1, c_light);
        lline(x1, y2, x2, y2, c_dark);
        lline(x2, y1, x2, y2, c_dark);
      end
    else                { "push in" border }
      begin
        lline(x1, y1, x2, y1, c_dark);
        lline(x1, y1, x1, y2, c_dark);
        lline(x1+1, y2, x2, y2, c_light);
        lline(x2, y1+1, x2, y2-1, c_light);
      end
  end;


{ Draw screen for demo }
procedure show_screen;
  var
    i, j:  integer;
    count: integer;

  begin
    prepare_low(0, 0, 159, 99,                   { Fill whole screen with char }
                221,                             {   221 so can plot pixels.   }
                LIGHTGRAY, LIGHTGRAY);           {   Initialize to LIGHTGRAY.  }
    shadow_box(0, 0, 159, 99, WHITE, DARKGRAY, TRUE);

    { Text box }
    shadow_box(4, 5, 77, 25, WHITE, DARKGRAY, TRUE);
    ltextbackground(LIGHTGRAY);
    ltextcolor(BLUE);
    lgotoxy(8, 14);
    lwrite('LOWRES UNIT');
    lwrite(' demo');
    lgotoxy(11, 22);
    ltextcolor(BLACK);
    lwrite('160x100 16 colors');

    { Checkerboard of colors }
    shadow_box(82, 4, 155, 25, WHITE, DARKGRAY, FALSE);
    for i:=0 to 17 do
      for j:=0 to 4 do
        lfill_box(83+i*4, 5+j*4, 86+i*4, 8+j*4, (i+j) and 15);

    { Lower left box }
    shadow_box(LX1-1, LY1-1, LX2+1, LY2+1, WHITE, DARKGRAY, FALSE);
    lfill_box(LX1, LY1, LX2, LY2, BLACK);

    { Lower right box }
    shadow_box(RX1-1, RY1-1, RX2+1, RY2+1, WHITE, DARKGRAY, FALSE);
    lfill_box(RX1, RY1, RX2, RY2, BLACK);
  end;


procedure demo;
const
  NUMOLD = 20;

type
  TwoPoint= record sx, sy, ex, ey: integer; end;

var
  count1, count2:   integer;
  dcount1, dcount2: integer;
  iteration:        longint;
  x1, y1, x2, y2:   integer;
  x, y, xx, yy:     integer;
  xsize2, ysize2:   integer;
  i:                integer;
  old:              array[1..NUMOLD] of TwoPoint;

begin
  {*** Line stuff ***}
  xsize2 := (LX2 - LX1 + 1) shr 1;
  ysize2 := (LY2 - LY1 + 1) shr 1;

  { Store old line coords. for cleanup }
  for i:=1 to NUMOLD do with old[i] do
    begin
      sx := LX1;
      sy := LY1;
      ex := LX1;
      ey := LY1;
    end;

  iteration := 1;
  count1    := 0;
  count2    := 100;
  dcount1   := 10;
  dcount2   := -27;
  while not keypressed do
    begin
      {*** Line stuff ***}

      inc(iteration);
      if iteration = MAXLONGINT then
        iteration := 1;

      inc(dcount1, 4 - random(9));
      inc(dcount2, 4 - random(9));
      if abs(dcount1) > 100 then
        dcount1 := dcount1*4 div 5;
      if abs(dcount2) > 100 then
        dcount2 := dcount2*4 div 5;
      inc(count1, dcount1);
      inc(count2, dcount2);

      x1 := LX1 + trunc(xsize2 + xsize2*cos(count1*0.002) - 0.5);
      y1 := LY1 + trunc(ysize2 + ysize2*sin(count1*0.002) - 0.5);
      x2 := LX1 + trunc(xsize2 - xsize2*cos(count2*0.002) - 0.5);
      y2 := LY1 + trunc(ysize2 - ysize2*sin(count2*0.002) - 0.5);

      with old[iteration mod NUMOLD + 1] do
        begin
          lline(sx, sy, ex, ey, BLACK);
          sx := x1;
          sy := y1;
          ex := x2;
          ey := y2;
        end;

      lline(x1, y1, x2, y2, (iteration shr 4) mod 14 + 1);

      {*** Point stuff ***}
      x := random(RX2-RX1+1);
      y := random(RY2-RY1+1);
      xx := (RX2-RX1+1) shr 1 - x;
      yy := (RY2-RY1+1) shr 1 - y;
      lplot(RX1 + x,
            RY1 + y,
            ((xx*xx+yy*yy) shr 3) and 15);
    end;
end;


begin
  enter_lowres_mode;                           { Enter 160x100x16 mode }

  show_screen;
  demo;

  exit_lowres_mode;                            { Don't forget to do this! }
end.


{
  If your program aborts abnormally (without returning to normal text
  mode) because of a run-time error, shell to dos and type "mode co80"
  so you can read text normally again.  If you are running Turbo Pascal 4,
  type <ESC><ESC><ALT-F>O to shell to dos.

  Turbo Pascal 6 handles the low-res mode correclty and will return to
  text mode properly if a run-time error occurs while running from the
  integrated environment.
}