;; This is the C prototype header file for DOSCALLS.  This provides
;; the minimal DOS dependent interface for flatmodel programs into
;; DOS.        The primary support needed is the ability to allocate and
;; de-allocate memory in the low 1mb of address space.
;; extern char * cdecl AllocLowMem(long int size,short *selector); // Allocate low memory.
;; extern void cdecl FreeLowMem(short selector); // Free allocated memory.
;; extern char * cdecl RealPtr(char *real); // Convert flat model address to segment:offset
;; extern void cdecl memorymove(char *dest,char *source,long int length);
;;																																					 */
;;		Written by John W. Ratcliff (c) 1994
;;			 Compuserve: 70253,3237
;;			 Genie: J.RATCLIFF3
;;			 BBS: 1-314-939-0200
;;			 Addresss:
;;			    747 Napa Lane
;;			    St. Charles, MO 63304
;;																																					 */
	IDEAL
	P386
	JUMPS
	MODEL FLAT,C
	CODESEG

	public	AllocLowMem
	public	FreeLowMem
	public	RealPtr
	public	memorymove
	public	tprint
	public	TextCursor


Proc	C AllocLowMem	near
	ARG	AMOUNT:DWORD,SELECTOR:DWORD
	uses	ebx,edx

	mov	ebx,[AMOUNT]	; Get number of bytes requested.
	add	ebx,15		; Round up to closest number of paragraphs.
	shr	ebx,4		; /16.
	mov	eax,0100h	; Allocate.
	int	31h		; Allocate memory.
	jc	@@ERR
	shl	eax,4		; Into flat model address space.
	mov	ebx,[SELECTOR]	; Get address of selector.
	mov	[ebx],dx	; Save selector.
	jmp short @@RET
@@ERR:	xor	eax,eax 	; Zero return address.
@@RET:
	ret
	endp

Proc	C FreeLowMem	near
	ARG	SELECTOR:DWORD

	mov	eax,0101h
	mov	edx,[SELECTOR]
	int	31h

	ret
	endp

Proc	C RealPtr	near
	ARG	DATA:DWORD
	uses	edx

	mov	eax,[DATA]
	mov	edx,eax
	and	eax,0Fh 	; Offset portion.
	and	edx,0FFFF0h
	shl	edx,(16-4)
	add	eax,edx

	ret
	endp

Proc	C memorymove near
	ARG	DEST:DWORD,SOURCE:DWORD,MLEN:DWORD
	uses	ecx,esi,edi

	mov	esi,[SOURCE]
	mov	edi,[DEST]
	mov	ecx,[MLEN]
	rep	movsb

	ret
	endp

PROC	C tprint near
	ARG	XLOC:DWORD,YLOC:DWORD,LN:DWORD,STRING:DWORD,COLOR:DWORD
	uses	ebx,ecx,edx,esi,edi

	mov	esi,[STRING]	    ;; Get base address of text to print.
	cmp	[LN],0		;; If length passed is zero, then use string length.
	jne	@@LNPASS	;; use length passed.
	or	esi,esi 	  ;; Null string?
	jz	@@EXIT		;; yes, exit.
	mov	edi,esi
	xor	eax,eax
	mov	ecx,-1
	repnz	scasb
	neg	ecx
	dec	ecx		 ; Less one.
	mov	[LN],ecx	 ; Length of string.
@@LNPASS:
;; If ylocation above are below clip window, exit.
	mov	eax,[YLOC]		 ;; Get destination ylocation.
	or	eax,eax 		  ;; < top margin?
	js	@@EXIT			 ;; yes, doesn't fit.
	cmp	eax,25			 ;; > bottom margin?
	jg	@@EXIT			 ;; yes, doesn't fit.

;; If xlocation > right margin? yes->exit.
	mov	eax,[XLOC]		 ;; Get xlocation passed?
	cmp	eax,79			 ;; > right margin?
	jg	@@EXIT			;; doesn't fit, exit.
	or	eax,eax
	jns	@@SKP1			;; no, start postion is ok.
	neg	eax			 ;; Make it positive.
	or	esi,esi 		  ;; Null string?
	jz	@@REN
	add	esi,eax 		  ;; Number of pixels to skip.
@@REN:	sub	[LN],eax		 ;; Differnece, from total length.
	js	@@EXIT
	jz	@@EXIT			 ;; If length zerod out, get out.
	mov	[XLOC],0		;; Set it.
@@SKP1:
	add	eax,[LN]		 ;; Add total length.
	dec	eax			 ;; Less one to ending pixel position.
	cmp	eax,79			 ;; Past right margin?
	jle	@@SKIP			;; no->it fits fine.
	sub	eax,79			 ;; Amount past right margin.
	sub	[LN],eax		 ;; Lower total length.
	js	@@EXIT			;; if negitze, no go.
@@SKIP: mov	edi,0B8000h
	mov	eax,160
	mul	[YLOC]
	add	edi,eax
	mov	eax,[XLOC]
	shl	eax,1
	add	edi,eax

	mov	eax,[COLOR]
	mov	ah,al			;; Into AH.
	mov	ecx,[LN]		 ;; Length.
	or	esi,esi
	jz	@@SPACE 		;; Fill rest with spaces
@@SND:	lodsb				;; Get character to send.
	or	al,al			;; Is it eos?
	jz	@@SPACE 		;; fill rest with spaces.
	stosw
	loop	@@SND
	jmp	@@EXIT
@@SPACE:mov	al,20h			;; Space character.
@@FILL: rep	stosw			;; Fill rest with spaces.


@@EXIT:
	ret
	endp

PROC	C TextCursor near
	ARG	XLOC:DWORD,YLOC:DWORD
	uses	ebx,edx

	mov	eax,[YLOC]
	mov	edx,[XLOC]
	mov	dh,al
	mov	ah,2
	mov	bh,0
	int	10h

	ret
	endp



	end
