{$A+,B-,D+,E-,F-,G+,I+,L+,N+,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,655360}

uses
  Crt;

const
  AddShift: Integer = 0;
  StateShift: Integer = 0;

  YourDreamsComeTrue = False;
  MaxByte = 320*200-1;

label
  MoveOut;

type
  PRaw = ^TRaw;
  TRaw = array [0..199, 0..319] of Byte;
  PLinear = ^TLinear;
  TLinear = array [0..MaxByte] of Byte;
  TFloat = Single;

var
  Video: TRaw absolute $A000:$0000;
  Pix: array [Boolean] of PRaw;
  Plasma: PRaw;
  Temp: PRaw;

{$I Plasma.Pas}

procedure ReadRaw(Raw: PRaw; FileName: PChar);
const
  LoadPalette: Boolean = True;
var
  F: File;
  PalOfs: Word;
  Palette: array [0..256*3-1] of Byte;
begin
  Assign(F, FileName);
  Reset(F, 1);
  if LoadPalette then
  begin
    Seek(F, FileSize(F) -SizeOf(TRaw)-256*3);
    BlockRead(F, Palette, SizeOf(Palette));
    PalOfs := Ofs(Palette);
    asm
      push ds

      mov dx,03C8h
      mov al,0
      out dx,al
      inc dx

      mov ax,ss
      mov ds,ax
      mov si,[PalOfs]
      mov cx,256*3
    @@next:
      lodsb
      shr al,2
      out dx,al
      loop @@next
      pop ds
    end;
    LoadPalette := False;
  end;
  Seek(F, FileSize(F) -SizeOf(TRaw));
  BlockRead(F, Raw^, SizeOf(TRaw));
  Close(F);
end;

procedure DrawState_Plasma(State, Mask, Add: Integer);
var
  I, B: Word;
begin
  For I := 0 to MaxByte do
  begin
    B := Integer(PLinear(Plasma)^[I]) + State;
    PLinear(@Video)^[I] := PLinear(Pix[(B and Mask) + Add > 32])^[I];
  end;
end;

var
  State, Add: Integer;

begin
  if ParamCount > 0 then
  begin
    Write('Enter AddShift: '); ReadLn(AddShift);
    Write('Enter StateShift: '); ReadLn(StateShift);
  end;

  Randomize;
  New(Pix[False]);
  New(Pix[True]);
  New(Plasma);
  asm mov ax,13h; int 10h; end;

  ReadRaw(Pix[False], 'Pic1.Raw');
  ReadRaw(Pix[True], 'Pic2.Raw');

  State := 0;

  repeat
    MakePlasma(Plasma);
    For Add := 0 to 127 shl AddShift do
    begin
      { Redraw }
      Inc(State);
      DrawState_Plasma(State shr StateShift, 63, Add shr AddShift - 63);
      if KeyPressed then GoTo MoveOut;
    end;
    Temp := Pix[False]; Pix[False] := Pix[True]; Pix[True] := Temp;
  until YourDreamsComeTrue;

MoveOut:

  ReadKey;
{  asm mov ax,00h; int 16h; end;}
  asm mov ax,03h; int 10h; end;
end.
