#ifdef _WIN32
#include <windows.h>
#endif
#include "music.h"

#include "llscreen.h"
#include "llkey.h"
#include "jclib.h"
#include "timer.h"
#include "llvesa.h"
#include "sincos.h"
#include "text.h"
#include "lbm.h"
#include "tcscr.h"

#define _VSBASE_H_


#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

bool InShittyWinblows = 0;

// ---------------------------

#include "despair.h"
#include "events.h"
#include "main.h"

extern bool (*CurFunction)(dword time) = NULL;
extern int FirstPattern;
extern int FirstPos;


extern void GenericTimerHandler(void) {
    CallMusicHandle();
}

void FinishProgram() {
    TIMER_End();
    DoneMusicSystem();
    LLK_End();
}

void demomain() {
	SDL_Event event;

    int i;
    dword CurEvent = 0;
    int p, n;
    dword lasttime;
	static bool Quitting = FALSE;


    if (getenv("windir"))
        InShittyWinblows = 1;
    else
        InShittyWinblows = 0;

    //ArgC = argc;
    //ArgV = argv;


    InitSinCos();

    /*
    VGA_SetMode(3);
    printf("Despair 1.0, (C) Copyright 1996 by Iguana.\n"
           "\n"
           "  Use DESPAIR [-type #] [-bpp 8, 15, 16, 32]\n"
           "    NOTE: The PrtScr key will capture the screen to consecutive pictures.\n"
           "\n");
           */

    JCLIB_Init("DESPAIR.DAT");

    FONT_Load(&FONT_System, "GFX\\FONT2.FNT");

    InitMusicSystem();

    LLK_Init();
    LLK_DoChain = FALSE;
    LLK_ChainChange = FALSE;
    LLK_LastScan = 0;

    InitMusic("MUSIC\\DESPAIR.S3M");

    if ( (i = BASE_CheckArg("pat")) > 0)
        FirstPattern = atoi(ArgV[i]);
    if ( (i = BASE_CheckArg("pos")) > 0)
        FirstPos = atoi(ArgV[i]);


    FirstPattern = 0;
    if (FirstPattern > 1) {
        SetMusicPattern(FirstPattern);
        SetMusicPos(FirstPos);
    }

    LLS_Init(LLSM_VIRTUAL, LLSVM_MODE13);

    TIMER_Init(TIMER_70HZ);
    TIMER_HookFunction = &GenericTimerHandler;

    
    lasttime = 0;
    while (!Quitting) {
        
       
        TIMER_Clock = TIMER_GetTime();

        while (CurEvent == 0 ||
            EventTable[CurEvent].pat < GetMusicPattern()
            || (EventTable[CurEvent].pat == GetMusicPattern() &&
                EventTable[CurEvent].pos < GetMusicPos())) {
            if (EventTable[CurEvent].func == NULL)
                break;
            if (!EventTable[CurEvent].func(TIMER_Clock))
                break;
            CurEvent++;
        }

        if (CurEvent >= SIZEARRAY(EventTable))
            break;

        if (lasttime != TIMER_Clock) {
            lasttime = TIMER_Clock;
            if (CurFunction != NULL && !CurFunction(TIMER_Clock))
                break;
        }

        if (CurFunction == NULL && !Quitting) {
            DoneMusic();
            Quitting = TRUE;
        }

        DoFade(TIMER_Clock);

        if (LLK_LastScan == kQ)
            break;

        if (LLK_LastScan == kESC) {
            if (Quitting || !IsThereMusic()) {
                break;
            }
            DoneMusic();
            Quitting = TRUE;
        } else if (LLK_LastScan == kPRTSC || LLK_LastScan == kSYSREQ) {
            static int npic = 0;
            char buf[13];
            if (TCS_Bpp == 0) {
                sprintf(buf, "dspair%02d.PCX", npic % 100);
                PCX_Write(buf, LLS_SizeX, LLS_SizeY, DestPal, LLS_Screen[0]);
            } else {
                sprintf(buf, "dspair%02d.TGA", npic % 100);
                //VSTGA_SavePic(buf, TCS_Screen, TCS_Width, TCS_Height);
            }
            npic++;
        }
        LLK_LastScan = 0;

        if (!IsMusicPlaying()) {
            break;
        }

        LLS_DUMP();

		//update SDL events
		while (SDL_PollEvent(&event)) 
		{
			switch (event.type) 
			{
			case SDL_KEYDOWN:
				break;
			case SDL_KEYUP:
				// If escape is pressed, return (and thus, quit)
				if (event.key.keysym.sym == SDLK_ESCAPE)
					Quitting = TRUE;
				break;
			case SDL_QUIT:
				Quitting = TRUE;
			}
		}
    }

    p = GetMusicPattern();
    n = GetMusicPos();

    DoneMusic();

    FinishProgram();

    /*
    printf("Thank you for despairing along.\n"
           "(C) Copyright 1996 by Iguana.\n" );*/
}
