// ---------------------------- VSCAMERA.H -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// 3D Camera handling
#if 0

#ifndef _VSCAMERA_H_
#define _VSCAMERA_H_


#include "vsalgeb.h"
#include "vsviewp.h"


#ifdef __cplusplus
extern "C" {
#endif


typedef struct {
    VSALG_T3DPoint  c;          // Position of camera in global space.
    VSALG_T3DMatrix m;          // Rotation of camera in global space.
    VSALG_T3DPoint  dir;        // Direction of camera in global space.
    VSALG_TCoord focus;         // Focus of camera.

        // Dynamic fields set for a specific view (VSS_TScreen).
    VSALG_T3DMatrix im;         // Inverse of rotation matrix.
    VSALG_TCoord fx, fy;        // X- and Y-axis focus (*subpixelsize).
    VSALG_TCoord cx, cy;        // X- and Y-axis screen center (*subpixelsize).
    VSALG_TCoord xz[4];         // Delta factors for the four planes, UDLR.
} VSC_TCamera, *VSC_PCamera;

// -------------------

extern void VSC_SetCamera(VSC_PCamera cam,
                          VSALG_P3DPoint c,
                          VSALG_P3DMatrix m,
                          VSALG_TCoord focus);

extern void VSC_SetCameraParms(VSC_PCamera cam, VSV_PViewport v);

#ifdef __cplusplus
}
#endif


#endif

// ---------------------------- VSCAMERA.H -----------------------
#endif