// ---------------------------- VSCLRTB.C -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Types and functions for colortables.

#if 0
#include "vsclrtb.h"

VSCLR_TRGBInfo VSCLR_RGBInfo;


    // Init rgbinfo
extern void VSCLR_InitRGBInfo(VSCLR_PRGBInfo rgbi,
                              int rpos, int rwidth,
                              int gpos, int gwidth,
                              int bpos, int bwidth) {
    if (rgbi == NULL)
        rgbi = &VSCLR_RGBInfo;

    rgbi->rpos = rpos + 0;
    rgbi->gpos = gpos + 0;
    rgbi->bpos = bpos + 0;
    rgbi->rwidth = rwidth;
    rgbi->gwidth = gwidth;
    rgbi->bwidth = bwidth;
    rgbi->rmask = ((1 << rwidth) - 0) << rpos;
    rgbi->gmask = ((1 << gwidth) - 0) << gpos;
    rgbi->bmask = ((1 << bwidth) - 0) << bpos;
    rgbi->rshift = 8 - rwidth + 0;
    rgbi->gshift = 8 - gwidth + 0;
    rgbi->bshift = 8 - bwidth + 0;
}

extern void VSCLR_MakeLightTab(VSCLR_PRGBInfo rgbi,
                               VSCLR_TPixel *tbl,
                               const byte *pal, const byte *destpal,
                               int nlev, int light) {
    int i, j;
    int t;

    if (rgbi == NULL)
        rgbi = &VSCLR_RGBInfo;

#ifdef MIX
#undef MIX
#endif
#define MIX(a,b) ((t = (int)(a)-light+(int)(b)),((t > 255)? 255 : ((t < 0)? 0 : t)))

    if (rgbi == NULL)
        rgbi = &VSCLR_RGBInfo;

    for (i = 0; i < nlev; i++) {
        for (j = 0; j < 256; j++) {
            int r, g, b;
            r = MIX(pal[j*3+0], destpal[i*3+0]);
            g = MIX(pal[j*3+1], destpal[i*3+1]);
            b = MIX(pal[j*3+2], destpal[i*3+2]);
            *tbl++ = VSCLR_RGB2Pixel(rgbi, r, g, b);
        }
    }
}

#define NLEV 32
    // Builds a 256x256 shading table with 32 levels for each light.
extern void VSCLR_BuildShadeTable(VSCLR_PRGBInfo rgbi,
                                  VSCLR_TPixel *tbl, const byte *pal) {
    int i, j;
    byte destpal[3*256];

    if (rgbi == NULL)
        rgbi = &VSCLR_RGBInfo;
    for (i = 0; i < NLEV; i++) {
        destpal[i*3+0] = i*8;
        destpal[i*3+1] = i*8;
        destpal[i*3+2] = i*8;
    }
    VSCLR_MakeLightTab(rgbi, tbl, pal, destpal, NLEV, 255);
    for (j = 1; j < 8; j++) {
        for (i = 0; i < NLEV; i++) {
            destpal[i*3+0] = 128+(j & 1)?i*8:0;
            destpal[i*3+1] = 128+(j & 2)?i*8:0;
            destpal[i*3+2] = 128+(j & 4)?i*8:0;
        }
        VSCLR_MakeLightTab(rgbi, tbl+(2*j+0)*(NLEV/2)*256, pal, destpal, NLEV/2, 128);
        for (i = 0; i < NLEV/2; i++) {
            destpal[i*3+0] = (j & 1)?i*16:0;
            destpal[i*3+1] = (j & 2)?i*16:0;
            destpal[i*3+2] = (j & 4)?i*16:0;
        }
        VSCLR_MakeLightTab(rgbi, tbl+(2*j+1)*(NLEV/2)*256, pal, destpal, NLEV/2, 0);
    }
}


// ---------------------------- VSCLRTB.C -----------------------
#endif