// ---------------------------- VSCLRTB.H -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Types and functions for colortables (32-bit).

#ifndef _VSCLRTB_H_
#define _VSCLRTB_H_

#ifndef _VSBASE_H_
#include "vsbase.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef dword VSCLR_TPixel, *VSCLR_PPixel;

typedef struct {
    int rpos, rwidth;
    int gpos, gwidth;
    int bpos, bwidth;
    int rshift, gshift, bshift;
    VSCLR_TPixel rmask, gmask, bmask;
} VSCLR_TRGBInfo, *VSCLR_PRGBInfo;

extern VSCLR_TRGBInfo VSCLR_RGBInfo;

    // RGB values are given in 8 bit width.
#define VSCLR_RGB2Pixel(rgbi, r, g, b) (        \
    (((r) >> (rgbi)->rshift) << (rgbi)->rpos)   \
  | (((g) >> (rgbi)->gshift) << (rgbi)->gpos)   \
  | (((b) >> (rgbi)->bshift) << (rgbi)->bpos))


    // Init rgbinfo
extern void VSCLR_InitRGBInfo(VSCLR_PRGBInfo rgbi,
                              int rpos, int rwidth,
                              int gpos, int gwidth,
                              int bpos, int bwidth);

extern void VSCLR_MakeAlphaTab(VSCLR_PRGBInfo rgbi,
                               VSCLR_TPixel *tbl,
                               const byte *pal,
                               int nlev);

#ifdef __cplusplus
}
#endif

#endif

// ---------------------------- VSCLRTB.H -----------------------
