// ---------------------------- VSCLRTB.H -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Types and functions for colortables.

#ifndef _VSCLRTB_H_
#define _VSCLRTB_H_

#ifndef _VSBASE_H_
#include "vsbase.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef word VSCLR_TPixel, *VSCLR_PPixel;

typedef struct {
    int rpos, rwidth;
    int gpos, gwidth;
    int bpos, bwidth;
    int rshift, gshift, bshift;
    VSCLR_TPixel rmask, gmask, bmask;
} VSCLR_TRGBInfo, *VSCLR_PRGBInfo;

extern VSCLR_TRGBInfo VSCLR_RGBInfo;

    // RGB values are given in 8 bit width.
#define VSCLR_RGB2Pixel(rgbi, r, g, b) (        \
    (((r) >> (rgbi)->rshift) << (rgbi)->rpos)   \
  | (((g) >> (rgbi)->gshift) << (rgbi)->gpos)   \
  | (((b) >> (rgbi)->bshift) << (rgbi)->bpos))


    // Init rgbinfo
extern void VSCLR_InitRGBInfo(VSCLR_PRGBInfo rgbi,
                              int rpos, int rwidth,
                              int gpos, int gwidth,
                              int bpos, int bwidth);

    // Values in destpal should be positive and smaller than 256.
    /*
       Add light values. 'light' is:
          0 - bigger values in destpal mean light added.
        255 - smaller values in destpal mean obscurity.
     */
extern void VSCLR_MakeLightTab(VSCLR_PRGBInfo rgbi,
                               VSCLR_TPixel *tbl,
                               const byte *pal, const byte *destpal,
                               int nlev, int light);

    // Builds a 256x256 shading table with 32 levels for each light.
extern void VSCLR_BuildShadeTable(VSCLR_PRGBInfo rgbi,
                                  VSCLR_TPixel *tbl, const byte *pal);


#ifdef __cplusplus
}
#endif

#endif

// ---------------------------- VSCLRTB.H -----------------------
