#if 0
// ---------------------------- VSDEPTHL.C -----------------------
// VSpace library
// Written by Javier Arvalo Baeza.
// Defines a list of elements ready for ordering, drawing, etc.

#include "vsdepthl.h"
#include <string.h>

    // Specify how much memory and how many elements to handle at one time.
extern bool VSDL_Init(VSDL_PScene s, long maxmem, int maxel) {
    if (s == NULL || maxmem <= 0 || maxel <= 0)
        return FALSE;
    memset(s, 0, sizeof(*s));
    s->mem = (void*)NEW(maxmem);
    if (s == NULL)
        return FALSE;
    s->s1 = (VSDL_PElement*)NEW(maxel*sizeof(*s->s1));
    s->s2 = (VSDL_PElement*)NEW(maxel*sizeof(*s->s2));
    if (s->s1 == NULL || s->s2 == NULL) {
        DISPOSE(s->s1);
        DISPOSE(s->s2);
        DISPOSE(s->mem);
        return FALSE;
    }
    s->maxmem = maxmem;
    s->maxel  = maxel;
    VSDL_Reset(s);

    memset(s->mem, 0, s->maxmem);
    memset(s->s1, 0, s->maxel*sizeof(*s->s1));
    memset(s->s2, 0, s->maxel*sizeof(*s->s2));

    return TRUE;
}

    // Free mem, etc.
extern void VSDL_End(VSDL_PScene s) {
    if (s != NULL) {
        DISPOSE(s->s1);
        DISPOSE(s->s2);
        DISPOSE(s->mem);
        memset(s, 0, sizeof(*s));
    }
}

    // Reset current counters: empty the scene.
extern void VSDL_Reset(VSDL_PScene s) {
    if (s != NULL) {
        s->memused  = 0;
        s->nel      = 0;
        s->mindepth = 0;
        s->maxdepth = 0;
//        memset(s->mem, 0, s->maxmem);
//        memset(s->s1, 0, s->maxel*sizeof(*s->s1));
//        memset(s->s2, 0, s->maxel*sizeof(*s->s2));
    }
}

    // Allocate new element from the scene array.
extern VSDL_PElement VSDL_Add(VSDL_PScene s, dword depth, int type, int size) {
    VSDL_PElement e;

    if (s == NULL || s->memused >= s->maxmem || s->nel >= s->maxel || size <= sizeof(VSDL_TElement))
        return NULL;
    if ((s->memused + size) > s->maxmem)
        return NULL;
    if (depth > s->maxdepth)
        s->maxdepth = depth;
/*
    if (depth < s->mindepth)
        s->mindepth = depth;
*/
    e = (VSDL_PElement)(((byte*)s->mem) + s->memused);
    s->s1[s->nel] = e;
    s->memused += size;
    s->nel++;
    e->type  = type;
    e->depth = depth;
    return e;
}


    // Range is [ min , max )
    // OJO: return value inhibits buggy tail recursion optimization!!??!?!?!
PRIVATE int SortRange(int min, int max, dword bit,
                      VSDL_PElement *dest, VSDL_PElement *src) {
    int s = min, e = max;

        // Order ranges.
    {
        int i = e - s;
        VSDL_PElement *ps = src + s;

        while (i > 0) {
            if ((*ps)->depth & bit) dest[--max] = (*ps);
            else                    dest[min++] = (*ps);
            i--;
            ps++;
        }
    }
        // Order subranges.
    bit = bit >> 1;
    if (bit > 0) {
            // sort dest into src (!)
        if (s+1 < min)      // If range bigger than 1 to order
            SortRange(s, min, bit, src, dest);
        else if (s+1 == min)
            src[s] = dest[s];
        if (max+1 < e)      // If range bigger than 1 to order
            SortRange(max, e, bit, src, dest);
        else if (max+1 == e)
            src[max] = dest[max];
    }
    return min;
}

    // Order pointers to elements into the s1 array.
extern void VSDL_Order(VSDL_PScene s) {
    if (s != NULL && s->nel > 0) {
        dword b = (dword)(1 << 31);
//        s->maxdepth -= s->mindepth;
        while (b > 0 && b > s->maxdepth)
            b = b >> 1;
        if (b > 0) {
/*
            VSDL_PElement *pe;
            int i, m;

            m = s->mindepth;
            pe = s->s1;
            for (i = s->nel; i > 0; i--, pe++)
                (*pe)->depth -= m;
*/
                // Sort l1 into l2.
            SortRange(0, s->nel, b, s->s2, s->s1);
                // Swap buffers if odd number of passes.
            {
                int n = 0;
                while (b > 0) {
                    b = b >> 1;
                    n++;
                }
                if (n&1) {
                    VSDL_PElement *t;
                    t = s->s1;
                    s->s1 = s->s2;
                    s->s2 = t;
                }
            }
        }
    }
}


// ---------------------------- VSDEPTHL.C -----------------------
#endif