// ------------------------ VSFILE.H ---------------------------
// For use with Watcom C 9.5 and DOS4GW
// (C) Copyright 1993-4 by Jare & JCAB of Iguana-VangeliSTeam.

#ifndef _VSFILE_H_
#define _VSFILE_H_

#ifndef _VSBASE_H_
#include "vsbase.h"
#endif

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#define VSF_MAXFILES 20


extern bool   VSF_Init    (const char *name);
extern void   VSF_Done    (void);
extern sint32 VSF_FileSize(const char *name);
extern sint32 VSF_Load    (const char *name, void *buf, sint32 maxsize);
extern FILE  *VSF_Open    (const char *name);
extern FILE  *VSF_OpenText(const char *name);
extern void   VSF_Close   (FILE *h);

extern int VSF_GetNLibs(void);
extern int VSF_GetNFiles(void);

#ifdef __cplusplus
}
#endif

#endif

// ------------------------ VSFILE.H ---------------------------
