// ------------------------- VSPOLY.H ------------------------------
// VSpace library
// Designed and written by Javier Arvalo Baeza.
// Polygon drawing and handling.

#if 0
#ifndef _VSVSPLY_H_
#define _VSVSPLY_H_

#ifndef _VSBASE_H_
#include "vsbase.h"
#endif

#include "vstmap.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef sint32 VSPCoord;
typedef float  VSPFloat;

typedef struct {
    VSPCoord px, py;
    VSPFloat l, r, g, b;
    VSPFloat tx, ty;
    VSPFloat z;
} VSPLY_TPolyPoint, *VSPLY_PPolyPoint;

typedef struct {
    char name[8];   // Filename of texture.
    dword flags;    // Texture flags.
    int   w, h;     // Dimensions in 2's powers: are really 1<<w and 1<<h.
    dword mask;     // Mask depending on texture dimensions.
    byte *pix;      // Pointer to actual texture map memory.
} VSPLY_TTexture, *VSPLY_PTexture;

typedef struct {
    float r, g, b;  // RGB values.
    dword c;        // Four pixel pattern (really all the same, but premade).
    dword flags;    // Material flags.
    float selflit;  // Self-illumination factor.
    VSPLY_PTexture tex; // Texture
} VSPLY_TMaterial, *VSPLY_PMaterial;

    // A complete polygon, for your ease to store it fully. This module
    // doesn't use this structure.
typedef struct {
    VSPCoord minx, miny, maxx, maxy;
    VSPFloat minz, maxz;
    VSPLY_PMaterial mat;
    int nverts;
} VSPLY_TPolyHeader, *VSPLY_PPolyHeader;

typedef struct {
    union {
        VSPLY_TPolyHeader h;
        struct {
            VSPCoord minx, miny, maxx, maxy;
            VSPFloat minz, maxz;
            VSPLY_PMaterial mat;
            int nverts;
        };
    };
    VSPLY_TPolyPoint points[1];
} VSPLY_TPoly, *VSPLY_PPoly;

    // ----------------- Conversion from logical to screen coordinates.
    // These MUST be macros, so we can initialize global vars.

#define VSPLY_POINTPOS (16)
//#define VSPLY_Scr2Pix(a) (((a) + (1 << 15)) >> 16)
#define VSPLY_Scr2Pix(a) (((a)) >> VSPLY_POINTPOS)
#define VSPLY_Pix2Scr(a) (((a))*(1 << VSPLY_POINTPOS))

    // --------- Flag bits for both Materials and others.
enum {
        // Light/shading options. Some will remain unimplemented forever.
    VSPLYMF_FLAT  = 0x0000,
    VSPLYMF_LIGHT = 0x0001,
    VSPLYMF_GOUR  = 0x0002,
    VSPLYMF_PHONG = 0x0003,
    VSPLYMF_NORGB = 0x0008,
    VSPLYMF_LIGHTMASK = 0x000F,

        // Texture options.
    VSPLYMF_NOTEX = 0x0000,
    VSPLYMF_TEX   = 0x0010,
    VSPLYMF_TEXMASK = 0x00F0,

        // Material flags
    VSPLYMF_BLEND25 = 0x0100,
    VSPLYMF_BLEND50 = 0x0200,
    VSPLYMF_BLEND75 = 0x0300,

    VSPLYMF_HOLES   = 0x1000,
    VSPLYMF_ENVMAP  = 0x2000,

    VSPLYDF_DUMPMASK = 0xFFFF,

        // These are only for Trace and other internal uses.
    VSPLYTF_EDGE = 0x10000,      // Trace edge values (always set for Trace).
    VSPLYTF_Z    = 0x20000,      // Trace Z values.
    VSPLYTF_TRI  = 0x40000,      // Polygon is a triangle.

    VSPLYDF_ZCORR = 0x80000,     // Do perspective correction?
};

    // --------------------------------
    // Clipping region.

extern VSPCoord VSPLY_MinX, VSPLY_MaxX, VSPLY_MinY, VSPLY_MaxY;

    // Specialized clipping on a per scan basis, each scan has its
    // own x limits (should always be in the above limits). Has as
    // many entries as VSPLY_Scr2Pix(VSPLY_MaxY) - VSPLY_Scr2Pix(VSPLY_MinY).
typedef struct {
    VSPCoord x0, x1;
} VSPLY_TClipScan, *VSPLY_PClipScan;

extern const VSPLY_TClipScan *VSPLY_ClipScans;

    // ------------------------------
    // Low level texturing function to use.

extern VSTM_PDumpFunc VSPLY_DumpFunc;

    // ----------------------------------------------
    // Dumpers (high level).

extern void VSPLY_DumpShade(VSTM_TPixel *dest, dword offs,
                            VSPLY_PPolyPoint poly, int nverts,
                            int minyi, dword flags);

extern void VSPLY_DumpShadeTex(VSTM_TPixel *dest, dword offs,
                               VSPLY_PPolyPoint poly, int nverts,
                               int minyi, dword flags);

extern void VSPLY_DumpZShadeTex(VSTM_TPixel *dest, dword offs,
                                VSPLY_PPolyPoint poly, int nverts,
                                int minyi, dword flags);

    // ----------- High level thing.

    // TRUE -> something was "most probably" drawn.
extern bool VSPLY_DrawPoly(VSTM_TPixel *dest, dword offs,
                           VSPLY_PPolyPoint poly, int nverts,
                           VSPLY_PMaterial mat, dword flags);

// ---------------

extern void VSPLY_SelectDumper(bool tex, bool rgb, bool blend);

#ifdef __cplusplus
}
#endif

#endif

// ------------------------- VSPOLY.H ------------------------------

#endif