#if 0
// ------------------------- VSPOOLS.H ------------------------------
// VSpace library
// Designed and written by Javier Arvalo Baeza.
// Object, material and texture pools.

#ifndef _VSPOOLS_H_
#define _VSPOOLS_H_


#include "vsbitmap.h"
#include "vsobject.h"
#include "vsmpool.h"
#include "vsnamel.h"

#ifdef __cplusplus
extern "C" {
#endif


extern VSNL_TNameTree VSPOOL_TexturePool;
extern VSNL_TNameTree VSPOOL_MaterialPool;
extern VSNL_TNameTree VSPOOL_ObjectPool;
extern VSNL_TNameTree VSPOOL_BitmapPool;

enum {
    VSPOOL_MINPOWER = 4,
    VSPOOL_MAXPOWER = 8,
    VSPOOL_MINSIZE  = (1 << VSPOOL_MINPOWER),
    VSPOOL_MAXSIZE  = (1 << VSPOOL_MAXPOWER),
    VSPOOL_NPOWERS = VSPOOL_MAXPOWER - VSPOOL_MINPOWER + 1,
};

extern VSMP_PPool VSPOOL_TextureMemory[VSPOOL_NPOWERS][VSPOOL_NPOWERS];

// -----------------------

typedef struct {
    dword w, h;
    dword flags;
    dword unused[6];
    dword magic;
} VSPOOL_TTextureHeader;

enum {
    VSPTM_MAGIC = 0x2E591A2C,
};

extern bool VSPOOL_Init(void);

extern void VSPOOL_End(void);

extern byte *VSPOOL_NewTexture(int w, int h, void **addr);

extern void VSPOOL_FreeTexture(void *addr);

// -------

extern VSPLY_PTexture VSPOOL_LoadTexture(const char *fname);
extern VSO_PObj       VSPOOL_LoadObject(const char *fname);
extern VSB_PBitmap    VSPOOL_LoadBitmap(const char *fname);

#ifdef __cplusplus
}
#endif


#endif

// ------------------------- VSPOOLS.H ------------------------------
#endif