#if 0
// ---------------------------- VSTGA.C -----------------------
// VSpace library
// Written by Javier Arvalo Baeza.
// 24-bit TGA screen writer.

#include "vstga.h"

#include <stdio.h>
#include <string.h>

#pragma pack(1)

typedef struct {
    byte id;
    byte cmapt;
    byte imgtype;
    word cmstart;
    word cmlen;
    byte cmdepth;
    word xoffs;
    word yoffs;
    word width;
    word height;
    byte bpp;
    byte imgd;
} TGAHeader;

typedef struct {
    dword extoffs;
    dword devoffs;
    char sig[18];
} TGAFooter;

typedef struct {
    word size;
    char author[41];
    char comment[324];
    word stampmonth;
    word stampday;
    word stampyear;
    word stamphour;
    word stampmin;
    word stampsec;
    char jobname[41];
    word jobhour;
    word jobmin;
    word jobsec;
    char softid[41];
    word version;
    byte versionletter;
    dword key;
    word pixelnum;
    word pixelden;
    word gammanum;
    word gammaden;
    dword coloroffs;
    dword stampoffs;
    dword scanoffs;
    byte attrtype;
} TGAExtension;

#pragma pack()

extern void VSTGA_SavePic(const char *fname, VSV_TViewport *vp, int w, int h) {
    FILE *of;
    TGAHeader hdr;
    TGAFooter foot;
    TGAExtension ext;
    int i, j;
    VSV_TPixel *p;

    of = fopen(fname, "wb");
    if (of == NULL)
        goto bye;
    memset(&hdr, 0, sizeof(hdr));
    hdr.imgtype = 2;
    hdr.width = w;
    hdr.height = h;
    hdr.bpp = 24;
    fwrite(&hdr, sizeof(hdr), 1, of);
    for (i = 0; i < h; i++) {
        p = vp->pix + vp->offs*(h - i - 1);
        for (j = 0; j < w; j++) {
            fputc((*p & 0x3FC)   >> 2, of);         // Blue
            fputc((*p & 0xFF000) >> 12, of);
            fputc((*p & 0x3FC00000) >> 22, of);     // Red
            p++;
        }
    }
    foot.extoffs = 0; //ftell(of);
    foot.devoffs = 0;
    strcpy(foot.sig, "TRUEVISION-XFILE.");
/*
    memset(&ext, 0, sizeof(ext));
    ext.size = sizeof(ext);
    sprintf(ext.author, "%-40s", "Jare/Iguana TGA writer");
    ext.scanoffs = foot.extoffs + ext.size;
    fwrite(&ext, sizeof(ext), 1, of);
    for (i = 0; i < h; i++) {
        dword v;
        v = sizeof(hdr) + 3*w*(h - i - 1);
        fwrite(&v, sizeof(v), 1, of);
    }
*/
    fwrite(&foot, sizeof(foot), 1, of);
  bye:
    if (of != NULL)
        fclose(of);
}

// ---------------------------- VSTGA.C -----------------------
#endif