// ---------------------------- VSTMAP.H -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Vars and functions for the low-level rendering functions.

#define VSTM_ANBIT (5)
#define VSTM_ANLEV (1 << VSTM_ANBIT)

typedef dword VSTM_TPixel;

extern dword VSTM_APos, VSTM_AInc;
extern dword VSTM_RPos, VSTM_RInc;
extern dword VSTM_GPos, VSTM_GInc;
extern dword VSTM_BPos, VSTM_BInc;
extern dword VSTM_UPos, VSTM_UInc;
extern dword VSTM_VPos, VSTM_VInc;

extern dword VSTM_Dither;       // bool value

extern byte *VSTM_TexturePtr;

extern dword VSTM_TextureMask;

static VSTM_TPixel VSTM_AlphaTbl[VSTM_ANLEV][256];


#if 0
#ifndef _VSTMAP_H_
#define _VSTMAP_H_

#ifndef _VSBASE_H_
#include "vsbase.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define VSTM_MAKEPIX(r,g,b) ((((byte)(r)) << 22) | (((byte)(g)) << 12) | (((byte)(b)) << 2))

extern dword VSTM_AddPixelSafe(dword scr, dword add);
#pragma aux  VSTM_AddPixelSafe parm [EAX] [EBX] modify nomemory value [EAX] = \
"   AND     EAX,0x3FCFF3FC " \
"   AND     EBX,0x3FCFF3FC " \
"   ADD     EAX,EBX        " \
"   TEST    EAX,0xC0300C00 " \
"   JZ      @@c3           " \
"   TEST    EAX,0xC0000000 " \
"   JZ      @@c1           " \
"    OR     EAX,0x3FC00000 " \
"@@c1:                     " \
"   TEST    EAX,0x00300000 " \
"   JZ      @@c2           " \
"    OR     EAX,0x000FF000 " \
"@@c2:                     " \
"   TEST    EAX,0x00000C00 " \
"   JZ      @@c3           " \
"    OR     EAX,0x000003FC " \
"@@c3:                     "

extern dword VSTM_SubPixelSafe(dword scr, dword add);
#pragma aux  VSTM_SubPixelSafe parm [EAX] [EBX] modify nomemory value [EAX] = \
"   NOT     EBX            " \
"   AND     EBX,0x7FDFF7FC " \
"   AND     EAX,0x3FCFF3FC " \
"   ADD     EBX,0x00401004 " \
"   ADD     EAX,EBX        " \
"   TEST    EAX,0x40100400 " \
"   JZ      @@c3           " \
"   TEST    EAX,0x40000000 " \
"   JZ      @@c1           " \
"    AND    EAX,0xC03FFFFF " \
"@@c1:                     " \
"   TEST    EAX,0x00100000 " \
"   JZ      @@c2           " \
"    AND    EAX,0xFFF00FFF " \
"@@c2:                     " \
"   TEST    EAX,0x00000400 " \
"   JZ      @@c3           " \
"    AND    EAX,0xFFFFFC03 " \
"@@c3:                     "



    // -------------
    // Variables

    // Number of alpha levels
#define VSTM_ANBIT (5)
#define VSTM_ANLEV (1 << VSTM_ANBIT)

typedef dword VSTM_TPixel;

extern dword VSTM_APos, VSTM_AInc;
extern dword VSTM_RPos, VSTM_RInc;
extern dword VSTM_GPos, VSTM_GInc;
extern dword VSTM_BPos, VSTM_BInc;
extern dword VSTM_UPos, VSTM_UInc;
extern dword VSTM_VPos, VSTM_VInc;

extern dword VSTM_Dither;       // bool value

extern byte *VSTM_TexturePtr;

extern dword VSTM_TextureMask;

extern VSTM_TPixel VSTM_AlphaTbl[VSTM_ANLEV][256];

    // -------------
    // Functions

// Codes for functions: ABCD
// A => Does texturemapping
// B => Does arbitrary-sized textures
// C => Does holed textures
// D => Does alpha (digit indicates alpha level, 4 means average)
// #pragma aux VSTM_DumpScanABCD parm [EAX] [EDX]

typedef void (*VSTM_PDumpFunc)(void *dest, int n);

 // RGB functions.
extern void VSTM_DumpScan0000(void *dest, int n);

extern void VSTM_DumpScan0004(void *dest, int n);

 // Texture functions.
extern void VSTM_DumpScan1000(void *dest, int n);

extern void VSTM_DumpScan1004(void *dest, int n);

extern void VSTM_DumpScan2000(void *dest, int n);

extern void VSTM_DumpScan2004(void *dest, int n);

extern void VSTM_DumpScan1100(void *dest, int n);

extern void VSTM_DumpScan1104(void *dest, int n);

extern void VSTM_DumpScan2100(void *dest, int n);

extern void VSTM_DumpScan2104(void *dest, int n);


#ifdef __cplusplus
}
#endif

#endif

#endif
// ---------------------------- VSTMAP.H -----------------------
