byte guspresent;
int header_size;
int inst_size;
dword h_size;
word pat_size;

long counter;

int row=0;
int pat=0;

word oldvol[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

word n_channel;
word n_pattern;
word n_inst;
word dticks;
byte pat_order[256];
word song_len;
word flags;
word n_row;
byte check;

typedef struct{
				word note; /* have change for amiga note so .... change it */
				byte no;
				byte vol;
				byte effect;
				byte arg;
			   }PAT;
PAT *pattern;

typedef struct {
				 dword len;
				 byte fine;
				 byte volume;
				 dword loopend;
				 dword loopstart;
				 byte loop;
				 byte *data;
				 signed char realnote;
				}HEAD;
HEAD *sample;

typedef struct{
				long startad;
				long endad;
			  }inst;
			  
inst instrument[31];

typedef struct{
				byte nosamp;
				word vol;
				byte effect;
				byte arg;
				word period;
			   }V;
V voice[16];


typedef struct{
				byte no;
				word period;
				byte effect;
				byte argument;
				byte vol;
			  }MODPAT;   
MODPAT *modpattern;
/*float Period[85]={
  1712, 1616,  1525,1440,  1357,  1281,  1209,1141,  1077,   1017, 961,   907,
   856,  808, 762.5, 720, 678.5, 640.5, 604.5, 570, 538.5,  508.5, 480, 453.5,
   428,  404,381.25, 360,339.25, 320.3, 302.3, 285,269.25,  254.3, 240, 226.8,
   214,  202,190.62, 180,170.62,160.25, 151.1, 143,134.62,127.125, 120, 113.4,
   107,  101,95.312,  90, 85.31, 80.06, 75.56,  71, 67.31,  63.56,  60,  56.6,
  53.5, 50.5, 47.65,  45, 42.65, 40.03, 37.78,  35, 33.65,  31,78,  30, 28.34, 
 26.75,25.25, 23.82,22.5, 21.32, 20.01, 18.89,  17, 16.82,  15.89,  15, 14.17};*/

float Period[86]={
1712,1616,1525,1440,1357,1281,1209,1141,1077,1017, 961, 907,
856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453,
428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226,
214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113,
107, 101,  95,  90,  85,  80,  76,  71,  67,  64,  60,  57,
53,  50,  47,  44,  42,  39,  37,  35,  33,  31,  29,  28,
26.5,  25,  23.5,  22,  21,  19.5,  18.5,  17.5,  16.5,  15.5,  14.5,  14};




void loadxm(char *name);
void initgus(int base);
void gusdetect(int base);
void gf1delay(void);
void gf1_byte(int where,byte x);
void gf1_word(int where,word x);
void download(byte *sample, dword len,long startadd);
void setfreq(byte voice,word freq);
void setvol(byte voice,word volume);
void fastsetvol(byte voice,word volume);
void playvoice(word v);
void __interrupt __far timer();
void (__interrupt __far *oldint)();
void settimer (word speed);
void player(void);
void startmusic(void);
void stopmusic(void);
void waitpat(word val, word rw);
void setpan(byte voice,byte arg);
void look(void);



int base=0x220;
byte nticks=6;
byte ticks=255;
byte z=0;


word GUSvol[] = {
	0x1500,
	0x9300,0xA900,0xB400,0xBC00,0xC180,0xC580,0xC980,0xCD80,
	0xCF40,0xD240,0xD440,0xD640,0xD840,0xDA40,0xDC40,0xDE40,
	0xDEF0,0xDFA0,0xE1A0,0xE2A0,0xE3A0,0xE4A0,0xE5A0,0xE6A0,
	0xE7A0,0xE8A0,0xE9A0,0xEAA0,0xEBA0,0xECA0,0xEDA0,0xEEA0,
	0xEEF0,0xEFE0,0xEF60,0xF1E0,0xF160,0xF1E0,0xF260,0xF2E0,
	0xF360,0xF3E0,0xF460,0xF4E0,0xF560,0xF5E0,0xF660,0xF6E0,
	0xF760,0xF7E0,0xF860,0xF8E0,0xF960,0xF9E0,0xFA60,0xFAF0,
	0xFB70,0xFBF0,0xFC70,0xFCF0,0xFD70,0xFD90,0xFDB0,0xFDD0
};


void download(byte *sample,dword len,long startadd)
{
	 for(long i=0;i<len;i++)
		 {   
			 gf1_word(0x43,(i+startadd)&0xffff);
			 gf1_byte(0x44,(i+startadd)>>16);
			 outp(base+0x107,sample[i]);
			 outp(base+0x107,sample[i]);

		 }
}

void synchro(float inc)
{
	incframe=inc;
	frame=0;
}

void waitpat(word val, word rw)
{

	while(pat<val || row<rw)
	{
	look();
	}
}   
	
void playvoice(word v)
{
	
	long stadr=instrument[voice[v].nosamp].startad;
	long enadr=instrument[voice[v].nosamp].endad;
  // faire un fast vol ramp ;
	if(!sample[voice[v].nosamp].loop)
		{
	outp(base+0x102,v);
	gf1delay();
	outp(base+0x102,v);
	gf1_word(2,stadr>>7);
	gf1_word(3,stadr&0x07f);
	gf1_word(0x0a,stadr>>7);
	gf1_word(0x0b,stadr&0x07f);
	gf1_word(4,enadr>>7);
	gf1_word(5,enadr&0x07f);
	outp(base+0x102,v);
	gf1delay();
	outp(base+0x102,v);
	gf1_byte(0,0);

		
		}
		
	else
	  {
		 stadr+=sample[voice[v].nosamp].loopstart;
		 enadr=sample[voice[v].nosamp].loopend+stadr-1;
	     outp(base+0x102,v);
	     gf1delay();
	     outp(base+0x102,v);
		 gf1_word(2,stadr>>7);
		 gf1_word(3,stadr&0x07f);
		 gf1_word(0x0a,stadr>>7);
		 gf1_word(0x0b,stadr&0x07f);
		 gf1_word(4,enadr>>7);
		 gf1_word(5,enadr&0x07f);
		 outp(base+0x102,v);
		 gf1delay();
		 outp(base+0x102,v);
		 gf1_byte(0,8);
	  }                                        
}



void __interrupt __far timer()
{ 
	 frame+=incframe;
		 if(ticks>=nticks)
		 {
			 player();
			 ticks=0;
		 }
	   ticks++;

	if(!(counter%3))
		{
			oldint();
		}
   outp(0x20,0x20);  

}


void settimer(word speed)
{
	outp(0x43,0x36);
	outp(0x40,speed);
	outp(0x40,speed>>8);
}

void player(void)
{

	if(row>=n_row)
		{
			row=0;
			pat++;
		}
	
		
		byte no_pat=pat_order[pat];
		byte vol[16];
		if(pat<34)
		  {
			for(int i=0;i<15;i++)
			 {
				 voice[i].nosamp=pattern[no_pat*64*n_channel+row*n_channel+i].no;
				 voice[i].nosamp--;
				 voice[i].period=pattern[no_pat*64L*n_channel+row*n_channel+i].note;
				 voice[i].effect=pattern[no_pat*64*n_channel+row*n_channel+i].effect;
				 vol[i]=pattern[no_pat*64L*n_channel+row*n_channel+i].vol;
				 if(!vol[i])
						voice[i].vol=GUSvol[sample[voice[i].nosamp].volume];
				 
				 voice[i].arg=pattern[no_pat*64*n_channel+row*n_channel+i].arg;

			 }
			if(guspresent)
			{
			for(i=0;i<15;i++)
				{
					
 
					 
					 if(voice[i].period && (voice[i].nosamp+1))
						{  

							long note=(voice[i].period+sample[voice[i].nosamp].realnote);
							if(note>83)note=83;
							char fine=sample[voice[i].nosamp].fine;
								fine/=16.0;
								
								float tf=8363;
								
								if(fine<=-8)tf=7895;
								else
								if(fine<=-7)tf=7941;
								else
								if(fine<=-6)tf=7985;
								else
								if(fine<=-5)tf=8046;
								else
								if(fine<=-4)tf=8107;
								else
								if(fine<=-3)tf=8169;
								else
								if(fine<=-2)tf=8232;
								else
								if(fine<=-1)tf=8280;
								else
								if(fine==0)tf=8363;
								else
								if(fine<=1)tf=8413;
								else
								if(fine<=2)tf=8463;
								else
								if(fine<=3)tf=8529;
								else
								if(fine<=4)tf=8581;
								else
								if(fine<=5)tf=8763;
								else
								if(fine<=6)tf=8757;
								if(tf==0)tf=8363;    
							
							
							voice[i].period=(24900UL/(Period[note]*8363/tf));
							  if(vol[i]>15)
								   voice[i].vol=GUSvol[vol[i]-16];
							fastsetvol(i,0);
//							outp(base+0x102,i);
//							gf1_byte(0,3);
							setfreq(i,voice[i].period);
							   playvoice(i);
							   fastsetvol(i,voice[i].vol);
							  // setvol(i,voice[i].vol);

						}
					
							  if(vol[i]>15 && !(voice[i].period))
								   {
								   voice[i].vol=GUSvol[vol[i]-16];
								   fastsetvol(i,voice[i].vol);
								   }

							
						
							if(voice[i].effect==12) 
							   {
								 //  voice[i].vol=s_table[voice[i].arg]<<4;
								 //  setvol(i,65535);
							   }
							else
							if(voice[i].effect==15)
								 {
								   /* set tempo or set bmp */
								   if(voice[i].arg<0x1f)
									   nticks=voice[i].arg;  
								   else
									   settimer(1193180/(2*voice[i].arg/5));
								 }       
							else
							if(voice[i].effect==13)
								  {
									   /* pattern break */
									   row=voice[i].arg-1;
									   if(voice[i].arg>63)row=-1;
									   pat++;
									   outp(base+0x102,i);
									   gf1_byte(0,2);
								  }
//                          else
//                          if(voice[i].effect==8)
 //                                  setpan(i,voice[i].arg>>4);
							
									   
				}
	  }
		}
	else
		for(int i=0;i<n_channel;i++)
				setvol(i,0);
	
row++;
}

void setpan(byte voice,byte arg)
{
	  outp(base+0x102,voice);
	  gf1_byte(0x0c,arg);
}

void gf1_byte(int where,byte x)
{
	 outp(base+0x103,where);
	 outp(base+0x105,x);


}



void gf1_word(int where,word x)
{
	 outp(base+0x103,where);
	 outpw(base+0x104,x);
}




void initgus(int base)
{
  outp(base+0x103,0x4c); //reset register;
  outp(base+0x105,0x00); // write a zero.. 
  for(int i=0;i<10;i++) gf1delay();
  
  outp(base+0x103,0x4c); //
  outp(base+0x105,0x01); // enable the output and run bit

  for(i=0;i<10;i++) gf1delay();
  
  outp(base+0x103,0x4c); //
  outp(base+0x105,0x03); // enable the output and run bit

   for(i=0;i<10;i++) gf1delay();
  
  outp(base+0x103,0x4c); //
  outp(base+0x105,0x07); // enable the output and run bit
  
   outp(base,1);
   gf1_byte(0x4c,3);       // fouille moi ?
  
  
  outp(base+0x103,0x0e);
  outp(base+0x105,16|0xC0);
	
	
	  
	  
	  for(i=0;i<n_channel;i++)
			{
			outp(base+0x102,i);
			gf1_byte(0,2);
			setvol(i,0);
			}
			
  for(i=0;i<n_channel;i++)
	  {
		outp(base+0x102,i);
		gf1_byte(0,1);
	   }
	  
mode3();
byte *texte=(byte *)0x0b8000;
byte te[17]="Loading Music [";
for(i=0;i<15;i++)
	 texte[i*2]=te[i];
texte[i*2+(n_inst-1)*2]=']';

			
  for(i=0;i<n_inst;i++)
	 {
		if(i!=0)
		{
		instrument[i].startad=instrument[i-1].endad;
		instrument[i].endad=instrument[i].startad+sample[i].len;
		}
		else
		{
		instrument[0].startad=0;
		instrument[0].endad=sample[i].len;
		}
	 download(sample[i].data,sample[i].len,instrument[i].startad);
	 texte[i*2+30]='';
	 delete sample[i].data;
	}
	

/*set stereo */
	  outp(base+0x102,0);
	  	  outp(base+0x102,0);
	  	  	  outp(base+0x102,0);


	  gf1_byte(0x0c,2);
	  
	  outp(base+0x102,1);
	  	  outp(base+0x102,1);
	  	  	  outp(base+0x102,1);


	  gf1_byte(0x0c,13);
	  
	  outp(base+0x102,2);
	  	  outp(base+0x102,2);
	  	  	  outp(base+0x102,2);


	  gf1_byte(0x0c,13);
	  
	  outp(base+0x102,3);
	  	  outp(base+0x102,3);
	  	  	  outp(base+0x102,3);


	  gf1_byte(0x0c,2);
	  
	  outp(base+0x102,4);
	  	  outp(base+0x102,4);
	  	  	  outp(base+0x102,4);


	  gf1_byte(0x0c,2);
	  
	  outp(base+0x102,5);
	  	  outp(base+0x102,5);
	  	  	  outp(base+0x102,5);


	  gf1_byte(0x0c,13);
	  
	  outp(base+0x102,6);
	  	  outp(base+0x102,6);
	  	  	  outp(base+0x102,6);

      gf1_byte(0x0c,13);
	  
	  outp(base+0x102,7);
	  outp(base+0x102,7);
	  outp(base+0x102,7);


	  gf1_byte(0x0c,2);
	  
	  outp(base+0x102,8);
	  outp(base+0x102,8);
	  outp(base+0x102,8);


	  gf1_byte(0x0c,2);
	  
	  outp(base+0x102,9);
	  outp(base+0x102,9);
	  outp(base+0x102,9);


	  gf1_byte(0x0c,13);
	  
	  outp(base+0x102,10);
	  outp(base+0x102,10);
	  outp(base+0x102,10);


	  gf1_byte(0x0c,13);
	  
	  outp(base+0x102,11);
	  outp(base+0x102,11);
	  outp(base+0x102,11);


	  gf1_byte(0x0c,2);
	  
	  outp(base+0x102,12);
      outp(base+0x102,12);
      outp(base+0x102,12);

	  
	  gf1_byte(0x0c,2);
	  
	  outp(base+0x102,13);
	  outp(base+0x102,13);
	  outp(base+0x102,13);


	  gf1_byte(0x0c,13);
	  
	  outp(base+0x102,14);
	  outp(base+0x102,14);
	  outp(base+0x102,14);


	  gf1_byte(0x0c,13);
	  
	  outp(base+0x102,15);
	  outp(base+0x102,15);
	  outp(base+0x102,15);
	  
	  gf1_byte(0x0c,2);


	  
}                
	  
					 
void gf1delay(void)
{
void gf1delaya(void);
#pragma aux gf1delaya=\
   "mov dx,0330h "\
   "in ax,dx     "\
   "in ax,dx     "\
   "in ax,dx     "\
   "in ax,dx     "\
   "in ax,dx     "\
   "in ax,dx     "\
   "in ax,dx     "\
modify exact [eax ebx] nomemory;
gf1delaya();            
}

void fastsetvol(byte voice,word volume)
{
	volume/=1.16;
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	gf1_word(9,volume);
/*	
	if(oldvol[voice]<volume)
	{
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	byte amount=255;
	gf1_byte(6,amount);
	gf1_byte(7,(oldvol[voice])>>8);
	gf1_byte(8,(volume)>>8);
	}
	else
	{
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	byte amount=255;
	gf1_byte(6,amount);
	gf1_byte(7,(volume)>>8);
	gf1_byte(8,(oldvol[voice])>>8);
	} 
	
    
	     outp(base+0x102,voice);
	     gf1_byte(0x0d,0);
	 
oldvol[voice]=volume;*/

 }


void setvol(byte voice,word volume)
{
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	gf1_word(9,volume);
	oldvol[voice]=volume;
}


void setfreq(byte voice,word freq)
{
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	outp(base+0x102,voice);
	gf1_word(1,freq);
}
	

void startmusic(void)
{ 
//		settimer(23865);
		settimer(23900);

		oldint = _dos_getvect(0x08);
		_dos_setvect(0x08, timer);
}

void stopmusic(void)
{
  for(int i=0;i<n_channel;i++)
	  {
		outp(base+0x102,i);
		gf1_byte(0,1);
	   }
  _dos_setvect(0x08, oldint);
  settimer(65535);
}



void loadxm(char *fname)
{
   FILE *entree;
   entree=fopen(fname,"rb");
   fseek(entree,60,0);
   fread(&header_size,4,1,entree); /* header size from this offset */ 
   
   fseek(entree,68,0);
   fread(&n_channel,2,1,entree); /* number of channel */
   
   fread(&n_pattern,2,1,entree); /* number of pattern to be played */
   
   fread(&n_inst,2,1,entree); /* number of instruments */
   
   fread(&flags,2,1,entree); /* flags if 0 amiga freq else linear freq */
   
   fseek(entree,80,0);
   fread(pat_order,256,1,entree);  /* pattern order*/ 
   
   header_size+=60;   
   
pattern = new PAT [n_pattern*64L*n_channel*6];

PAT temp;


  /* well lets depack the pattern... */
long add=0;
byte compression;  

fseek(entree,header_size,0);  /* number of row by pattern */

  for(int i=0;i<n_pattern;i++)
{  

   

   long bi=0;
   int j,k;

   fread(&h_size,4,1,entree);

   fseek(entree,1,1);
   fread(&n_row,2,1,entree);
   fread(&pat_size,2,1,entree);  /* if zero , no pattern */
   
   fseek(entree,h_size-9L,1);
   fread(&check,1,1,entree);

	 for(j=0;j<n_row;j++)
	  {
		for(k=0;k<n_channel;k++)
			{
				/* lets decode */
				compression=check;
				pattern[add].note=0;
				pattern[add].vol=0;
				pattern[add].effect=0;
				pattern[add].no=0;
				pattern[add].arg=0;
				if(compression&0x80)
					{
						
						/* ce n'est pas la note et le patatlen */
						/* mais on c<est pas quoi */
						fread(&check,1,1,entree); /* read the byte */
						bi++;
						compression&=0x7f;
						
					}
			   else {
					 /* tous est la car c'est une note */
					 /*enable all bit */
					 compression=0x7f;
					}
					
			  if(compression & 1)
				  {
					  pattern[add].note=check;
					  fread(&check,1,1,entree);
					  bi++;
				  }
			  if(compression & 2)
				  {
					  pattern[add].no=check;
					  fread(&check,1,1,entree);
					  bi++;
				  }
			  if(compression & 4)
				  {
					  pattern[add].vol=check;
					  fread(&check,1,1,entree);
					  bi++;
				  }
			  if(compression & 8)
				  {
					  pattern[add].effect=check;
					  fread(&check,1,1,entree);
					  bi++;
				  }
			  if(compression & 16)
				  {
					  pattern[add].arg=check;
					  fread(&check,1,1,entree);
					  bi++;
				  }
				
			  add++;
		  }
	   }

	fseek(entree,-1L,1);
//  printf("\n I read %d pieces... and the number is %d ",bi,pat_size);

}               
				
		 
/* He, Then read the instruments .... */
/* opps, alocate some memory first */

///int lenght=sizeof(HEAD)*n_inst;
sample = new HEAD [n_inst];
   
   byte name[22];
   word number=0;
   byte type;
   byte c=0;
   
/* well 32 et 11 ... ??? */

for(int ii=0;ii<n_inst;ii++)
{   
   fread(&inst_size,4,1,entree);
   fread(name,22,1,entree);
   fread(&type,1,1,entree);
   fread(&number,2,1,entree);
//   printf("\n %s",name);
   if(number!=0)
	   fseek(entree,(inst_size-29)*number,1);
for(i=0;i<number;i++)
{
fread(&sample[ii].len,4,1,entree);
fread(&sample[ii].loopstart,4,1,entree);
fread(&sample[ii].loopend,4,1,entree);
fread(&sample[ii].volume,1,1,entree); 
fread(&sample[ii].fine,1,1,entree);
fread(&sample[ii].loop,1,1,entree);
fread(&sample[ii].realnote,1,1,entree);
fread(&sample[ii].realnote,1,1,entree);


fseek(entree,23,1); // total de 40-13 
sample[ii].data=new byte [sample[ii].len];
fread(sample[ii].data,sample[ii].len,1,entree);

byte old=0;
byte news;

for(int k=0;k<sample[ii].len;k++)
	{
	   news=sample[ii].data[k]+old;
	   sample[ii].data[k]=news;
	   old=news;
	}
}
}


}




	  
   
