; surprise.asm
; LTP'97 suprise coding competition.
;
; Coded by Lin Ke-Fong (Calimero/Enigma).
;
; Source donated to public domain.
;
; To compile (I have included a batch file):
;    tasm -ml -m9 surprise
;    tlink -tdc surprise

.model tiny
.386

SCREEN_WIDTH   equ 320
SCREEN_HEIGHT  equ 200
SCREEN_SEGMENT equ 0A000h
SUPER_MODE     equ 13h
CRTC_STATUS    equ 3DAh
COLOR          equ 15

.data


wait_flag      db 0            ; if not 1 do not wait vertical retrace
snake_stuff    dw 0            ; stuff


.code

       org 100h

main proc near

       mov     al, 13h
       int     10h

       mov     ax, SCREEN_SEGMENT
       mov     es, ax

       mov     bp, offset draw
       mov     si, offset move_it

; draw labyrinth
       mov     di, SCREEN_WIDTH * 20
       mov     ax, 256
       mov     cl, 09h
       mov     ebx, (SCREEN_WIDTH shl 16) + 01
       call    si

       mov     byte ptr [wait_flag], 1

       xor     ax, ax
       int     16h

       and     al, 011b
       dec     al
       jnz     b2a

a2b:
       mov     word ptr [snake_stuff], 4
       mov     di, SCREEN_WIDTH * 18
       mov     ax, 256 + 2
       mov     cx, 11
       mov     ebx, (SCREEN_WIDTH shl 16) + 01
       call    si
       jmp     main_end

b2a:
       mov     word ptr [snake_stuff], -4
       mov     word ptr [patch], 0C003h
       mov     byte ptr [jump_patch], 75h
       mov     di, 08CA4h + 3 - 320 - 320
       mov     ax, 0Ch
       mov     cx, 11
       mov     ebx, ((-SCREEN_WIDTH) shl 16) + 1
       call    si

main_end:
       xor     ax, ax
       int     16h

       mov     ax, 03h
       int     10h

       ret

main endp


move_it proc near

move_loop:
       mov     dx, bx
       call    bp
       neg     bx

       ror     ebx, 16

       test    cl, 1

jump_patch:
       jz      no_adjust

patch:
       shr     ax, 1
       add     ax, [snake_stuff]

no_adjust:
       loop    move_loop

       ret

move_it endp


draw proc near
; ax : number of pixels to draw
; dx : delta

       push    ax

draw_loop:
       mov     byte ptr es:[di], COLOR
       add     di, dx

       cmp     byte ptr [wait_flag], 1
       jne     no_wait

       push    dx
       push    ax

       mov     dx, CRTC_STATUS

wait1:
       in      al, dx
       test    al, 08h
       jnz     wait1

wait2:
       in      al, dx
       test    al, 08h
       jz      wait2

       pop     ax
       pop     dx

no_wait:
       dec     ax
       jnz     draw_loop

       pop     ax

       ret

draw endp

end main
