/*
 Ŀ
  FILE        : harry.c                  VERSION : 1.1     DATE : 11/07/1998 
  DESCRIPTION : Harry controlFuntions                                        
                                                                             
 Ĵ
  Copyright (C) 1998 by Yannick Suter aka AsC/Nowadays                       
 
*/

#include "libs/header.h"

//extern unsigned long PAD;

void controlHARRY(int ind)
{
  int left,right;

  if(!harry[ind].delay)
  {

    if((PAD[ind] & PADsquare) && !harry[ind].hit && !harry[ind].jump){
        harry[ind].hit = 1;
    }

    if((PAD[ind] & PADleft) && !harry[ind].hit) {
        if(jump_h[harry[ind].jumpind]>48) check_boundary2(ind,&left,&right,1);
        else check_boundary2(ind,&left,&right,0);
        if (left!=6) harry[ind].x-=3;

        harry[ind].walk = 1;
        harry[ind].direction = 1;
        harry[ind].walkframe = ((harry[ind].walkframe++) > 2) ? 1 : harry[ind].walkframe;
    }

    if((PAD[ind] & PADright) && !harry[ind].hit) {
        if(jump_h[harry[ind].jumpind]>48) check_boundary2(ind,&left,&right,1);
        else check_boundary2(ind,&left,&right,0);
        if (right!=6) harry[ind].x+=3;

        harry[ind].walk = 1;
        harry[ind].direction = 0;
        harry[ind].walkframe = ((harry[ind].walkframe++) > 2) ? 1 : harry[ind].walkframe;
    }

    if((PAD[ind] & PADcross) && !harry[ind].jump){
        harry[ind].jump = 1;
        harry[ind].jumpind = 0;
        harry[ind].wolke = 0;
    }

    if(harry[ind].jump){
        harry[ind].jumpind++;

        if(harry[ind].jumpind == (jumpmax_steps-1))
            { harry[ind].jump=0; harry[ind].jumpind=0; harry[ind].jumpframe=0; }

        if(harry[ind].jumpind >= jumpmax_frame){
             harry[ind].jumpframe = 1;
             nmeHIT_bird(ind);
        };

        harry[ind].blocks = defBLOCK(ind);

    } else {
        harry[ind].blockIND = -1;

        check_boundary(ind,&left,&right);
        if((left == 4) || (right == 4)) harry[ind].x--;
        if((left == 5) || (right == 5)) harry[ind].x++;
    }

    if(!PAD[ind]) harry[ind].walk = 0;

    if(harry[ind].hit){
         harry[ind].hitframe++;
         if(harry[ind].hitframe==4){
                harry[ind].hit=0;
                harry[ind].hitframe=0;
         }

         nmeHIT_pingu(ind);
         nmeHIT_bird(ind);
    }

    // calculate the real position of harry! - set jump,hit etc.
    def_HarryPos(ind);

    harry[ind].delay = harry_nomal;

  }else harry[ind].delay--;


  if(!harry[ind].jump) {
         check_boundary(ind,&left,&right);

         if(!harry[ind].wolke){
              switch(harry[ind].direction)
              {
                case 0: { if(right>9)
                          {
                                harry[ind].wolke = 1;
                                harry[ind].wolke_id = right-10;
                          };
                          break;
                        }
                case 1: { if(left>9)
                          {
                                harry[ind].wolke = 1;
                                harry[ind].wolke_id = left-10;
                          }
                          break;
                        }
              }
         } else {
              switch(harry[ind].direction)
              {
                case 0: { if(right>9){
                                harry[ind].wolke = 1;
                                harry[ind].wolke_id = right-10;
                          }
                          else if(right!=0) harry[ind].wolke = 0;

                          break;
                        }
                case 1: { if(left>9) {
                                harry[ind].wolke = 1;
                                harry[ind].wolke_id = left-10;
                          } else if(left!=0) harry[ind].wolke = 0;

                          break;
                        }
              }
         }

   }

  if(harry[ind].wolke) {
        switch(d_wolke[harry[ind].wolke_id].dir){
            case 0: {   harry[ind].x += wolkenSPEED; break;}
            case 1: {   harry[ind].x -= wolkenSPEED; break;}
        }
  }

}

void nmeHIT_pingu(int ind)
{
    RECT pinguu;
    RECT hardd;
    int x;

    hardd.x = harry[ind].x-3;
    hardd.y = harry[ind].y;
    hardd.w = 21+2;
    hardd.h = 28;

    for(x=0;x<numPINGU;x++){
            pinguu.x = pin[x].x;
            pinguu.y = pin[x].y;
            pinguu.w = 16;
            pinguu.h = 16;

         if(RectanglesOverlap(&hardd,&pinguu))
         {

            if(pin[x].dir != harry[ind].direction) {

                         pin[x].state = 2;
                         pin[x].ice = 0;
                         pin[x].naz = 1;
                         if(pin[x].dir != harry[ind].direction)
                         pin[x].dir = (pin[x].dir == 1) ? 0: 1;

            } else {

                switch(pin[x].dir){
                    case 0 : {
                                if(pin[x].x > harry[ind].x)
                                {

                         pin[x].state = 2;
                         pin[x].ice = 0;
                         pin[x].naz = 1;
                         if(pin[x].dir != harry[ind].direction)
                         pin[x].dir = (pin[x].dir == 1) ? 0: 1;

                                }
                                break;
                             }
                    case 1 : {
                                if(pin[x].x < harry[ind].x)
                                {

                         pin[x].state = 2;
                         pin[x].ice = 0;
                         pin[x].naz = 1;
                         if(pin[x].dir != harry[ind].direction)
                         pin[x].dir = (pin[x].dir == 1) ? 0: 1;

                                }
                                break;
                             }
                }
            }
         } // !hit
    }
}

void nmeHIT_bird(int ind)
{
    RECT birdd;
    RECT hardd;
    int x;

    hardd.x = harry[ind].x - 5;
    hardd.y = harry[ind].y - jump_h[harry[ind].jumpind] + 6;
    hardd.w = 25;
    hardd.h = 12;

    for(x=0;x<numBIRD;x++){
            birdd.x = bird[x].x;
            birdd.y = bird[x].y;
            birdd.w = 16;
            birdd.h = 16;

            if(RectanglesOverlap(&hardd,&birdd) && (bird[x].state != 1))
            if(pin[x].dir != harry[ind].direction) bird[x].state = 1;
            else {

                switch(pin[x].dir){
                    case 0 : {
                                if(pin[x].x > bird[ind].x) bird[x].state = 1;
                                break;
                             }
                    case 1 : {
                                if(pin[x].x < harry[ind].x) bird[x].state = 1;
                                break;
                             }
                }
            }
    }
}

void def_HarryPos(int ind)
{
    int d,blockID;

    // all the jump stuff!!

    if(harry[ind].jump)
    {  if(harry[ind].jumpind == jump_levelup){

          // kann ich einen level steigen?

          if(def_jumpFALL(ind,&blockID) && (harry[ind].actLEVEL+1) != numLEVEL)
          {
                  if(blockID > 9) {
                      harry[ind].wolke    = 1;
                      harry[ind].wolke_id = blockID - 10;
                  } else harry[ind].wolke = 0;

                  harry[ind].jump=0;
                  harry[ind].jumpind=0;
                  harry[ind].jumpframe=0;
                  harry[ind].actLEVEL++;
                  harry[ind].y = ((numLEVEL - harry[ind].actLEVEL - 1)*48) +12;
          }
       }

       if((harry[ind].jumpind == harry[ind].frameNR) && harry[ind].blocks){

                  // hit hock!! I hit da block!!!!! kewl

                  if((level[harry[ind].actLEVEL + 1].art[3-harry[ind].frameNR][harry[ind].blockIND] != 1) && (level[harry[ind].actLEVEL + 1].art[3-harry[ind].frameNR][harry[ind].blockIND] != 6))
                     level[harry[ind].actLEVEL + 1].status[3-harry[ind].frameNR][harry[ind].blockIND] = 0;

                  harry[ind].jumpframe=1;
                  harry[ind].jumpind= 15 + (3-harry[ind].frameNR);
                  harry[ind].delay = harry_hitblock;
       }

    }

    // all the walk stuff

    if(!harry[ind].jump)
    {
          if(def_walkFALL(ind)){
              harry[ind].wolke=0;
              harry[ind].jump=1;
              harry[ind].jumpind=jump_levelup;
              harry[ind].jumpframe=1;
              harry[ind].actLEVEL--;
              harry[ind].y =  ((numLEVEL - harry[ind].actLEVEL - 1)*48) +12;
          }
          else {
            if(harry[ind].knok) {
                harry[ind].knok = 0;
                initHARRY2(ind,100,harry[ind].actLEVEL);
            }
          }
    }

    if(harry[ind].x <= 0) harry[ind].x = 243;
    if(harry[ind].x >= 244) harry[ind].x = 0;
}

int defBLOCK(int ind)
{   int d,iid;

    d = ((harry[ind].x + 4)>>3) + harry[ind].direction;

    iid = harry[ind].actLEVEL+1;
    if(iid == numLEVEL) return(0);

    switch(harry[ind].direction)
    {
    case 0 :{ if(level[iid].status[1][d]) { harry[ind].blockIND = d; harry[ind].frameNR = jump_block_l;}
              else if(level[iid].status[1][d+1]) { harry[ind].blockIND = d+1; harry[ind].frameNR = jump_block_l;}
              else if(level[iid].status[0][d]) { harry[ind].blockIND = d; harry[ind].frameNR = jump_block_u;}
              else if(level[iid].status[0][d+1]) { harry[ind].blockIND = d+1; harry[ind].frameNR = jump_block_u;}
              else return(0);
              break;
            }
    case 1 :{ if(level[iid].status[1][d]) { harry[ind].blockIND = d; harry[ind].frameNR = jump_block_l;}
              else if(level[iid].status[1][d-1]) { harry[ind].blockIND = d-1; harry[ind].frameNR = jump_block_l;}
              else if(level[iid].status[0][d]) { harry[ind].blockIND = d; harry[ind].frameNR = jump_block_u;}
              else if(level[iid].status[0][d-1]) { harry[ind].blockIND = d-1; harry[ind].frameNR = jump_block_u;}
              else return(0);
              break;
            }
    }

    return(1);
}

int def_jumpFALL(int ind,int *ID)
{
    int d,iid;

    d = harry[ind].x>>3;
    iid = harry[ind].actLEVEL + 1;

    if(level[iid].status[0][d] || level[iid].status[0][d+1]) {
            *ID = level[iid].status[0][d+1];
            return(1);
    }
    else return(0);
}

int def_walkFALL(int ind)
{
    int d,iid;

    d = harry[ind].x>>3;
    iid = harry[ind].actLEVEL;

    if(!level[iid].status[0][d] && !level[iid].status[0][d+1]) return(1);
    else return(0);
}

int check_boundary(int ind, int *l, int *r)
{
    int d,iid;

    d = (harry[ind].x+4)>>3;

    iid = harry[ind].actLEVEL;

    *l = level[iid].status[0][d];
    *r = level[iid].status[0][d+1];

}

int check_boundary2(int ind, int *l, int *r,int levADD)
{
    int d,iid;
    d = (harry[ind].x+8)>>3;
    iid = harry[ind].actLEVEL + levADD;

    *l = level[iid].status[0][d-1];
    *r = level[iid].status[0][d+1];
}
